






    





    



/*
 * WOFApp.java
 * Created on Nov 4, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;
import java.util.*;

/**
 * @author glewis
 */



public class WOFApp implements App, ProgressListener, WOFListener, Runnable

{
   public static final int JUMP_INSERTION_POINT = 4;
   public static final int MAX_JUMP_MENUS = 3;
   public static final String JUMP_HOOK_PROPERTY = "JumpMenuHook";
   public static final String JUMP_ENABLE_STRING = "Enable";
   public static final String JUMP_TEXT_PROPERTY = "JumpMenuItemText";
   public static final boolean JUMP_TERMINATES_APP = false;

   public static final String WOF_URL_PROPERTY = "WOF-URL";
   public static final char NUMBER_WILDCARD = '@';
   public static final char LETTER_WILDCARD = '*';
   public static final int DOLLARS_BUF_SIZE = 12;

   public static final int SETTING_ON = 0;
   public static final int SETTING_OFF = 1;

   public static final int SETTING_SOUND = 0;
   public static final int SETTING_MUSIC = SETTING_SOUND + 1;
   public static final int SETTING_SHOW_BONUS_HELP = SETTING_MUSIC + 1;
   public static final int NUM_SETTINGS = SETTING_SHOW_BONUS_HELP + 1;

   public static final int STORED_LAST_RANK = NUM_SETTINGS;
   public static final int STORED_BEST_RANK = STORED_LAST_RANK + 1;
   public static final int STORED_DATA_SIZE = STORED_BEST_RANK + 1;

   public static final int NUM_BUTTONS = 2;
   public static final int NUM_MENU_ITEMS = 12;
   public static final int NUM_CHECKBOXES = NUM_SETTINGS;
   public static final int NUM_BOLD_MENU_ITEMS = 2;

   public static final int STATE_SPLASH =                0;
   public static final int STATE_MAIN_MENU =             1;
   public static final int STATE_OPTIONS =               2;
   public static final int STATE_HELP_MENU =             3;
   public static final int STATE_HELP_SCREEN =           4;
   public static final int STATE_PAUSE =                 5;
   public static final int STATE_FREE_SPIN =             6;
   public static final int STATE_JACKPOT =               7;
   public static final int STATE_MESSAGES =              8;
   public static final int STATE_CATEGORY =              9;
   public static final int STATE_GAME =                  10;
   public static final int STATE_RESULTS =               11;
   public static final int STATE_BONUS_YES =             12;
   public static final int STATE_BONUS_NO =              13;
   public static final int STATE_GAME_OVER =             14;
   public static final int STATE_RANKS =                 15;
   public static final int STATE_GET_MORE =              16;
   public static final int STATE_AIR_TIME =              17;
   public static final int STATE_VERIFYING =             18;
   public static final int STATE_LOADING =               19;
   public static final int STATE_DOWNLOAD_COMPLETE =     20;
   public static final int STATE_ERROR =                 21;
   public static final int STATE_LIST =                  22;
   public static final int STATE_EXIT_MESSAGE =          23;
   public static final int STATE_PAUSE_LOADING =         24;
   public static final int STATE_EXIT =                  25;
   public static final int STATE_CANCEL_SUBSCRIPTION =   26;

   public static final int STATE_BUY_FULL =              27;
   public static final int STATE_MORE_GAMES =            28;


   public static final int SUBSTATE_GET_MORE_GAMES = -1;
   public static final int SUBSTATE_LIST = -2;
   public static final int SUBSTATE_OPTIONS_NOT_CHANGED = 0;
   public static final int SUBSTATE_OPTIONS_CHANGED = 1;
   public static final int SUBSTATE_LIST_MESSAGES = 0;
   public static final int SUBSTATE_GAME_MESSAGES = 1;
   public static final int SUBSTATE_GAME_DESCRIPTION = 2;

   public static final int WINDOW_ROUND_TITLE = 0x14;
   public static final int WINDOW_ALIGN_LEFT = 0x08; // automatic 1 item, a text box
   public static final int WINDOW_NO_TITLE = 0x10;
   public static final int WINDOW_NO_BANNER = 0x20;
   public static final int WINDOW_POPUP = 0x40;
   public static final int WINDOW_TYPE_MASK = 0x03;

   public static final int WINDOW_MENU = 0; // x items
   public static final int WINDOW_TEXT = 1; // automatic 1 item, a text box
   public static final int WINDOW_SPECIAL = 2; // automatic 0 items

   // type, [title], num items, (item,[state])s, num buttons, (button,state)s, (back state)
   // special, [title], num buttons, (button,state)s, back state

   public static final byte[][] WINDOW_DATA = new byte[][] {
      // STATE_SPLASH
      {WINDOW_SPECIAL|WINDOW_NO_TITLE|WINDOW_NO_BANNER, 
         0, 
         STATE_EXIT_MESSAGE},
      // STATE_MAIN_MENU
      {WINDOW_MENU|WINDOW_NO_TITLE,

   
         5,
         WOFConstants.STRING_BUY_FULL, STATE_BUY_FULL,
         WOFConstants.STRING_PLAY, STATE_MESSAGES,
   













         WOFConstants.STRING_HELP, STATE_HELP_MENU,
         WOFConstants.STRING_OPTIONS, STATE_OPTIONS,
         WOFConstants.STRING_EXIT, STATE_EXIT_MESSAGE,
         0,
         STATE_EXIT_MESSAGE},
      // STATE_OPTIONS
      {WINDOW_SPECIAL,
         WOFConstants.STRING_VERSION,
         1,
         WOFConstants.STRING_OK, STATE_MAIN_MENU,
         STATE_MAIN_MENU},
      // STATE_HELP_MENU
      {WINDOW_MENU,
         WOFConstants.STRING_HELP,
         5,
         WOFConstants.STRING_HELP_1, STATE_HELP_SCREEN,
         WOFConstants.STRING_HELP_2, STATE_HELP_SCREEN,
         WOFConstants.STRING_HELP_3, STATE_HELP_SCREEN,
         WOFConstants.STRING_HELP_4, STATE_HELP_SCREEN,
         WOFConstants.STRING_MAIN_MENU, STATE_MAIN_MENU,
         0,
         STATE_MAIN_MENU},
      // STATE_HELP_SCREEN
      {WINDOW_TEXT | WINDOW_ALIGN_LEFT,
         WOFConstants.STRING_HELP_1,
         WOFConstants.STRING_HELP_1_TEXT,
         1,
         WOFConstants.STRING_BACK, STATE_HELP_MENU,
         STATE_HELP_MENU},
      // STATE_PAUSE
      {WINDOW_MENU | WINDOW_NO_TITLE | WINDOW_POPUP | WINDOW_NO_BANNER,
         3,
         WOFConstants.STRING_PAUSED_RESUME, STATE_GAME,
         WOFConstants.STRING_PAUSED_HELP, STATE_HELP_SCREEN,
         WOFConstants.STRING_PAUSED_QUIT, STATE_MAIN_MENU,
         0,
         STATE_GAME},
      // STATE_FREE_SPIN
      {WINDOW_TEXT | WINDOW_NO_TITLE | WINDOW_POPUP | WINDOW_NO_BANNER,
         WOFConstants.STRING_USE_FREE_SPIN,
         2,
         WOFConstants.STRING_YES, STATE_GAME,
         WOFConstants.STRING_NO, STATE_GAME,
         STATE_GAME},
      // STATE_JACKPOT_SOLVE
      {WINDOW_TEXT | WINDOW_NO_TITLE | WINDOW_POPUP | WINDOW_NO_BANNER,
         WOFConstants.STRING_JACKPOT_SOLVE,
         2,
         WOFConstants.STRING_YES, STATE_GAME,
         WOFConstants.STRING_NO, STATE_GAME,
         STATE_GAME},
      // STATE_MESSAGES
      {WINDOW_SPECIAL|WINDOW_NO_TITLE,
         1,
         WOFConstants.STRING_OK, STATE_MESSAGES,
         STATE_MESSAGES},
      // STATE_CATEGORY
      {WINDOW_SPECIAL|WINDOW_ROUND_TITLE|WINDOW_NO_BANNER,
         1,
         WOFConstants.STRING_OK, STATE_GAME, STATE_MAIN_MENU},
      // STATE_GAME
      {WINDOW_SPECIAL|WINDOW_NO_TITLE|WINDOW_NO_BANNER,0,STATE_PAUSE},
      // STATE_RESULTS
      {WINDOW_SPECIAL|WINDOW_ROUND_TITLE|WINDOW_NO_BANNER,
         1,
         WOFConstants.STRING_OK, STATE_GAME_OVER,
         STATE_GAME_OVER},
      // STATE_BONUS_YES
      {WINDOW_TEXT|WINDOW_NO_BANNER|WINDOW_ROUND_TITLE,
         WOFConstants.STRING_BONUS_QUALIFY,
         1,
         WOFConstants.STRING_OK, STATE_CATEGORY,
         STATE_CATEGORY},
      // STATE_BONUS_NO
      {WINDOW_TEXT|WINDOW_NO_BANNER|WINDOW_ROUND_TITLE,
         WOFConstants.STRING_BONUS_NO_QUALIFY,
         1,
         WOFConstants.STRING_OK, STATE_GAME_OVER,
         STATE_GAME_OVER},
      // STATE_GAME_OVER
      {WINDOW_SPECIAL|WINDOW_NO_BANNER,
         WOFConstants.STRING_GAME_OVER,
         1,
         WOFConstants.STRING_OK, STATE_RANKS,
         STATE_RANKS},
      // STATE_RANKS
      {WINDOW_SPECIAL|WINDOW_NO_BANNER,
         WOFConstants.STRING_RANK,
         2,
         WOFConstants.STRING_REPLAY, STATE_MESSAGES,
         WOFConstants.STRING_MENU, STATE_MAIN_MENU,
         STATE_MAIN_MENU},
      // STATE_GET_MORE
      {WINDOW_TEXT,
         WOFConstants.STRING_PLAY,
         WOFConstants.STRING_PLAYED_ALL,
         2,
         WOFConstants.STRING_REPLAY_SAME, STATE_MESSAGES,
         WOFConstants.STRING_GET_MORE, STATE_VERIFYING,//STATE_AIR_TIME,
         STATE_MAIN_MENU},
      // STATE_AIR_TIME
      {WINDOW_TEXT | WINDOW_ALIGN_LEFT,
         WOFConstants.STRING_CONFIRM_TITLE,
         WOFConstants.STRING_CONFIRM_TEXT,
         2,
         WOFConstants.STRING_YES, STATE_VERIFYING,
         WOFConstants.STRING_NO, STATE_MAIN_MENU,
         STATE_MAIN_MENU},
      // STATE_VERIFYING
      {WINDOW_TEXT,
         WOFConstants.STRING_VERIFYING_TITLE,
         WOFConstants.STRING_VERIFYING_TEXT,
         0, STATE_MAIN_MENU},
      // STATE_LOADING
      {WINDOW_TEXT,
         WOFConstants.STRING_DOWNLOADING_TITLE,
         WOFConstants.STRING_DOWNLOADING_TEXT,
         0, STATE_MAIN_MENU},
      // STATE_DOWNLOAD_COMPLETE
      {WINDOW_TEXT,
         WOFConstants.STRING_DOWNLOADING_TITLE,
         WOFConstants.STRING_DOWNLOAD_COMPLETE,
         1,
         WOFConstants.STRING_OK, STATE_MESSAGES,
         STATE_MESSAGES},
      // STATE_ERROR
      {WINDOW_TEXT,
         WOFConstants.STRING_ERROR_TITLE,
         WOFConstants.STRING_ERROR_TEXT,
         1, WOFConstants.STRING_OK, STATE_MAIN_MENU,
         STATE_MAIN_MENU},
      // STATE_LIST
      {WINDOW_SPECIAL,
         WOFConstants.STRING_DOWNLOADING_TITLE,
         0, STATE_MAIN_MENU},
      // STATE_EXIT_MESSAGE

   
      {WINDOW_MENU,
         WOFConstants.STRING_EXIT,
         2,
         WOFConstants.STRING_BUY_FULL, STATE_BUY_FULL,
         WOFConstants.STRING_EXIT, STATE_EXIT,
         0,
         STATE_MAIN_MENU},
   


















      // STATE_PAUSE_LOADING
      {WINDOW_MENU | WINDOW_NO_TITLE | WINDOW_POPUP | WINDOW_NO_BANNER,
         2,
         WOFConstants.STRING_PAUSED_RESUME, STATE_AIR_TIME,
         WOFConstants.STRING_PAUSED_QUIT, STATE_MAIN_MENU,
         0,
         STATE_MAIN_MENU},
   };


   public static byte[] origMainMenuData;

   public static AppCanvas canvas;
   public static WOFApp instance;

   public int state;
   public int substate;
   public boolean paused;
   public boolean destroyed;
   public boolean gameInProgress;
   public byte lastGameRank;

   public Resources resources; // temporary - only during startup
   public WOFData wofData;
   public static WOFGameState gameState;
   public WOFView wofView;

   public Window window;
   public TextComponent title;
   public TextComponent footer;
   public TextComponent textBox;
   public ProgressBar progressBar;
   public WOFRankSpacer rankSpacer1;
   public WOFRankSpacer rankSpacer2;
   public WOFRankSpacer rankSpacer3;
   public TextComponent[] menuItems;
   public TextComponent[] boldMenuItems;
   public TextComponent[] buttons;
   public TextComponent[] checkboxes;

   public short bannerHeight;
   public short bannerWidth;
   public boolean showBanner;
   public WOFMessage curMessage;
   public byte[][] jumpText;

   public byte roundTitleIndex;
   public byte turnsIndex;
   public byte letterCountIndex;
   public byte chooseConsonantsIndex;
   public byte rstlneIndex;
   public byte noLettersIndex;
   public byte oneLetterIndex;
   public byte nLettersIndex;

   //  public Sound curSound;

   public byte[] dollarsBuf1 = new byte[DOLLARS_BUF_SIZE];
   public byte[] dollarsBuf2 = new byte[DOLLARS_BUF_SIZE];

   public WOFApp() {
   }

   public static WOFApp getInstance() 
   {
      return new WOFApp();
   }

   public void setAppCanvas(AppCanvas ac) throws Throwable 
   {
      instance = this;
      canvas = ac;

      wofData = new WOFData(canvas.midlet.getProperty(WOF_URL_PROPERTY), STORED_DATA_SIZE, canvas.midlet);
      wofData.progress.addProgressListener(this);

      resources = new Resources();
      resources.init();
      resources.loadSounds();
   }

   public void runThread() throws Throwable 
   {
      if (WOFConstants.GAME_VERSION == WOFConstants.VERSION_LARGE)
      {
         synchronized (this) 
         {
            try {
               resources.loadImages();
               resources.loadStrings();
               resources.close();
            }
            finally {
               resources = null;
               notifyAll();
            }
         }
      }
   }

   public static void playSound(int sound, boolean isMusic) 
   {
      if (WOFData.settings[isMusic ? SETTING_MUSIC : SETTING_SOUND] == SETTING_ON) Resources.playSound(sound);
   }

   public void splashDisplayed(int index) throws Throwable 
   {
      if (index != WOFConstants.NUM_SPLASH_SCREENS) {
         return;
      }
      canvas.background = null;
      playSound(WOFConstants.SOUND_TITLE, true);

      if (WOFConstants.GAME_VERSION == WOFConstants.VERSION_LARGE) {
         synchronized (this) {
            while (resources != null) {
               wait();
            }
         }
      }
      else {
         resources.loadImages();
         resources.loadStrings();
         resources.close();
         resources = null;
      }

      if (WOFConstants.USE_BANNER) {
         bannerHeight = (short) (Resources.images[WOFConstants.IMAGE_BANNER].getHeight() - WOFConstants.BANNER_OVERLAP);
         bannerWidth = (short) Resources.images[WOFConstants.IMAGE_BANNER].getWidth();
      }
      else {
         bannerHeight = 0;
         bannerWidth = canvas.width;
      }

      gameState = new WOFGameState(this);

      roundTitleIndex = indexOf(WOFConstants.STRING_ROUND, NUMBER_WILDCARD);
      turnsIndex = indexOf(WOFConstants.STRING_ROUND, NUMBER_WILDCARD);
      letterCountIndex = indexOf(WOFConstants.STRING_ROUND, NUMBER_WILDCARD);
      chooseConsonantsIndex = indexOf(WOFConstants.STRING_ROUND, NUMBER_WILDCARD);
      rstlneIndex = indexOf(WOFConstants.STRING_ROUND, LETTER_WILDCARD);
      noLettersIndex = indexOf(WOFConstants.STRING_ROUND, LETTER_WILDCARD);
      oneLetterIndex = indexOf(WOFConstants.STRING_ROUND, LETTER_WILDCARD);
      nLettersIndex = indexOf(WOFConstants.STRING_ROUND, LETTER_WILDCARD);


      window = new Window(null, WOFConstants.WINDOW_BORDER_NO_TITLE, WOFConstants.CONTENT_AREA_BORDER, WOFConstants.SCROLL_BAR_BORDER, WOFConstants.SCROLL_SLIDER_BORDER, WOFConstants.BUTTON_AREA_BORDER, WOFConstants.WINDOW_COLOR, WOFConstants.CONTENT_AREA_COLOR, WOFConstants.BUTTON_AREA_COLOR, WOFConstants.SCROLL_BAR_COLOR, WOFConstants.SCROLL_SLIDER_COLOR);
      title = new TextComponent(null, 0, 0, WOFConstants.TITLE_STYLE, Border.newInsets(0, 0, WOFConstants.TITLE_INSET_TOP, WOFConstants.TITLE_INSET_BOTTOM));

      textBox = new TextComponent(null, 0, 0, WOFConstants.TEXT_BOX_STYLE, WOFConstants.MENU_ITEM_BORDER);
      textBox.focusBorder = WOFConstants.BUTTON_BORDER;
      textBox.interactive = false;
      textBox.lineSpans = new short[2 * WOFConstants.MAX_TEXT_BOX_LINES + 1];
      textBox.lineSpans[0] = -1;

      if (WOFConstants.MAX_FOOTER_LINES > 0) {
         footer = new TextComponent(null, 0, 0, WOFConstants.FOOTER_STYLE, Border.NULL_BORDER);
         footer.lineSpans = new short[2 * WOFConstants.MAX_FOOTER_LINES + 1];
         footer.lineSpans[0] = -1;
      }

      progressBar = new ProgressBar(wofData.progress, WOFConstants.PROGRESS_OUTER_BORDER, WOFConstants.PROGRESS_BORDER,
                                    WOFConstants.PROGRESS_FULL_COLOR, WOFConstants.PROGRESS_EMPTY_COLOR);
      progressBar.h = WOFConstants.PROGRESS_BAR_HEIGHT;

      rankSpacer1 = new WOFRankSpacer();
      rankSpacer2 = new WOFRankSpacer();
      rankSpacer3 = new WOFRankSpacer();

      buttons = new TextComponent[NUM_BUTTONS];
      TextComponent c;
      for (int i = NUM_BUTTONS; --i >= 0;) {
         c = new TextComponent(null, 0, 0, WOFConstants.BUTTON_STYLE, WOFConstants.BUTTON_BORDER);
         c.bgColor = WOFConstants.BUTTON_COLOR;
         c.interactive = true;
         buttons[i] = c;
      }
      menuItems = new TextComponent[NUM_MENU_ITEMS];
      for (int i = NUM_MENU_ITEMS; --i >= 0;) {
         c = new TextComponent(null, 0, 0, WOFConstants.MENU_ITEM_STYLE, WOFConstants.MENU_ITEM_BORDER);
         c.focusBorder = WOFConstants.BUTTON_BORDER;
         c.lineSpans = new short[2 * WOFConstants.MAX_MENU_ITEM_LINES + 1];
         c.lineSpans[0] = -1;
         menuItems[i] = c;
      }

      boldMenuItems = new TextComponent[NUM_BOLD_MENU_ITEMS];
      for (int i = NUM_BOLD_MENU_ITEMS; --i >= 0;) {
         c = new TextComponent(null, 0, 0, WOFConstants.BOLD_MENU_ITEM_STYLE, WOFConstants.MENU_ITEM_BORDER);
         c.focusBorder = WOFConstants.BUTTON_BORDER;
         c.bgColor = WOFConstants.MENU_ITEM_COLOR;
         c.lineSpans = new short[2 * WOFConstants.MAX_BOLD_MENU_ITEM_LINES + 1];
         c.lineSpans[0] = -1;
         boldMenuItems[i] = c;
      }

      checkboxes = new TextComponent[NUM_CHECKBOXES];
      for (int i = NUM_CHECKBOXES; --i >= 0;) {
         c = new TextComponent(null, 0, 0, WOFConstants.CHECKBOX_STYLE, WOFConstants.CHECKBOX_BORDER);
         c.focusBorder = WOFConstants.BUTTON_BORDER;
         c.interactive = true;
         c.bgColor = WOFConstants.MENU_ITEM_COLOR;
         c.lineSpans = new short[2 * WOFConstants.MAX_CHECKBOX_LINES + 1];
         c.lineSpans[0] = -1;
         checkboxes[i] = c;
      }

      if (MAX_JUMP_MENUS > 0) {
         int numJumpMenuItems = 0;
         while (numJumpMenuItems < MAX_JUMP_MENUS) {
            String s = canvas.midlet.getProperty(JUMP_HOOK_PROPERTY + (
                                                                      (numJumpMenuItems == 0)
                                                                      ? ""
                                                                      : ("" + (char) ('1' + numJumpMenuItems))));
            if ((s == null) || !s.equals(JUMP_ENABLE_STRING)) {
               break;
            }
            numJumpMenuItems++;
         }
         if (numJumpMenuItems > 0) {
            if (origMainMenuData == null) {
               origMainMenuData = WINDOW_DATA[STATE_MAIN_MENU];
            }
            byte[] newMainMenuWindowData = new byte[origMainMenuData.length + 2 * numJumpMenuItems];
            index = 2 + 2 * (JUMP_INSERTION_POINT);
            System.arraycopy(origMainMenuData, 0, newMainMenuWindowData, 0, 2 + 2 * (JUMP_INSERTION_POINT));
            newMainMenuWindowData[1] += numJumpMenuItems;
            System.arraycopy(origMainMenuData, index,
                             newMainMenuWindowData, index + 2 * numJumpMenuItems,
                             origMainMenuData.length - index);
            jumpText = new byte[numJumpMenuItems][];
            for (int i = 0; i < numJumpMenuItems; i++) {
               newMainMenuWindowData[index++] = (byte) (-1 - i);
               newMainMenuWindowData[index++] = (byte) (-1 - i);
               jumpText[i] = canvas.midlet.getProperty(JUMP_TEXT_PROPERTY
                                                       + ((i == 0)
                                                          ? ""
                                                          : ("" + (char) ('1' + i)))).getBytes();
            }
            WINDOW_DATA[STATE_MAIN_MENU] = newMainMenuWindowData;
         }
      }
      wofView = new WOFView(gameState, canvas);
   }

   public void setupMenus(int state) 
   {
      byte[] windowData = WINDOW_DATA[state];
      int windowType = windowData[0]&0xFF;
      int index = 1;
      int oldItemFocus = window.focus;
      int oldButtonFocus = oldItemFocus - window.numInteractive;
      window.clear();
      textBox.bgColor = WOFConstants.MENU_ITEM_COLOR;
      showBanner = WOFConstants.USE_BANNER && ((windowType & WINDOW_POPUP) == 0) && (canvas.height >= WOFConstants.MIN_BANNER_YES) && ((canvas.height > WOFConstants.MAX_BANNER_NO) || ((windowType & WINDOW_NO_BANNER) == 0));
      window.contentArea.bgColor = WOFConstants.CONTENT_AREA_COLOR;
      if ((windowType & WINDOW_POPUP) == 0) {
         window.y = showBanner ? bannerHeight : 0;
         window.h = (short) (canvas.height - window.y);
         window.x = 0;
         window.w = canvas.width;
      }
      else {
         window.x = (short) ((canvas.width - WOFConstants.POPUP_WIDTH) / 2);
         window.y = (short) ((canvas.height - WOFConstants.POPUP_HEIGHT) / 2);
         window.w = WOFConstants.POPUP_WIDTH;
         window.h = WOFConstants.POPUP_HEIGHT;
      }
      if ((windowType & WINDOW_NO_TITLE) == 0) {
         title.setText(Resources.strings[windowData[index++]&0xFF]);
         window.setTitle(title);
         window.setBorder(WOFConstants.WINDOW_BORDER);
      }
      else {
         window.setBorder(WOFConstants.WINDOW_BORDER_NO_TITLE);
         if ((windowType & WINDOW_ROUND_TITLE) == WINDOW_ROUND_TITLE) {
            int roundNum = gameState.round.roundNumber;
            if (roundNum == WOFGame.BONUS_ROUND) {
               title.setText(Resources.strings[WOFConstants.STRING_BONUS]);
            }
            else {
               setText(title, WOFConstants.STRING_ROUND, roundNum + '1', roundTitleIndex);
            }
            window.setTitle(title);
         }
      }
      switch (windowType & WINDOW_TYPE_MASK)
      {
         case WINDOW_MENU:
            window.maxSpacing = WOFConstants.WINDOW_MENU_SPACING;
            int numMenuItem = windowData[index++]&0xFF;
            for (int i = 0; i < numMenuItem; i++)
            {
               //System.out.println(i+" "+Resources.strings[windowData[index]&0xFF]);
               if ((MAX_JUMP_MENUS > 0) && ((windowData[index]&0xFF) < 0))
                  menuItems[i].setText(jumpText[-1 - (windowData[index]&0xFF)]);
               else
                  menuItems[i].setText(Resources.strings[windowData[index]&0xFF]);

               menuItems[i].bgColor = WOFConstants.MENU_ITEM_COLOR;
               menuItems[i].interactive = true;
               window.add(menuItems[i]);
               index += 2;
            }
            break;

         case WINDOW_TEXT:
            textBox.setText(Resources.strings[windowData[index++]&0xFF]);
            textBox.bgColor = WOFConstants.MENU_ITEM_COLOR;
            textBox.style = (short) ((textBox.style & ~TextComponent.ALIGN_MASK)
                                     | (((windowType & WINDOW_ALIGN_LEFT) == 0)
                                        ? TextComponent.ALIGN_CENTER
                                        : TextComponent.ALIGN_LEFT));
            window.add(textBox);
            // intentionally fall through
         default:
            window.maxSpacing = WOFConstants.DEFAULT_MAX_SPACING;
            break;
      }
      int numButtons = windowData[index++];
      for (int i = 0; i < numButtons; i++)
      {
         buttons[i].setText(Resources.strings[windowData[index]]);
         buttons[i].bgColor = WOFConstants.BUTTON_COLOR;
         window.addButton(buttons[i]);
         index += 2;
      }

      switch (state) {
         case STATE_HELP_SCREEN:
            if (this.state == STATE_HELP_MENU) {
               title.setText(Resources.strings[WOFConstants.STRING_HELP_1 + oldItemFocus]);
               textBox.setText(Resources.strings[WOFConstants.STRING_HELP_1_TEXT + oldItemFocus]);
            }
            break;
         case STATE_LOADING:

            if (substate == SUBSTATE_LIST) {
               title.setText(Resources.strings[WOFConstants.STRING_CONNECTING_TITLE]);
               textBox.setText(Resources.strings[WOFConstants.STRING_CONNECTING_TEXT]);
            }







            // intentionally fall through
         case STATE_VERIFYING:

            window.add(progressBar);
            break;








         case STATE_OPTIONS:
            window.maxSpacing = WOFConstants.WINDOW_OPTIONS_SPACING;
            for (int i = 0; i < NUM_SETTINGS; i++) {
               checkboxes[i].setText(Resources.strings[WOFConstants.FIRST_SETTING_STRING + i]);
               if (WOFData.settings[i] == SETTING_ON) {
                  checkboxes[i].style |= TextComponent.CHECKED;
               }
               else {
                  checkboxes[i].style &= ~TextComponent.CHECKED;
               }
               window.add(checkboxes[i]);
            }
            break;
         case STATE_LIST:
            for (int i = 0; i < wofData.packListSize; i++) {
               menuItems[i].bgColor = wofData.packListColors[i];
               menuItems[i].setText(wofData.packListNames[i], 0, wofData.packListNameLengths[i]);
               menuItems[i].interactive = true;
               window.add(menuItems[i]);
               window.focus = 0;
            }
            if (WOFConstants.MAX_FOOTER_LINES > 0) {
               window.footerAreaHeight = (short) (WOFConstants.MAX_FOOTER_LINES * (WOFConstants.FONT_HEIGHTS[WOFConstants.FOOTER_FONT] + WOFConstants.FONT_VERTICAL_SPACINGS[WOFConstants.FOOTER_FONT]) - WOFConstants.FONT_VERTICAL_SPACINGS[WOFConstants.FOOTER_FONT]);
               window.footer = footer;
               updateFooterText();
            }
            break;

         case STATE_MESSAGES:
            if (curMessage != null) {
               title.setText(curMessage.title, 0, curMessage.titleLen);
               window.setTitle(title);
               textBox.setText(curMessage.message, 0, curMessage.messageLen);
               textBox.bgColor = curMessage.color;
               window.contentArea.bgColor = curMessage.color;
            }
            else {
               WOFGame game = wofData.getNextGame();
               textBox.setText(game.pack.description, 0, game.pack.descriptionLength);
            }
            window.add(textBox);
            break;
         case STATE_CATEGORY:
            menuItems[0].interactive = false;
            menuItems[0].bgColor = WOFConstants.MENU_ITEM_COLOR;
            menuItems[0].setText(Resources.strings[WOFConstants.STRING_CATEGORY]);
            window.add(menuItems[0]);
            boldMenuItems[0].setText(gameState.round.category, 0, gameState.round.categoryLen);
            window.add(boldMenuItems[0]);
            break;
         case STATE_RESULTS:
            menuItems[0].interactive = false;
            menuItems[0].bgColor = WOFConstants.MENU_ITEM_COLOR;
            if (gameState.solved && (gameState.money < WOFGameState.MIN_WINNINGS)) {
               gameState.money = WOFGameState.MIN_WINNINGS;
               gameState.totalMoney += gameState.money;
               menuItems[0].setText(Resources.strings[WOFConstants.STRING_MIN_WINNINGS]);
               window.add(menuItems[0]);
               rankSpacer1.setSpacer(WOFConstants.RESULTS_GAP);
               window.add(rankSpacer1);
            }
            else {
               if (!gameState.solved) {
                  gameState.money = 0;
               }
               gameState.totalMoney += gameState.money;
               menuItems[0].setText(Resources.strings[WOFConstants.STRING_WINNINGS]);
               window.add(menuItems[0]);
               setDollars(boldMenuItems[0], dollarsBuf1, gameState.money);
               window.add(boldMenuItems[0]);
            }
            if (gameState.round.roundNumber != WOFGame.BONUS_ROUND) {
               menuItems[1].interactive = false;
               menuItems[1].bgColor = WOFConstants.MENU_ITEM_COLOR;
               menuItems[1].setText(Resources.strings[WOFConstants.STRING_TOTAL_WINNINGS]);
               window.add(menuItems[1]);
               setDollars(boldMenuItems[1], dollarsBuf2, gameState.totalMoney);
               window.add(boldMenuItems[1]);
            }
            break;

         case STATE_GAME_OVER:
            boldMenuItems[0].setText(Resources.strings[WOFConstants.STRING_RANK_0 + WOFData.settings[STORED_LAST_RANK]]);
            window.add(boldMenuItems[0]);
            menuItems[0].interactive = false;
            menuItems[0].bgColor = WOFConstants.MENU_ITEM_COLOR;
            menuItems[0].setText(Resources.strings[WOFConstants.STRING_GRAND_TOTAL]);
            window.add(menuItems[0]);
            setDollars(boldMenuItems[1], dollarsBuf2, gameState.totalMoney);
            window.add(boldMenuItems[1]);
            rankSpacer1.setSpacer(WOFConstants.YOUR_RANK_GAP);
            window.add(rankSpacer1);
            menuItems[1].interactive = false;
            menuItems[1].bgColor = WOFConstants.MENU_ITEM_COLOR;
            menuItems[1].setText(Resources.strings[WOFConstants.STRING_YOUR_RANK]);
            window.add(menuItems[1]);
            rankSpacer2.setRank(WOFData.settings[STORED_LAST_RANK]);
            window.add(rankSpacer2);
            break;

         case STATE_RANKS:
            rankSpacer1.setRank(WOFData.settings[STORED_LAST_RANK]);
            rankSpacer2.setRank(lastGameRank);
            rankSpacer3.setRank(WOFData.settings[STORED_BEST_RANK]);
            menuItems[0].setText(Resources.strings[WOFConstants.STRING_CURRENT_RANK]);
            menuItems[0].interactive = false;
            menuItems[0].bgColor = WOFConstants.MENU_ITEM_COLOR;
            window.add(menuItems[0]);
            window.add(rankSpacer1);
            menuItems[1].setText(Resources.strings[WOFConstants.STRING_LAST_RANK]);
            menuItems[1].interactive = false;
            menuItems[1].bgColor = WOFConstants.MENU_ITEM_COLOR;
            window.add(menuItems[1]);
            window.add(rankSpacer2);
            menuItems[2].interactive = false;
            menuItems[2].bgColor = WOFConstants.MENU_ITEM_COLOR;
            menuItems[2].setText(Resources.strings[WOFConstants.STRING_BEST_RANK]);
            window.add(menuItems[2]);
            window.add(rankSpacer3);
            break;
         case STATE_ERROR:
            if (Config.USE_NOKIA_MRC) {
               int str;
               switch (wofData.subscription.getState()) {
                  case Subscription.STATE_EXPIRED:
                     str = WOFConstants.STRING_SUBSCRIPTION_EXPIRED;
                     break;
                  case Subscription.STATE_VALID:
                     str = WOFConstants.STRING_ERROR_TEXT;
                     break;
                  default:
                     str = WOFConstants.STRING_SUBSCRIPTION_ERROR;
               }
               textBox.setText(Resources.strings[str]);
            }
            break;






















      }
   }

   public static int setDollars(TextComponent c, byte[] buf, int dollars) {
      buf[0] = '$';
      int numDigits = 0;
      int val = dollars;
      while (val > 0) {
         val /= 10;
         numDigits++;
      }
      if (numDigits == 0) {
         numDigits = 1;
      }
      int len = numDigits + 1;
      if (c != null) {
         c.setText(buf, 0, len);
      }
      while (numDigits > 0) {
         buf[numDigits--] = (byte) ('0' + (dollars % 10));
         dollars /= 10;
      }
      return len;
   }

   public void setText(TextComponent c, int resourceID, int val, int position) {
      byte[] res = Resources.strings[resourceID];
      if (position >= 0) {
         res[position] = (byte) val;
      }
      c.setText(res, 0, res.length);
   }

   public static byte indexOf(int resource, char c) {
      byte[] str = Resources.strings[resource];
      int len = str.length;
      for (int i = 0; i < len; i++) {
         if (str[i] == c) {
            return(byte) i;
         }
      }
      return -1;
   }

   public void updateFooterText() {
      int index = window.focus;
      if (index >= 0) {
         footer.setText(wofData.packListDescriptions[index], 0, wofData.packListDescriptionLengths[index]);
      }
      else {
         footer.setText(null, 0, 0);
      }
      window.validateFooter();
   }






   public void setState(int state) {

      //System.out.println(STATE_GL_VIEW+" "+state+" "+this.state);
      switch (state)
      {

         case STATE_BUY_FULL:
            try {
               wof2005._main.platformRequest(wof2005._main.getAppProperty("Buy-Full-Version-URL"));
            }
            catch (Exception e) {
               ;
            }
            canvas.destroy(true);
            return;

         case STATE_MORE_GAMES:
            try {
               wof2005._main.platformRequest(wof2005._main.getAppProperty("Get-More-Games-URL"));
            }
            catch (Exception e) {
               ;
            }
            canvas.destroy(true);
            return;

         case STATE_EXIT:
            canvas.destroy(true);
            return;

         case STATE_MAIN_MENU:
            Resources.copySFX = -1;
            gameInProgress = false;
            if (((this.state == STATE_LOADING) || (this.state == STATE_VERIFYING)) && !wofData.cancelRequest())
               return;
            else if ((this.state == STATE_OPTIONS) && (this.substate == SUBSTATE_OPTIONS_CHANGED))
            {
               try {
                  for (int i = NUM_SETTINGS; --i >= 0;)
                     WOFData.settings[i] = (byte) (((checkboxes[i].style & TextComponent.CHECKED) == 0) ? SETTING_OFF : SETTING_ON);
                  wofData.storeSettings();
               }
               catch (Exception e) { 
                  ;
               }
            }
            break;

         case STATE_DOWNLOAD_COMPLETE:
            try {
               wofData.store();
            }
            catch (Exception e) {
               ;
            }
            break;

         case STATE_MESSAGES:
            gameInProgress = false;
            if (this.state == STATE_GET_MORE) {
               wofData.replayGames();
               if (wofData.getNextGame() == null)
                  setState(STATE_MAIN_MENU);
               else
               {
                  try {
                     wofData.store();
                  }
                  catch (Exception e) {
                     ;
                  }
               }
            }
            if (((this.state == STATE_LOADING) && wofData.parsedList) ||
                ((this.state == STATE_MESSAGES) && (substate == SUBSTATE_LIST_MESSAGES))) {
               curMessage = wofData.getNextMessage(WOFData.MESSAGE_TYPE_LIST);
               if (curMessage == null) {
                  setState(STATE_LIST);
                  return;
               }
               substate = SUBSTATE_LIST_MESSAGES;
            }
            else
            {
               curMessage = wofData.getNextMessage(WOFData.MESSAGE_TYPE_GAME);
               if ((this.state == STATE_MESSAGES) && (substate == SUBSTATE_GAME_MESSAGES) && (curMessage == null))
               {
                  try { 
                     wofData.store();
                  }
                  catch (Exception e) { 
                     ;
                  }
               }
               if (curMessage == null)
               {
                  WOFGame game = wofData.getNextGame();
                  if (((this.state == STATE_MESSAGES) && (substate == SUBSTATE_GAME_DESCRIPTION)) || ((game != null) && ((game.gameID != 0) || (game.pack.descriptionLength <= 0))))
                  {
                     gameState.init(game.rounds[0]); //game.rounds[WOFGame.BONUS_ROUND]);
                     setState(STATE_CATEGORY);
                     return;
                  }
                  else if (game == null)
                  {
                     ///#if !DEMO
                     setState(STATE_GET_MORE);
                     return;
                     //#else
                     //wofData.replayGames();
                     //try { wofData.store(); } catch (Exception e) { }
                     //return;
                     //#endif
                  }
                  else
                  {
                     substate = SUBSTATE_GAME_DESCRIPTION;
                  }
               }
               else
               {
                  substate = SUBSTATE_GAME_MESSAGES;
               }
            }
            break;

         case STATE_AIR_TIME:
            switch (this.state) {
               case STATE_GET_MORE:
                  substate = SUBSTATE_GET_MORE_GAMES;
                  break;
               case STATE_MAIN_MENU:
                  substate = SUBSTATE_LIST;
                  break;
               case STATE_LIST:
                  substate = wofData.packListIDs[window.focus];
                  break;
            }
            break;

         case STATE_HELP_MENU:
            if (gameInProgress) {
               gameState.oldState = -1;
               if ( gameState.state == WOFGameState.STATE_POWER || gameState.state == WOFGameState.STATE_SPIN ) repaint = true;
               setState(STATE_PAUSE);
               return;
            }
            break;

         case STATE_GAME:
            gameState.oldState = -1;
            gameState.resume(window.focus == 0);
            Resources.fromPause();
            gameInProgress = true;
            break;

         case STATE_GAME_OVER:
            if (gameState.round.roundNumber == WOFGame.BONUS_ROUND)
            {
               if (gameState.solved)
               {
                  gameState.totalMoney += gameState.money;
               }
            }
            else if (this.state == STATE_RESULTS)
            {
               int newRound = gameState.round.roundNumber + 1;
               gameState.init(gameState.round.game.rounds[newRound]);
               if (newRound == WOFGame.BONUS_ROUND)
               {
                  if (gameState.totalMoney == 0)
                  {
                     setState(STATE_BONUS_NO);
                     return;
                  }
                  else if (WOFData.settings[SETTING_SHOW_BONUS_HELP] == SETTING_ON)
                  {
                     setState(STATE_BONUS_YES);
                     return;
                  }
               }
               setState(STATE_CATEGORY);
               return;
            }
            try {
               lastGameRank = WOFData.settings[STORED_LAST_RANK];
               WOFData.settings[STORED_LAST_RANK] = WOFRankSpacer.getRank(gameState.totalMoney);
               if (WOFData.settings[STORED_BEST_RANK] < WOFData.settings[STORED_LAST_RANK]) {
                  WOFData.settings[STORED_BEST_RANK] = WOFData.settings[STORED_LAST_RANK];
               }
               wofData.finishedGame();
               wofData.store();
               wofData.storeSettings();
            }
            catch (Exception e) {
               ;
            }
            break;
         case STATE_OPTIONS:
            substate = SUBSTATE_OPTIONS_NOT_CHANGED;
            break;
         case STATE_VERIFYING:
//                System.out.println("substate = " + substate);
            if (substate == SUBSTATE_GET_MORE_GAMES) {
               wofData.requestMoreGames();
            }
            else if (substate == SUBSTATE_LIST) {
               wofData.requestList();
            }
            else {
               wofData.requestPack(substate);
            }
            break;
      }
      setupMenus(state);
      this.state = state;
      canvas.repaint();
   }

   public void start() throws Throwable 
   {




      setState(STATE_MAIN_MENU);

   }

   boolean pausing;
   public void pause() 
   {
      pausing = true;
      //System.out.println("pause");
      Resources.toPause();
   }

   public static boolean repaint;
   public void resume() 
   {
      //WOFConstants.UPDATE_BAR=1;
      if (state == STATE_GAME)
      {
         if ( gameState.state == WOFGameState.STATE_POWER || gameState.state == WOFGameState.STATE_SPIN )
            repaint = true;
         setState(STATE_PAUSE);
         gameState.oldState = -1;
      }
      pausing = false;
      //flushGraphics();
   }

   public void destroy() {
      wofData.destroy();
   }

   /**
    * network progress
    */
   public void progressChanged(ProgressMonitor monitor) {
      if ((state == STATE_LOADING) || (state == STATE_VERIFYING)) {
         try {
            int percent = monitor.getProgressPercent();
            if ((state == STATE_VERIFYING) && (percent >= WOFData.MIN_VERIFIED_PERCENT)) {
               setState(STATE_LOADING);
            }
            if (percent == 100) {
               if (wofData.parsedList) {
                  setState(STATE_MESSAGES);
               }
               else {
                  setState(STATE_DOWNLOAD_COMPLETE);
               }
            }
         }
         catch (Throwable t) {
            ;
            setState(STATE_ERROR);
         }
         canvas.repaint();
         canvas.serviceRepaints();
      }
   }

   public void gameStateChanged(int newState) {
      switch (newState) {
         case GAME_STATE_GAME_OVER:
            if (gameState.round.roundNumber == WOFGame.BONUS_ROUND) {
               setState(STATE_GAME_OVER);
            }
            else {
               setState(STATE_RESULTS);
            }
            break;
         case GAME_STATE_JACKPOT_SOLVE:
            setState(STATE_JACKPOT);
            break;
         case GAME_STATE_PAUSED:
            Resources.toPause();
            setState(STATE_PAUSE);
            break;
         case GAME_STATE_USE_FREE_SPIN:
            setState(STATE_FREE_SPIN);
            break;
      }
   }

   public static byte soundSpin = -1;
   public void handleEvent(int event) {
      int sound = -1;
      switch (event) {
         case EVENT_START:
            sound = WOFConstants.SOUND_START_GAME;
            break;
         case EVENT_SPIN:
            soundSpin = 0;
            //sound = WOFConstants.SOUND_SPIN;
            break;
         case EVENT_BANKRUPT:
            sound = WOFConstants.SOUND_BANKRUPT;
            break;
         case EVENT_NO_MATCHES:
            sound = WOFConstants.SOUND_WRONG;
            break;
         case EVENT_REVEAL_LETTER:
         case EVENT_SOLVED:
            sound = WOFConstants.SOUND_CORRECT;
            break;
         case EVENT_VOWELS_ONLY:
         case EVENT_CONSONANTS_ONLY:
            if ((gameState.moreVowels || gameState.moreConsonants) && (gameState.round.roundNumber != WOFGame.BONUS_ROUND)) {
               sound = WOFConstants.SOUND_VOWELS_ONLY;
            }
            break;
         case EVENT_OUT_OF_TURNS:
         case EVENT_OUT_OF_TIME:
            sound = WOFConstants.SOUND_OUT_OF_TIME;
            break;
      }
      if (sound >= 0) {
         playSound(sound, false);
      }
   }

   public void defaultKeyPressed(int keyCode, int gameAction) {
      // System.out.println("defaultKeyPressed("+keyCode+", "+gameAction+")");
      if (gameAction == Constants.KEY_BACK) {
         byte[] data = WINDOW_DATA[state];
         int type = data[0];
         int index = 1;
         if ((type & WINDOW_NO_TITLE) == 0) {
            index++; // skip title
         }
         if ((type & WINDOW_TYPE_MASK) == WINDOW_TEXT) {
            index++; // skip text item
         }
         else if ((type & WINDOW_TYPE_MASK) == WINDOW_MENU) {
            index += 2 * data[index] + 1; // skip menu items
         }
         index += 2 * data[index] + 1;
         setState(data[index]);
      }
      else if (gameAction == Constants.KEY_OK)
      {
         byte[] data = WINDOW_DATA[state];
         int type = data[0];
         int index = 1;
         int itemFocus = window.focus;
         int buttonFocus = itemFocus - window.numInteractive;

         if ((type & WINDOW_NO_TITLE) == 0) index++; // skip title

         if ((type & WINDOW_TYPE_MASK) == WINDOW_TEXT) index++; // skip text item

         else if ((type & WINDOW_TYPE_MASK) == WINDOW_MENU)
         {
            int numMenuItems = data[index++];
            if ((itemFocus >= 0) && (itemFocus < numMenuItems))
            {



               setState(data[index + 2 * itemFocus + 1]);
               return;
            }
            index += 2 * numMenuItems; // skip menu items
         }
         int numButtons = data[index++];
         if ((buttonFocus >= 0) && (buttonFocus < numButtons))
         {
            setState(data[index + 2 * buttonFocus + 1]);
         }
      }
   }

   public void keyPressed(int keyCode, int gameAction) 
   {



      if (Config.MAP_RIGHT_SOFT_TO_BACK && (gameAction == Constants.KEY_RIGHT_SOFT))
      {
         gameAction = Constants.KEY_BACK;
      }
      else if (Config.MAP_LEFT_SOFT_TO_OK && (gameAction == Constants.KEY_LEFT_SOFT))
      {
         gameAction = Constants.KEY_OK;
      }
      if (state == STATE_GAME)
      {
         gameState.keyPressed(keyCode, gameAction);
         canvas.repaint();//paint();
      }
      else if (state == STATE_EXIT)
      {
         return;
      }

      else if (state == STATE_BUY_FULL || state == STATE_MORE_GAMES)
      {
         return;
      }

      else if (window.keyPressed(gameAction))
      {
         if ((WOFConstants.MAX_FOOTER_LINES > 0) && (state == STATE_LIST)) updateFooterText();
         canvas.repaint();//paint();
      }
      else
      {
         if ((gameAction == Constants.KEY_OK) && (window.focus >= 0) && (window.focus < window.numInteractive))
         {
            switch (state)
            {
               case STATE_OPTIONS:
                  ((TextComponent)window.getFocus()).style ^= TextComponent.CHECKED;
                  substate = SUBSTATE_OPTIONS_CHANGED;
                  canvas.repaint();//paint();
                  return;

               case STATE_LIST:
                  setState(STATE_AIR_TIME);
                  return;

                  //case STATE_REGISTER_WAIT:
            }
         }
         defaultKeyPressed(keyCode, gameAction);
      }
   }


   public void paint(Graphics g) {
//        System.out.println("state = " + state);
      switch (state) {

         case STATE_BUY_FULL:
         case STATE_MORE_GAMES:

         case STATE_EXIT:
            break;
         case STATE_GAME:

            if (!pausing)
               canvas.display.callSerially(this);
            // intentionally fall through
         case STATE_JACKPOT:
         case STATE_FREE_SPIN:
         case STATE_PAUSE:
            wofView.paint(g);
            if (state == STATE_GAME) {
               break;
            }
            // intentionally fall through
         default:
            window.paint(g);
            if (WOFConstants.USE_BANNER && showBanner) {
               int bx = (canvas.width - bannerWidth) / 2;
               g.drawImage(Resources.images[WOFConstants.IMAGE_BANNER], bx, 0, Graphics.TOP | Graphics.LEFT);
               if (bannerWidth < canvas.width) {
                  g.setColor(WOFConstants.BANNER_COLOR);
                  g.fillRect(0, 0, bx, bannerHeight + WOFConstants.BANNER_OVERLAP);
                  g.fillRect(bx + bannerWidth, 0, canvas.width - bx - bannerWidth, bannerHeight + WOFConstants.BANNER_OVERLAP);
               }
            }
      }








   }










   public void run() 
   {

      try{ 
         Thread.sleep(25);
      }
      catch (Exception e) {
         ;
      }

      if (state == STATE_GAME)
      {










         gameState.update();
         canvas.repaint();
      }
























































































































































































































   }



























































































































}
