






    





    



/*
 * WOFGame.java
 * Created on Oct 21, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;
/**
 * @author glewis
 */
public class WOFGame {
   public static final int ROUND_1 = 0;
   public static final int ROUND_2 = 1;
   public static final int ROUND_3 = 2;
   public static final int ROUND_4 = 3;
   public static final int NUM_ROUNDS = 4;

   public static final int JACKPOT_ROUND = ROUND_2;
   public static final int BONUS_ROUND = ROUND_4;

   public static final int DATA_SIZE = NUM_ROUNDS * WOFRound.DATA_SIZE;

   public WOFPack pack;
   public int gameID;

   public WOFRound[] rounds;

   public WOFGame() {
      rounds = new WOFRound[NUM_ROUNDS];
      for (byte i=0; i<NUM_ROUNDS; i++) {
         rounds[i] = new WOFRound(this, i);
      }
   }

   public void parse(PropertyReader reader) throws IOException {
      for (int i=0; i<NUM_ROUNDS; i++) {
         rounds[i].parse(reader);
      }
   }
   /*
   public void readObject(DataInputStream in) throws IOException {
       for (int i=0; i<NUM_ROUNDS; i++) {
           rounds[i].readObject(in);
       }
   }
   
   public void writeObject(DataOutputStream out) throws IOException {
       for (int i=0; i<NUM_ROUNDS; i++) {
           rounds[i].writeObject(out);
       }
   }*/

   public void writeData(PrintStream out) throws IOException {
      out.println();
      for (int i=0; i<NUM_ROUNDS; i++) {
         rounds[i].writeData(out);
      }
      out.println();
   }

   public void print() {
      //System.out.println("game id="+gameID);
      for (int i=0; i<NUM_ROUNDS; i++) {
         rounds[i].print();
      }
   }    
}
