






    





    



/*
 * WOFMessage.java
 * Created on Oct 29, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */


import java.io.*;

/**
 * @author glewis
 */
public class WOFMessage {
   public static final int MAX_MESSAGE_SIZE = 200;
   public static final int MAX_MESSAGE_NAME_SIZE = 20;
   public static final int MESSAGE_TYPE_GAME = 0x00;
   public static final int MESSAGE_TYPE_LIST = 0x01;

   public static final int DEFAULT_MESSAGE_TYPE = MESSAGE_TYPE_LIST;
   public static final int DEFAULT_MESSAGE_COLOR = 0x0000FF;

   public int id = WOFData.NULL_ID;
   public int type;
   public int color;
   public byte[] title = new byte[MAX_MESSAGE_NAME_SIZE];
   public int titleLen;
   public byte[] message = new byte[MAX_MESSAGE_SIZE];
   public int messageLen;

   public WOFMessage() {}

   public void print() {
      StringBuffer sBuf = new StringBuffer();
      sBuf.append("message: id=");
      sBuf.append(id);
      sBuf.append(" type=");
      sBuf.append(type);
      sBuf.append(" color=");
      sBuf.append(color);
      sBuf.append(" title=");
      sBuf.append(new String(title, 0, titleLen));
      sBuf.append(" message=");
      sBuf.append(new String(message, 0, messageLen));
      //System.out.println(sBuf);
   }

   public void parse(PropertyReader reader) throws IOException {
      messageLen = 0;
      titleLen = 0;
      id = WOFData.NULL_ID;
      color = DEFAULT_MESSAGE_COLOR;
      type = DEFAULT_MESSAGE_TYPE;
      int len;
      while (true) {
         switch (reader.getNameIndex()) {
            case WOFData.PROP_COLOR:
               color = reader.getHexValue();
               break;
            case WOFData.PROP_NAME:
               len = reader.propertyValueLength;
               if (len > title.length) {
                  len = title.length;
               }
               titleLen = len;
               System.arraycopy(reader.propertyValue, 0,
                                title, 0, len);
               break;
            case WOFData.PROP_DESCRIPTION:
               len = reader.propertyValueLength;
               if (len > message.length) {
                  len = message.length;
               }
               messageLen = len;
               System.arraycopy(reader.propertyValue, 0,
                                message, 0, len);
               break;
            case WOFData.PROP_VALUE:
               type = reader.getIntValue();
               break;
            case WOFData.PROP_PACK_ID:
               id = reader.getIntValue();
               break;
         }
         if (!reader.next(false)) {
            break;
         }
      }
   }
}
