






    





    



/*
 * WOFRankSpacer.java
 * Created on Nov 18, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;

/**
 * A Component that can display rank stars or act as a spacer.
 * @author glewis
 */
public class WOFRankSpacer extends Component {
   public static final int RANK_NONE = -1;
   public static final int RANK_0_0 = 0;
   public static final int RANK_0_5 = 1;
   public static final int RANK_1_0 = 2;
   public static final int RANK_1_5 = 3;
   public static final int RANK_2_0 = 4;
   public static final int RANK_2_5 = 5;
   public static final int RANK_3_0 = 6;
   public static final int RANK_3_5 = 7;
   public static final int RANK_4_0 = 8;
   public static final int RANK_4_5 = 9;
   public static final int RANK_5_0 = 10;

   public static final int NUM_STARS = 5;

   public static final int[] RANK_VALUES = new int[] {
      1, 2501, 5001, 10001, 20001, 30001, 40001, 50001, 60001, 70001
   };

   public static byte getRank(int money) {
      int rank = RANK_VALUES.length;
      while (--rank >= 0) {
         if (money >= RANK_VALUES[rank]) {
            break;
         }
      }
      return(byte)(rank+1);
   }

   public byte rank = RANK_NONE;

   public WOFRankSpacer() {
      super(Border.NULL_BORDER);
   }

   public void setRank(byte rank) {
      this.rank = rank;
      h = (short)(WOFConstants.RANK_STAR_TOP + WOFConstants.RANK_STAR_BOTTOM + Resources.images[WOFConstants.IMAGE_STAR_FULL].getHeight());
   }

   public void setSpacer(int height) {
      rank = RANK_NONE;
      h = (short)height; 
   }

   public void paint(Graphics g) {
      if (rank != RANK_NONE) {
         int spacing = Resources.images[WOFConstants.IMAGE_STAR_FULL].getWidth() + WOFConstants.RANK_X_GAP;
         int curX = ((w - NUM_STARS * spacing + WOFConstants.RANK_X_GAP) >> 1);
         int rval = 0;
         for (int i=0; i<NUM_STARS; i++) {
            int imageNum = WOFConstants.IMAGE_STAR_FULL;
            if (rank <= rval++) {
               imageNum = WOFConstants.IMAGE_STAR_EMPTY;
               rval++;
            }
            else if (rank <= rval++) {
               imageNum = WOFConstants.IMAGE_STAR_HALF;
            }
            g.drawImage(Resources.images[imageNum], curX, WOFConstants.RANK_STAR_TOP, Graphics.TOP | Graphics.LEFT);
            curX += spacing;
         }
      }
   }
}
