






    





    



/*
 * ZaxisSubscription.java
 * Created on Nov 24, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

/**
 * @author glewis
 */
public class ZaxisSubscription extends Subscription {
   public static final int[] debugTimes = new int[] { // specify delays here:
      5000,5000,2000,2000,5000,10000
   };

   public static final byte[] debugStates = new byte[] { // specify states here:
      STATE_VALID, STATE_EXPIRED, STATE_VALID, STATE_VALID, STATE_NETWORK_ERROR, STATE_EXPIRED
   };

   public static final String[] debugMessages = new String[] { // specify messages here:
      "valid", "expired", "valid", "valid", "network error", "expired"
   };

   public byte state = STATE_UNKNOWN;
   public String message;    
   public byte nextState;

   public ZaxisSubscription() {
      super(null, null, null);
   }

   public void verify() {
      state = STATE_UNKNOWN;
      if ((debugTimes != null) && (debugTimes.length > 0) && (debugTimes[nextState % debugTimes.length] > 0)) {
         try {
            Thread.sleep(debugTimes[nextState]);
         }
         catch (Exception e) {
            ;
         }
      }
      synchronized (this) {
         if ((debugStates != null) && (debugStates.length > 0)) {
            state = debugStates[nextState % debugStates.length];
         }
         if ((debugMessages != null) && (debugMessages.length > 0)) {
            message = debugMessages[nextState % debugMessages.length];
         }
         nextState++;
      }
   }

   public void cancel() {
      synchronized (this) {
         if (state == STATE_UNKNOWN) {
            state = STATE_USERCANCELED;
         }
      }
   }

   public byte getState() {
      return state;
   }

   public boolean isSubscriptionValid() {
      return(getState() == STATE_VALID);
   }

   public String getMessage() {
      return message;
   }
}
