






    





    



/*
 * AppMIDlet.java
 * Created on Jul 9, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;
import java.util.*;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import javax.microedition.rms.*;





/**
 * MIDlet used to launch an App.
 *
 * @author glewis
 */



public class wof2005 extends MIDlet implements Runnable 

{
   public static final String APP_CLASS_PROPERTY = "Zaxis-App";
   public static final String SPLASH_FILE_PREFIX = "Zaxis-Splash-";
   public static final String SPLASH_COLOR_PREFIX = "Zaxis-Splash-Color-";
   public static final String SPLASH_TIME_PREFIX = "Zaxis-Splash-Time-";

   public static final int DEFAULT_SPLASH_TIME = 1000;
   public static final int NO_SPLASH = -1;

   public AppCanvas canvas;
   public static wof2005 _main;
   public static Display dis;

   public int splashIndex = 0;

   public boolean threadStarted = false;

   public wof2005() 
   {
      _main = this;
      dis = Display.getDisplay(this);
   }

   protected void startApp() 
   {
      try {
         if (canvas == null)
         {
















            canvas = new AppCanvas(this, getProperty(APP_CLASS_PROPERTY));

            showSplash();
            canvas.display.setCurrent(canvas);
            (new Thread(this)).start();
            //canvas.display.callSerially(this);
            //canvas.repaint();
         }
         else canvas.resume();
      }
      catch (Throwable t) { 
         ;
         if (canvas != null) canvas.handleException(t);
      }
   }

   protected void pauseApp() 
   {
      canvas.pause();
   }

   protected void destroyApp(boolean force) 
   {
      canvas.destroy(true);





   }

   public String getProperty(String propertyName) 
   {

      String val = getAppProperty(propertyName);
      if (val != null) val = val.trim();
      return val;



   }


   private boolean showSplash() throws IOException 
   {

      String fileName = getProperty(SPLASH_FILE_PREFIX + (splashIndex + 1));
      fileName = getProperty(SPLASH_FILE_PREFIX + (splashIndex + 1));




      if (fileName == null)
      {
         canvas.start();
         return false;
      }

      String colorString = getProperty(SPLASH_COLOR_PREFIX + (splashIndex + 1));



      canvas.background = null;
      canvas.background = Image.createImage(fileName);
      if (colorString != null) canvas.bgColor = Integer.parseInt(colorString);

      return true;
   }

   public void run() 
   {
      try {
         if (!threadStarted)
         {
            threadStarted = true;
            canvas.run();
            if (canvas.background != null) (new Thread(this)).start();
         }
         else if (splashIndex != 0)
         {
            synchronized (this) 
            {
               notifyAll();
            }
            return;
         }
         else
         {
            while (true)
            {
               String timeString = getProperty(SPLASH_TIME_PREFIX + (++splashIndex));
               canvas.splashDisplayed();
               long time = DEFAULT_SPLASH_TIME;

               if (timeString != null) time = Integer.parseInt(timeString);


               // wait for timer or key press
               synchronized (this) 
               {
                  if (canvas.criticalError || canvas.destroyed) return;
                  //Thread.sleep(time);
                  wait(time);
               }
               if (!showSplash()) return;

               // wait for repaint or key press
               synchronized (this) 
               {
                  if (canvas.criticalError || canvas.destroyed) return;

                  canvas.repaint();
                  canvas.display.callSerially(this);
                  //(new Thread(this)).start();
                  wait();
               }
            }
         }
      }
      catch (Throwable t) { 
         ;
         canvas.handleException(t); 
      }
   }













}
