






    





    



/*
 * App.java
 * Created on Jul 8, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;

/**
 * interface through which an AppCanvas communicates with the main application.
 * By abstracting this through an interface, the AppCanvas does not have a
 * direct dependency on the application and can therefor load it in the
 * background while it is displaying a splash screen.
 * <p/>
 * This also takes care of certain idiosyncrosies of Nokia devices.
 *
 * @author glewis
 */
public interface App {
   public void setAppCanvas(AppCanvas canvas) throws Throwable;

   public void start() throws Throwable;

   public void pause();

   public void resume();

   public void destroy();

   public void keyPressed(int keyCode, int gameAction);

   public void paint(Graphics g);

   public void runThread() throws Throwable;

   public void splashDisplayed(int index) throws Throwable;
}
