






    





    



/*
 * AppCanvas.java
 * Created on Jul 8, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;

/**
 * The canvas used by an App.
 *
 * @author glewis
 */





public class AppCanvas extends Canvas implements Runnable

{
   public static final int FIXED_WIDTH = Config.USE_FIXED_SIZE ? Config.SCREEN_WIDTH : 0;
   public static final int FIXED_HEIGHT = Config.USE_FIXED_SIZE ? Config.SCREEN_HEIGHT : 0;
   public static final int EXTERIOR_COLOR = 0x000080;

   public static final String ERROR_TITLE_PROPERTY = "Zaxis-Error-Title";
   public static final String ERROR_MESSAGE_PROPERTY = "Zaxis-Error-Message";
   public static final String OOME_MESSAGE_PROPERTY = "Zaxis-OOME-Message";

   public short width;
   public short height;






   public Image background;
   public int bgColor;
   private int nextSplashNotify;

   public String errorTitle;
   public String oomeMessage;
   public String errorMessage;

   public wof2005 midlet;
   public Display display;
   private App app;

   private boolean threadStarted = false;
   private volatile boolean started;
   private volatile boolean canStart;
   private volatile boolean active;
   public volatile boolean destroyed;
   public volatile boolean criticalError;

   public AppCanvas(wof2005 midlet, String appClass) 
   {
      this.midlet = midlet;

      errorTitle = midlet.getProperty(ERROR_TITLE_PROPERTY);
      errorMessage = midlet.getProperty(ERROR_MESSAGE_PROPERTY);
      oomeMessage = midlet.getProperty(OOME_MESSAGE_PROPERTY);

      display = Display.getDisplay(midlet);

      width  = 176;
      height = 220;


      setFullScreenMode(true);


   }


   public void run() 
   {
      try {

         if (!threadStarted)
         {
            threadStarted = true;
            Thread thread = new Thread(this);
            thread.start();
         }
         else if (app == null)
         {
            App a = (App) WOFApp.getInstance();//Class.forName(appClass).newInstance();
            a.setAppCanvas(this);
            synchronized (this) 
            {
               app = a;
               if (canStart) start();
            }

            if (!destroyed) app.runThread();
         }
         else
         {
            synchronized (this) 
            {
               if (!started)
               {
                  started = true;
                  active = true;
                  try {
                     splashDisplayed();
                     app.start();
                  }
                  catch (Throwable t) { 
                     ;
                     handleException(t); 
                     return; 
                  }

                  if (!active)
                  {
                     active = true;
                     pause();
                  }

                  if (destroyed)
                  {
                     destroyed = false;
                     destroy(true);
                  }
               }
            }
         }
      }
      catch (Throwable t) { 
         ;
         handleException(t); 
      }
   }

   public void start() 
   {
      synchronized (this) 
      {
         canStart = true;
         if ((app != null) && !started) display.callSerially(this);
      }
   }

   public void pause() 
   {
      if (!criticalError)
      {
         if (started && active) app.pause();
         active = false;
      }
   }

   public void resume() 
   {
      if (criticalError)
      {
         midlet.notifyDestroyed();
         return;
      }

      try {
         if (started && !active && app != null)
         {
            active = true;
            background = null;
            app.resume();
         }
      }
      catch (Throwable t) { 
         ;
         handleException(t); 
      }
   }

   public void destroy(boolean terminateMIDlet) 
   {
      synchronized (this) 
      {
         if (!destroyed)
         {
            destroyed = true;
            pause();

            if (started) app.destroy();

            synchronized (midlet) 
            {
               midlet.notifyAll();
            }

            if (terminateMIDlet) midlet.notifyDestroyed();

         }
      }
   }

   protected void hideNotify() 
   {
      pause();
   }

   boolean frompause;
   protected void showNotify() 
   {
      frompause = true;
      resume();
   }

   public void handleException(Throwable t) 
   {
      try {
         if (criticalError) return;


         app = null;
         criticalError = true;

         t.printStackTrace();
         synchronized (midlet) 
         {
            midlet.notifyAll();
         }

         if (display != null)
         {
            String message;
            if (t instanceof OutOfMemoryError) message = oomeMessage;
            else message = t.getMessage();

            if ((message == null) || (message.length() == 0))
               message = errorMessage + "\n" + t.getClass().getName();
            else
               message = errorMessage + "\n" + message;

            Alert alert = new Alert(errorTitle, message, null, AlertType.ERROR);
            display.setCurrent(alert, this);
            return;
         }
      }
      catch (Throwable t2) {
         ;
      }


      midlet.notifyDestroyed();

   }

   public int getGameAction(int key) 
   {
      int gameAction = 0;
      switch (key)
      {
         case -7:



            gameAction = Constants.KEY_RIGHT_SOFT;
            break;

         case -6:



            gameAction = Constants.KEY_LEFT_SOFT;
            break;

            //case 13:
            //     gameAction = Constants.KEY_OK;
            //break;





         case KEY_STAR: gameAction = Constants.KEY_LEFT; break;
         case KEY_POUND: gameAction = Constants.KEY_RIGHT; break;


         default:
            if ((key >= '0') && (key <= '9'))
               gameAction = Constants.KEY_NONE;
            else
               try { 
                  gameAction = super.getGameAction(key);
               }
               catch (Exception e) {
                  ;
               }
            break;
      }
      return gameAction;
   }

   /**
    * called when a key is pressed.
    */
   protected void keyPressed(int key) 
   {
      //System.out.println(key);
      try {
         if (!started)
         {
            synchronized (midlet) 
            {
               midlet.notifyAll();
            }
         }

         if ((app == null) || !active) return;

         int gameAction = getGameAction(key);
         app.keyPressed(key, gameAction);

      }
      catch (Throwable t) { 
         ;
         handleException(t); 
      }
   }

   protected void splashDisplayed() throws Throwable 
   {
      if (app != null)
         while (nextSplashNotify < midlet.splashIndex) app.splashDisplayed(nextSplashNotify++);
   }

   /**
    * paints the screen.
    */



   public void paint(Graphics g) 
   {




      g.setClip(0,0,width,height);

      try {
         if (active && (app != null)) app.paint(g);
         else
         {
            g.setColor(bgColor);
            g.fillRect(0, 0, width, height);
            if (background != null) g.drawImage(background, width>>1, height>>1, 3);
         }
      }
      catch (Throwable t) { 
         ;
         handleException(t); 
      }













   }
}
