






    





    



/*
 * Component.java
 * Created on Nov 1, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;

/**
 * @author glewis
 */
public class Component {
   public static final Border COMPONENT_DEFAULT_BORDER = Border.NULL_BORDER;

   public static final int FOCUS_COLOR = 0x944900;

   // window frame based on title, footer, buttons

   public static final int TRANSPARENT = -1;
   public static final int HIGHLIGHT = -2;
   public static final int SHADOW = -3;
   public static final int COMPONENT_COLOR = -4;

   public static final int FRAME_TITLE_INSET_TOP = 2;
   public static final int FRAME_TITLE_INSET_LEFT = 2;
   public static final int FRAME_TITLE_INSET_RIGHT = 2;
   public static final int FRAME_TITLE_INSET_BOTTOM = 2;
   public static final int BUTTONS_FRAME_TITLE_INSET_TOP = 2;

   public static final int CLIP_STACK_SIZE = 4;

   public static short[] cxStack = new short[CLIP_STACK_SIZE];
   public static short[] cyStack = new short[CLIP_STACK_SIZE];
   public static short[] cwStack = new short[CLIP_STACK_SIZE];
   public static short[] chStack = new short[CLIP_STACK_SIZE];
   public static short[] txStack = new short[CLIP_STACK_SIZE];
   public static short[] tyStack = new short[CLIP_STACK_SIZE];
   public static byte clipStackIndex;

   public void clipIn(Graphics g) {
      clipIn(g, x, y, w, h, x, y);
   }

   public static void clipIn(Graphics g, int x, int y, int w, int h, int tx, int ty) {
      cxStack[clipStackIndex] = (short)g.getClipX();
      cyStack[clipStackIndex] = (short)g.getClipY();
      cwStack[clipStackIndex] = (short)g.getClipWidth();
      chStack[clipStackIndex] = (short)g.getClipHeight();
      txStack[clipStackIndex] = (short)tx;
      tyStack[clipStackIndex] = (short)ty;
      clipStackIndex++;
      g.clipRect(x, y, w, h);
      g.translate(tx, ty);
   }

   public static void clipOut(Graphics g) {
      clipStackIndex--;
      g.translate(-txStack[clipStackIndex], -tyStack[clipStackIndex]);
      g.setClip(cxStack[clipStackIndex], cyStack[clipStackIndex],
                cwStack[clipStackIndex], chStack[clipStackIndex]);
   }

   public short x;
   public short y;
   public short w;
   public short h;
   public Border border;
   public Border focusBorder;
   public int bgColor;
   public boolean interactive;
   public boolean hasFocus;

   public Component(Border border) {
      this.border = (border == null) ? COMPONENT_DEFAULT_BORDER : border;
      bgColor = TRANSPARENT;
   }

   public Component(Border border, int color, int x, int y, int w, int h) {
      this.border = (border == null) ? COMPONENT_DEFAULT_BORDER : border;
      this.bgColor = color;
      this.x = (short)x;
      this.y = (short)y;
      this.w = (short)w;
      this.h = (short)h;
   }

   /** set width and adjust height accordingly. */
   public void setWidth(int width) {
      w = (short)width;
   }

   public void setHeight(int height) {
      h = (short)height;
   }

   public void setColor(Graphics graphics, int color) {
      int c = hasFocus ? FOCUS_COLOR : bgColor;
      if (color == HIGHLIGHT) {
         color = ((c & 0xFEFEFE) + 0xFEFEFE) >> 1;
      }
      else if (color == SHADOW) {
         color = (c & 0xFEFEFE) >> 1;
      }
      else if (color == COMPONENT_COLOR) {
         color = c;
      }
      graphics.setColor(color);
   }

   /** already translated to 0,0 */
   public void paint(Graphics g) {
      if (bgColor != TRANSPARENT) {
         setColor(g, COMPONENT_COLOR);
         g.fillRect(0, 0, w, h);
      }
      if (hasFocus && (focusBorder != null)) {
         //System.out.println("Xm...");
         focusBorder.paint(this, g);
      }
      else {
         border.paint(this, g);
         //System.out.println("Xm too...");
      }
   }

   public void zoomAndPaint(Graphics g) {
      clipIn(g);
      paint(g);
      clipOut(g);
   }
}
