






    





    



/*
 * CompositeEnumeration.java
 * Created on May 3, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.util.*;

/**
 * @author glewis
 */
public class CompositeEnumeration implements Enumeration {
   private Vector elements;
   private int index;

   public CompositeEnumeration() {
      elements = new Vector();
   }

   public void append(Enumeration enum) {
      while (enum.hasMoreElements()) {
         Object o = enum.nextElement();
         if ((o != null) && !elements.contains(o)) {
            elements.addElement(o);
         }
      }
   }

   public void invalidate() {
      index = Integer.MAX_VALUE;
   }

   public void reset() {
      index = 0;
   }

   public void clear() {
      elements.setSize(0);
      index = 0;
   }

   public boolean hasMoreElements() {
      return index < elements.size();
   }

   public Object nextElement() {
      if (index < elements.size()) {
         return elements.elementAt(index++);
      }
      else {
         throw new NoSuchElementException();
      }
   }
}
