






    





    



/*
 * ProgressBar.java
 * Created on Nov 7, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;

/**
 * @author glewis
 */
public class ProgressBar extends Component {
   public ProgressMonitor monitor;
   public int progressColor;
   public Component component;

   public ProgressBar(ProgressMonitor monitor, Border outerBorder, Border border, int fullColor, int emptyColor) {
      super(outerBorder);
      component = new Component(border);
      component.bgColor = emptyColor;        
      progressColor = fullColor;
      this.monitor = monitor;
   }

   public void paint(Graphics g) {
      super.paint(g);
      component.x = border.left;
      component.y = border.top;
      component.w = (short)(w - border.left - border.right);
      component.h = (short)(h - border.top - border.bottom);
      component.clipIn(g);
      component.paint(g);
      int progress = 0;
      try {
         progress = monitor.getProgressPercent();
         int pw = (progress 
                   * (component.w-component.border.left-component.border.right))
                  / 100;
         g.setColor(progressColor);
         g.fillRect(component.border.left, component.border.top,
                    pw, component.h - component.border.bottom - component.border.top);
      }
      catch (Throwable t) {            
         ;
      }
      clipOut(g);
   }
}
