






    





    



/*
 * Resources.java
 * Created on Aug 3, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;

import javax.microedition.lcdui.*;

import javax.microedition.media.*;
import javax.microedition.media.control.*;






/**
 * Contains all of the images and sounds.
 *
 * @author glewis
 */
public class Resources 
{

   public static final String SOUND_FORMAT = "audio/midi";
   public static Player[] sounds;
   public static InputStream[] soundStreams;
   public static int curSound;
   public static int curPlayer;
   public static int queuedPlayer;

   public void loadSounds() throws IOException 
   {
      int numSounds = readInt();

      sounds = new Player[numSounds];
      curSound = -1;
      PlayerListener listener;

      curPlayer = queuedPlayer = -1;
      soundStreams = new InputStream[numSounds];
      listener = new ResourcePlayerListener();

      for (int i = 0; i < numSounds; i++)
      {
         String fileName = nextFile();
         InputStream in = getClass().getResourceAsStream(fileName);
         if (in != null)
         {
            try {
               int total = 0;
               while (true)
               {
                  int numRead = in.read(buf, total, buf.length - total);
                  if (numRead <= 0) break;

                  total += numRead;
               }

               byte[] soundBuf = new byte[total];
               System.arraycopy(buf, 0, soundBuf, 0, total);

               soundStreams[i] = new ByteArrayInputStream(soundBuf);
               Player player = Manager.createPlayer(soundStreams[i], SOUND_FORMAT);
               if (player != null)
               {
                  player.realize();
                  sounds[i] = player;
                  player.addPlayerListener(listener);
               }
            }
            catch (Exception e) { 
               ;
            }
            finally { 
               in.close();
            }
         }
      }
   }

   public static void destroy() 
   {
      curSound = -1;

      if (sounds!=null)
         for (int i = sounds.length; --i >= 0;)
         {
            try { 
               if (sounds[i]!=null) sounds[i].close();
            }
            catch (Exception e) { 
               ;
            }
            sounds[i] = null;
         }
      curPlayer = queuedPlayer = -1;
      sounds = null;
      strings = null;
      images = null;
   }


   private static class ResourcePlayerListener implements PlayerListener 
   {

      public void playerUpdate(Player player, String event, Object eventData) 
      {
         try {
            if (curPlayer >= 0 && player == sounds[curPlayer] && 
                (event == PlayerListener.DEVICE_UNAVAILABLE || event == PlayerListener.STOPPED || event == PlayerListener.END_OF_MEDIA))
            {
               if (queuedPlayer >= 0)
               {
                  if (queuedPlayer != curPlayer) player.deallocate();

                  doPlay(queuedPlayer);
               }
            }
         }
         catch (Exception e) { 
            ;
            queuedPlayer = -1; 
         }
      }          

   }

   private static void doPlay(int sound) throws Exception 
   {
      curPlayer = sound;
      queuedPlayer = -1;
      Player player;
      player = sounds[sound];

      soundStreams[sound].reset();
      try { 
         player.setMediaTime(0);
      }
      catch (Exception e) { 
         ;
      }

      if (player.getState() != Player.PREFETCHED)
         try { 
            player.prefetch();
         }
         catch (Exception e) { 
            ;
         }

      VolumeControl vc = (VolumeControl) player.getControl("VolumeControl");
      if (vc != null)
      {
         vc.setLevel(100);
         vc.setMute(false);
      }
      player.start();
   }

   public static void playSound(int index) 
   {
      if (sounds == null || sounds[index] == null) return;

      try {

         Player p = (Player) sounds[index];
         int cp = curPlayer;
         if (cp >= 0)
         {
            Player cPlayer = sounds[curPlayer];
            if (cPlayer.getState() == Player.STARTED)
            {
               queuedPlayer = index;
               cPlayer.stop();
               return;
            }



         }
         doPlay(index);
      }
      catch (Exception e) {
         ;
         queuedPlayer = -1; 
      }
   }


   public static int copySFX = -1;
   public static void toPause()
   {
      try { 
         if (curPlayer >= 0 && sounds[curPlayer] != null && sounds[curPlayer].getState() == Player.STARTED)
         {
            copySFX = curPlayer;



            sounds[curPlayer].stop(); 
            sounds[curPlayer].setMediaTime(0);

         }
      }
      catch (Exception e) {
         ;
      }
   }

   public static void fromPause()
   {
      if (copySFX != -1) playSound(copySFX);
      copySFX = -1;
   }

   public static void stopSound() 
   {
      try { 
         if (curPlayer >= 0 && sounds[curPlayer] != null)



            sounds[curPlayer].stop();
         sounds[curPlayer].setMediaTime(0);

      }
      catch (Exception e) {
         ;
      }

      queuedPlayer = -1;
      curSound = -1;
   }  

















































































































































// common =============================================
   public static final String RESOURCES_FILE = "/resources.txt";
   public static final char STRING_SEPARATOR = '~';

   public static Image[] images;
   public static byte[][] strings;

   private InputStream resourcesStream;
   private byte[] fileNameBuf;
   private byte[] buf;

   public Resources() {}

   public void init() throws IOException 
   {
      resourcesStream = RESOURCES_FILE.getClass().getResourceAsStream(RESOURCES_FILE);
      fileNameBuf = new byte[readInt()];
      buf = new byte[readInt()];
   }

   public void close() 
   {
      if (resourcesStream != null)
      {
         try { 
            resourcesStream.close();
         }
         catch (Throwable t) { 
            ;
         }
         resourcesStream = null;
      }
      fileNameBuf = null;
      buf = null;
   }

   private int readInt() throws IOException 
   {
      int val = 0;
      byte c;
      do 
      {
         c = (byte) resourcesStream.read(); 
      } while (c <= ' ');

      while (c > ' ')
      { 
         val = (val * 10) + c - '0';
         c = (byte) resourcesStream.read();
      }
      return val;
   }

   private String nextFile() throws IOException 
   {
      fileNameBuf[0] = '/';
      do 
      {
         fileNameBuf[1] = (byte) resourcesStream.read();
      } while (fileNameBuf[1] <= ' ');

      int len = 1;
      while (fileNameBuf[len] > ' ')
      {
         fileNameBuf[++len] = (byte) resourcesStream.read();
      }
      String fileName = new String(fileNameBuf, 0, len);
      return fileName;
   }

   public void loadImages() throws IOException 
   {
      int numImages = readInt();
      images = new Image[numImages];
      int i = 0;
      String filename = null;
      try {
         for (; i < numImages; i++)
         {
            filename = nextFile();
            images[i] = Image.createImage(filename);
         }
      }
      catch (IOException e) { 
         ;
      }
   }

   public void loadStrings() throws IOException 
   {
      int numStrings = readInt();
      strings = new byte[numStrings][];
      int total = 0;
      boolean readAll = false;

      for (int i = 0; i < numStrings; i++)
      {
         try {
            while ((total < buf.length - 1) && !readAll)
            {
               int numRead = resourcesStream.read(buf, total, buf.length - total - 1);
               if (numRead <= 0)
               {
                  readAll = true;
                  buf[total] = STRING_SEPARATOR;
               }
               else total += numRead;
            }

            int start = 0;
            while (buf[start] <= ' ') if (++start >= total) throw new IOException();

            int end = start;
            while (buf[end] != STRING_SEPARATOR) if (++end >= total) throw new IOException();

            int sEnd = end;
            while ((sEnd > start) && (buf[sEnd - 1] <= ' ')) sEnd--;

            if (i == WOFConstants.STRING_VERSION) {
               String version = wof2005._main.getAppProperty("MIDlet-Version");
               if (version != null) {
                  version = " "+version;
                  strings[i] = new byte[sEnd - start + version.length()];
                  for (int ind = 0; ind < version.length(); ind++)
                     strings[i][sEnd - start + ind] = (byte)version.charAt(ind);
               }
               else {
                  strings[i] = new byte[sEnd - start];
               }
            }
            else {
               strings[i] = new byte[sEnd - start];
            }
            System.arraycopy(buf, start, strings[i], 0, sEnd - start);
            System.arraycopy(buf, end + 1, buf, 0, total - end - 1);
            total -= end + 1;
         }
         catch (IOException e) { 
            ;
            throw e;
         }
      }
   }
}
