






    





    



import javax.microedition.midlet.MIDlet;
import javax.microedition.io.*;
import java.io.InputStream;


public class Subscription 
{
   //Possible States
   public static final byte STATE_UNKNOWN                      =1;
   public static final byte STATE_USERCANCELED                 =2;
   public static final byte STATE_NETWORK_ERROR                =3;
   public static final byte STATE_DB_ERROR                     =4;
   public static final byte STATE_EXPIRED                      =5;
   public static final byte STATE_INVALID_OWNERIDENTIFIER      =6;
   public static final byte STATE_INVALID_INSTANCEIDENTIFIER           =7;
   public static final byte STATE_NO_INSTANCEIDENTIFIER_OWNERIDENTIFIER =8;
   public static final byte STATE_NO_OWNERIDENTIFIER           =9;
   public static final byte STATE_NO_INSTANCEIDENTIFIER        =10;
   public static final byte STATE_UNKNOWN_FAILURE      =11;
   public static final byte STATE_VALID                =12;

   private byte m_State;
   private String m_ServerResponse;
   private boolean m_Cancel;
   private String m_URL;

   // Constructors
   public Subscription(javax.microedition.midlet.MIDlet theMIDlet)
   {
      m_State = STATE_UNKNOWN;
      m_Cancel = false;
      // build url from jad file
      String baseURL      = theMIDlet.getAppProperty("sony.motricity.url");
      String ownerIdentifier      = theMIDlet.getAppProperty("CarrierDeviceId"); // this is inserted into the jad file by motricity when the user purchases the app.
      String instanceIdentifier   = theMIDlet.getAppProperty("sony.motricity.instanceIdentifier");
      m_URL = baseURL + "?instanceIdentifier=" + URLEncode(instanceIdentifier) + "&ownerIdentifier=" + URLEncode(ownerIdentifier);
   }
   public Subscription(String baseURL, String ownerIdentifier, String instanceIdentifier)
   {
      m_State = STATE_UNKNOWN;
      m_Cancel = false;
      // build url 
      m_URL = baseURL + "?instanceIdentifier=" + URLEncode(instanceIdentifier) + "&ownerIdentifier=" + URLEncode(ownerIdentifier);
   }
   // Call cancel to abort the verification
   public void cancel()                
   {
      m_Cancel = true;
   }
   // This will return the url used with the query string
   public String getURL()              {return m_URL;}
   // This returns the state of the subscription
   public byte getState()              {return m_State;}
   // isSubscriptionValid to see if a subscription is valid
   public boolean isSubscriptionValid(){return m_State == STATE_VALID;}
   // this returns the entire response from the server
   public String getServerResponse()
   {
      if (m_ServerResponse == null)
         return "";
      return m_ServerResponse;
   }
   // this will connect to the server & parse the response
   public void verify()
   {
      // reset member variables
      m_State = STATE_UNKNOWN;
      m_ServerResponse = null;
      m_Cancel = false;

      HttpConnection httpConnection = null;
      InputStream inputStream = null;
      // download
      StringBuffer pBuffer = new StringBuffer();
      //System.out.println(m_URL);
      try
      {
         httpConnection = (HttpConnection)Connector.open(m_URL);
         inputStream = httpConnection.openInputStream();

         int ch;
         int index = -1;
         int msg_index = -1;
         int err_index = -1;
         while ((ch = inputStream.read()) != -1)
         {
            if (m_Cancel)
            {
               m_State = STATE_USERCANCELED;
               break;
            }
            pBuffer.append((char) ch);
            index++;
            if (msg_index == -1)
            {
               if (pBuffer.charAt(index) == ':')
               {
                  if (err_index == -1)
                  {
                     String str = pBuffer.toString();
                     if (str.equals("FAILURE:"))
                        err_index = index;
                     else if (str.equals("SUCCESS:"))
                     {
                        msg_index = index;
                        m_State = STATE_VALID;
                     }
                  }
                  else
                  {
                     msg_index = index;
                     String str = pBuffer.toString();
                     if (str.equals("FAILURE:EXPIRED:"))
                        m_State = STATE_EXPIRED;
                     else if (str.equals("FAILURE:DB_ERROR:"))
                        m_State = STATE_DB_ERROR;
                     else if (str.equals("FAILURE:INVALID_OWNERIDENTIFIER:"))
                        m_State = STATE_INVALID_OWNERIDENTIFIER;
                     else if (str.equals("FAILURE:INVALID_INSTANCEIDENTIFIER:"))
                        m_State = STATE_INVALID_INSTANCEIDENTIFIER;
                     else if (str.equals("FAILURE:NO_INSTANCEIDENTIFIER_OWNERIDENTIFIER:"))
                        m_State = STATE_NO_INSTANCEIDENTIFIER_OWNERIDENTIFIER;
                     else if (str.equals("FAILURE:NO_OWNERIDENTIFIER:"))
                        m_State = STATE_NO_OWNERIDENTIFIER;
                     else if (str.equals("FAILURE:NO_INSTANCEIDENTIFIER:"))
                        m_State = STATE_NO_INSTANCEIDENTIFIER;
                     else
                        m_State = STATE_UNKNOWN_FAILURE;
                  }
               }
            }
         }
         m_ServerResponse = pBuffer.toString();
      }
      catch (Exception e)
      {
         ;
         if (m_State == STATE_UNKNOWN)
            m_State = STATE_NETWORK_ERROR;
      }
      try
      { 
         if (inputStream != null)
            inputStream.close();
         if (httpConnection != null)
            httpConnection.close();
         httpConnection = null;
         inputStream = null;
      }
      catch (Exception e) { 
         ;
      }
   }
   // this function is used to encode the query string so that it is legal.
   // it will leave all alphanumeric characters and  _-. alone, replaces all
   // spaces with a + and replace all other characters with a "%" followed
   // by a 2 digit hex representation of the character.
   private static String URLEncode(String str)
   {
      if (str == null)
         return null;
      StringBuffer pBuffer = new StringBuffer();
      for (int i = 0; i < str.length(); i++)
      {
         char ch = str.charAt(i);
         if (ch == '-' || ch == '_' || ch == '.' ||
             (ch >= 'a' && ch <= 'z') ||
             (ch >= 'A' && ch <= 'Z') ||
             (ch >= '0' && ch <= '9'))
         {
            pBuffer.append(ch);
         }
         else if (ch == ' ')
         {
            pBuffer.append('+');
         }
         else
         {
            String hexStr = Integer.toHexString((int)ch);
            if (hexStr != null && hexStr.length() > 0)
            {
               pBuffer.append('%');
               if (hexStr.length() > 1)
                  pBuffer.append(hexStr.charAt(hexStr.length()-2));
               else
                  pBuffer.append('0');
               pBuffer.append(hexStr.charAt(hexStr.length()-1));
            }
         }
      }
      return pBuffer.toString();
   }
}
