






    





    



/*
 * TextComponent.java
 * Created on Nov 2, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;

/**
 * @author glewis
 */
public class TextComponent extends Component {
   public static final boolean FIXED_WIDTH_FONTS = true;
   public static final int MIN_LINE_LENGTH = 4;

   public static final int CONNECTOR_CHAR = '_';
   public static final int FIRST_FONT_IMAGE_INDEX = WOFConstants.FIRST_FONT_IMAGE;
   public static final int CHECKBOX_IMAGE = WOFConstants.IMAGE_CHECKBOX;
   public static final int CHECKBOX_WIDTH = 12;
   public static final int CHECKBOX_HEIGHT = 12;

   public static final int ALIGN_LEFT      = 0x08;
   public static final int ALIGN_RIGHT     = 0x10;
   public static final int ALIGN_CENTER    = 0x20;
   public static final int ALIGN_MASK      = 0x38;

   public static final int MULTI_LINE      = 0x40;
   public static final int FIXED_HEIGHT    = 0x80;
   public static final int CHECKBOX        = 0x100;
   public static final int CHECKED         = 0x200;

   public static final int FONT_MASK       = 0x07;

   public static final int FONT_FIRST_CHAR = ' ';


   public byte[] text;
   public short textOff;
   public short textLen;
   public short style;
   public short[] lineSpans;
   public boolean valid;

   public TextComponent(int maxSize, int style, Border border) {
      this(new byte[maxSize], 0, 0, style, border);
   }

   public TextComponent(String str, int style, Border border) {
      this(str.getBytes(), 0, str.length(), style, border);
   }

   public TextComponent(byte[] str, int off, int len, int style, Border border) {
      super(border);
      text = str;
      textOff = (short)off;
      textLen = (short)len;
      this.style = (short)style;
      if ((style & MULTI_LINE) == 0) {
         setWidth(0);
      }
   }

   public TextComponent(byte[] str, int off, int len, int style, Border border,
                        int color, int x, int y, int w, int h, boolean interactive) {
      super(border, color, x, y, w, h);
      this.interactive = interactive;
      text = str;
      textOff = (short)off;
      textLen = (short)len;
      this.style = (short)style;
   }

   public void setWidth(int width) {
      if ((w != width) || !valid) {
         w = (short)width;
         valid = true;
         int font = style & FONT_MASK;
         if ((style & FIXED_HEIGHT) != 0) {
            // do nothing
         }
         else if ((style & MULTI_LINE) == 0) {
            h = (short)(WOFConstants.FONT_HEIGHTS[font] + this.border.top + this.border.bottom);
         }
         else {
            int maxWidth = w - border.left - border.right;
            int lineLength = (maxWidth + WOFConstants.FONT_HORIZONTAL_SPACINGS[font]) / (WOFConstants.FONT_WIDTHS[font] + WOFConstants.FONT_HORIZONTAL_SPACINGS[font]);
            if (lineLength < MIN_LINE_LENGTH) {
               lineLength = MIN_LINE_LENGTH;
            }
            if (textLen <= lineLength) {
               lineSpans[0] = textOff;
               lineSpans[1] = textLen;
               lineSpans[2] = -1;
               h = (short)(WOFConstants.FONT_HEIGHTS[font] + this.border.top + this.border.bottom);
               return;
            }
            int start = textOff;
            int end = textOff + textLen;
            int numStrings = 0;
            int endWord = start; // end of last word
            int startWord = start; // start of current word
            int index = 0; // line number
            for (int ch = start; ch <= end; ch++) {
               char c = (char)((ch == end) ? '\n' : text[ch]);
               if ((c == '\n') || (c == ' ') || (c == '\r')
                   || ((c == '.') && (ch < end-1)
                       && (text[ch+1] != ' ')
                       && (text[ch+1] != '\r')
                       && (text[ch+1] != '\n'))) {
                  // possibly need to wrap
                  boolean tooLong = false;
                  tooLong = FIXED_WIDTH_FONTS
                            ? (ch-start) > lineLength
                            : (getWidth(font, text, ch, ch-start) > maxWidth);
                  if (!tooLong) {  
                     // don't need to wrap yet
                     if (c == '.') {
                        ch++;
                        endWord = ch;
                        startWord = ch;
                        continue;
                     }
                     endWord = ch;
                     startWord = ch+1;
                  }
                  else if (endWord != start) {
                     // we need to wrap this line
                     for (int j=endWord-1; --j>start;) {
                        if (text[j] == CONNECTOR_CHAR) {
                           text[j] = ' ';
                        }
                     }
                     lineSpans[index++] = (short)start;
                     lineSpans[index++] = (short)(endWord-start);
                     if (index >= lineSpans.length - 2) {
                        break;
                     }
                     if (c == '.') {
                        start = startWord;
                        ch++;
                        endWord = ch;
                        startWord = ch;
                        continue;                        
                     }
                     start = startWord;
                     endWord = ch;
                     startWord = ch+1;
                  }
                  else if (c == '.') {
                     ch++;
                  }
                  else if (c == ' ') {
                     c = '\n';
                  }
                  if (c != ' ') {
                     lineSpans[index++] = (short)start;
                     lineSpans[index++] = (short)(ch-start);
                     if (index >= lineSpans.length - 2) {
                        break;
                     }
                     if (c == '\r') {
                        ch++;
                     }
                     else if (c == '.') {
                        start = startWord = endWord = ch;
                        continue;
                     }
                     start = startWord = endWord = ch+1;
                  }
               }
            }
            lineSpans[index] = -1;
            h = (short)((WOFConstants.FONT_HEIGHTS[font]
                         + WOFConstants.FONT_VERTICAL_SPACINGS[font])
                        * (index / 2)
                        - WOFConstants.FONT_VERTICAL_SPACINGS[font]
                        + border.top + border.bottom);
         }
      }
   }

   public void setText(byte[] str) {
      if (str == null) {
         setText(null, 0, 0);
      }
      else {
         setText(str, 0, str.length);
      }
   }

   public void setText(byte[] str, int off, int len) {
      text = str;
      textOff = (short)off;
      textLen = (short)len;
      if ((style & MULTI_LINE) != 0) {
         valid = false;
      }
   }

   public void paint(Graphics g) {
      super.paint(g);
      int font = style & FONT_MASK;
      int align = style & ALIGN_MASK;
      int yVal = border.top;
      if ((style & MULTI_LINE) == 0) {
         int xLeft;
         switch (align) {
            case ALIGN_CENTER:
               xLeft = (w + border.left - border.right
                        - getWidth(font, text, textOff, textLen)) >> 1;
               break;
            case ALIGN_RIGHT:
               xLeft = w - border.right - getWidth(font, text, textOff, textLen);
               break;
            default:
               xLeft = border.left;
               break;                
         }
         drawText(g, font, xLeft, yVal, text, textOff, textLen);
      }
      else {
         int minY = g.getClipY();
         int maxY = minY + g.getClipHeight();
         for (int index = 0; (lineSpans[index] >= 0) && (yVal < maxY); index += 2) {
            if (yVal + WOFConstants.FONT_HEIGHTS[font] > minY) {
               int off = lineSpans[index];
               int len = lineSpans[index+1];
               if (len > 0) {
                  int xLeft;
                  switch (align) {
                     case ALIGN_CENTER:
                        xLeft = (w + border.left - border.right
                                 - getWidth(font, text, off, len)) >> 1;
                        break;
                     case ALIGN_RIGHT:
                        xLeft = w - border.right - getWidth(font, text, off, len);
                        break;
                     default:
                        xLeft = border.left;
                        break;                
                  }
                  drawText(g, font, xLeft, yVal, text, off, len);
               }
            }
            yVal += WOFConstants.FONT_HEIGHTS[font] + WOFConstants.FONT_VERTICAL_SPACINGS[font];
         }
      }
      if ((style & CHECKBOX) != 0) {
         g.clipRect(0, 0, CHECKBOX_WIDTH, CHECKBOX_HEIGHT);
         g.drawImage(Resources.images[CHECKBOX_IMAGE], 
                     ((style & CHECKED) == 0) ? 0 : -CHECKBOX_WIDTH, 0,
                     Graphics.TOP | Graphics.LEFT);
      }
   }

   public static int getWidth(int font, byte[] text, int off, int len) {
      return(WOFConstants.FONT_WIDTHS[font] + WOFConstants.FONT_HORIZONTAL_SPACINGS[font]) * len - WOFConstants.FONT_HORIZONTAL_SPACINGS[font];
   }

   public static void drawChar(Graphics g, int font, int x, int y, byte c) {
      clipIn(g, x, y, WOFConstants.FONT_WIDTHS[font], WOFConstants.FONT_HEIGHTS[font], 0, 0);
      if ((c >= 'a') && (c <= 'z')) {
         c += 'A' - 'a' - FONT_FIRST_CHAR;
      }
      else {
         c -= FONT_FIRST_CHAR;
      }
      g.drawImage(Resources.images[FIRST_FONT_IMAGE_INDEX + font],
                  x - WOFConstants.FONT_WIDTHS[font] * c, y, Graphics.TOP | Graphics.LEFT);
      clipOut(g);
   }

   public static void drawText(Graphics g, int font, int x, int y, byte[] text, int off, int len) {
      //System.out.println("drawText(\""+(new String(text, off, len))+"\", F"+font+" {"+x+", "+y+"})");
      Image image = Resources.images[FIRST_FONT_IMAGE_INDEX + font];
      int width = WOFConstants.FONT_WIDTHS[font];
      int height = WOFConstants.FONT_HEIGHTS[font];
      int gap = WOFConstants.FONT_HORIZONTAL_SPACINGS[font];
      for (int end = off + len; off < end; off++) {
         int c = text[off];
         if (c != CONNECTOR_CHAR) {
            clipIn(g, x, y, width, height, 0, 0);
            if ((c >= 'a') && (c <= 'z')) {
               c += 'A' - 'a' - FONT_FIRST_CHAR;
            }
            else {
               c -= FONT_FIRST_CHAR;
            }
            g.drawImage(image, x - width * c, y, Graphics.TOP | Graphics.LEFT);
            clipOut(g);
         }
         x += width + gap;
      }
   }

   public void print() {
      if (textLen == 0) {
         //System.out.println("empty");
      }
      else {
         //System.out.println("contents: "+new String(text, textOff, textLen));
      }
      //System.out.println("x="+x+"y="+y+" w="+w+" h="+h+" color="+bgColor+" style="+style);
   }
}
