






    





    



/*
 * WOFConstants.java
 * Created on Nov 4, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

/**
 * WOF-specific constants configurable on a device-by-device basis.
 * 
 * @author glewis
 */
public class WOFConstants {
   public static final int VERSION_SMALL           = 0;
   public static final int VERSION_MEDIUM          = 1;
   public static final int VERSION_LARGE           = 2;
   public static final int GAME_VERSION            = VERSION_MEDIUM;
   public static final boolean USE_ZERO_IMAGES     = (GAME_VERSION == VERSION_LARGE);
   public static final int NUM_SPLASH_SCREENS      = 2;
   public static final boolean USE_HALF_IMAGES     = false;//(GAME_VERSION != VERSION_LARGE);

   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                        Resource Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final int SOUND_TITLE             = 0;
   public static final int SOUND_START_GAME        = 1;
   public static final int SOUND_OUT_OF_TIME       = 2;
   public static final int SOUND_BANKRUPT          = 3;
   public static final int SOUND_CORRECT           = 4;
   public static final int SOUND_VOWELS_ONLY       = 5;
   public static final int SOUND_SPIN              = 6;
   public static final int SOUND_WRONG             = 7;

   public static final int NUM_SOUNDS              = 8;

   public static final int FIRST_FONT_IMAGE        = 0;
   public static final int NUM_FONT_IMAGES         = 3;

   public static final int IMAGE_CHECKBOX          = FIRST_FONT_IMAGE + NUM_FONT_IMAGES;
   public static final int IMAGE_BANKRUPT          = IMAGE_CHECKBOX + 1;
   public static final int IMAGE_LOSE_TURN         = IMAGE_BANKRUPT + 1;
   public static final int IMAGE_FREE_SPIN         = IMAGE_LOSE_TURN + 1;
   public static final int IMAGE_FREE_SPIN_ICON    = (GAME_VERSION == VERSION_SMALL) ? IMAGE_FREE_SPIN + 1 : IMAGE_FREE_SPIN;
   public static final int IMAGE_JACKPOT           = IMAGE_FREE_SPIN + 1;
   public static final int IMAGE_JACKPOT_ICON      = IMAGE_JACKPOT + 1;

   public static final int IMAGE_BANNER            = (GAME_VERSION == VERSION_SMALL) ? -1 : (IMAGE_JACKPOT_ICON + 1);

   public static final int IMAGE_WHEEL_1           = (IMAGE_BANNER >= 0) ? (IMAGE_BANNER + 1) : (IMAGE_JACKPOT_ICON + 1);
   public static final int IMAGE_WHEEL_2           = IMAGE_WHEEL_1 + 1;
   public static final int IMAGE_WHEEL_3           = IMAGE_WHEEL_1 + 2;
   public static final int IMAGE_WHEEL_4           = IMAGE_WHEEL_1 + 3;
   public static final int IMAGE_WHEEL_5           = IMAGE_WHEEL_1 + 4;
   public static final int IMAGE_WHEEL_6           = IMAGE_WHEEL_1 + 5;
   public static final int IMAGE_WHEEL_7           = IMAGE_WHEEL_1 + 6;
   public static final int IMAGE_WHEEL_8           = IMAGE_WHEEL_1 + 7;
   public static final int IMAGE_LARGE_ZERO        = USE_ZERO_IMAGES ? IMAGE_WHEEL_8 + 1 : -1;
   public static final int IMAGE_SMALL_ZERO        = USE_ZERO_IMAGES ? IMAGE_LARGE_ZERO + 1 : -1;
   public static final int IMAGE_WHEEL_POINTER_1   = USE_ZERO_IMAGES ? IMAGE_SMALL_ZERO + 1 : (IMAGE_WHEEL_8 + 1);
   public static final int IMAGE_WHEEL_POINTER_2   = IMAGE_WHEEL_POINTER_1 + 1;
   public static final int IMAGE_POWER_BAR         = IMAGE_WHEEL_POINTER_2 + 1;
   public static final int IMAGE_POWER_POINTER     = IMAGE_POWER_BAR + 1;

   public static final int IMAGE_ENVELOPE_0        = IMAGE_POWER_POINTER + 1;
   public static final int NUM_ENVELOPE_FRAMES     = (GAME_VERSION == VERSION_LARGE) ? 6 : 5;
   public static final int NUM_ENVELOPE_IMAGES     = (GAME_VERSION == VERSION_LARGE) ? NUM_ENVELOPE_FRAMES : 0;

   public static final int IMAGE_INFOBAR           = (NUM_ENVELOPE_IMAGES > 0) ? (IMAGE_ENVELOPE_0 + NUM_ENVELOPE_IMAGES) : (IMAGE_POWER_POINTER + 1);
   public static final int IMAGE_GRID              = (GAME_VERSION == VERSION_LARGE) ? (IMAGE_INFOBAR + 1) : -1;
   public static final int IMAGE_STAR_EMPTY        = (IMAGE_GRID >= 0) ? (IMAGE_GRID + 1) : (IMAGE_INFOBAR + 1);
   public static final int IMAGE_STAR_HALF         = IMAGE_STAR_EMPTY + 1;
   public static final int IMAGE_STAR_FULL         = IMAGE_STAR_HALF + 1;
   public static final int IMAGE_WELL              = (GAME_VERSION == VERSION_LARGE) ? (IMAGE_STAR_FULL + 1) : -1;

   public static final int IMAGE_ENVELOPES         = (IMAGE_WELL >= 0) ? (IMAGE_WELL + 1) : (IMAGE_STAR_FULL + 1);

   public static final int NUM_IMAGES              = IMAGE_ENVELOPES + 1;

   public static final int STRING_VERSION          = 0;
   public static final int STRING_EXIT_TEXT        = STRING_VERSION + 1;
   public static final int STRING_BACK             = STRING_EXIT_TEXT + 1;
   public static final int STRING_OK               = STRING_BACK + 1;
   public static final int STRING_YES              = STRING_OK + 1;
   public static final int STRING_NO               = STRING_YES + 1;
   public static final int STRING_CANCEL           = STRING_NO + 1;
   public static final int STRING_REPLAY_SAME      = STRING_CANCEL + 1;
   public static final int STRING_GET_MORE         = STRING_REPLAY_SAME + 1;

   public static final int STRING_PLAY             = STRING_GET_MORE + 1;
   public static final int STRING_GET_GAMES        = STRING_PLAY + 1;
   public static final int STRING_HELP             = STRING_GET_GAMES + 1;
   public static final int STRING_OPTIONS          = STRING_HELP + 1;
   public static final int STRING_EXIT             = STRING_OPTIONS + 1;

   public static final int STRING_HELP_1           = STRING_EXIT + 1;
   public static final int STRING_HELP_2           = STRING_HELP_1 + 1;
   public static final int STRING_HELP_3           = STRING_HELP_2 + 1;
   public static final int STRING_HELP_4           = STRING_HELP_3 + 1;
   public static final int STRING_MAIN_MENU        = STRING_HELP_4 + 1;

   public static final int STRING_PAUSED_RESUME    = STRING_MAIN_MENU + 1;
   public static final int STRING_PAUSED_QUIT      = STRING_PAUSED_RESUME + 1;
   public static final int STRING_PAUSED_HELP      = STRING_PAUSED_QUIT + 1;

   public static final int STRING_REPLAY           = STRING_PAUSED_HELP + 1;
   public static final int STRING_MENU             = STRING_REPLAY + 1;

   public static final int FIRST_SETTING_STRING    = STRING_MENU + 1;
   public static final int STRING_SOUND            = FIRST_SETTING_STRING;
   public static final int STRING_MUSIC            = STRING_SOUND + 1;
   public static final int STRING_SHOW_BONUS_HELP  = STRING_MUSIC + 1;

   public static final int STRING_ROUND            = STRING_SHOW_BONUS_HELP + 1;
   public static final int STRING_CATEGORY         = STRING_ROUND + 1;
   public static final int STRING_WINNINGS         = STRING_CATEGORY + 1;
   public static final int STRING_TOTAL_WINNINGS   = STRING_WINNINGS + 1;
   public static final int STRING_MIN_WINNINGS     = STRING_TOTAL_WINNINGS + 1;
   public static final int STRING_GAME_OVER        = STRING_MIN_WINNINGS + 1;
   public static final int STRING_GRAND_TOTAL      = STRING_GAME_OVER + 1;
   public static final int STRING_YOUR_RANK        = STRING_GRAND_TOTAL + 1;
   public static final int STRING_RANK             = STRING_YOUR_RANK + 1;
   public static final int STRING_CURRENT_RANK     = STRING_RANK + 1;
   public static final int STRING_LAST_RANK        = STRING_CURRENT_RANK + 1;
   public static final int STRING_BEST_RANK        = STRING_LAST_RANK + 1;

   public static final int STRING_TURNS            = STRING_BEST_RANK + 1;
   public static final int STRING_1_TURN           = STRING_TURNS + 1;
   public static final int STRING_SPIN             = STRING_1_TURN + 1;
   public static final int STRING_SOLVE            = STRING_SPIN + 1;
   public static final int STRING_BUY              = STRING_SOLVE + 1;
   public static final int STRING_SPIN_SOLVE       = STRING_BUY + 1;
   public static final int STRING_SPIN_SOLVE_VOWEL = STRING_SPIN_SOLVE + 1;
   public static final int STRING_ONLY_VOWELS      = STRING_SPIN_SOLVE_VOWEL + 1;
   public static final int STRING_NO_VOWELS        = STRING_ONLY_VOWELS + 1;
   public static final int STRING_BUY_SOLVE        = STRING_NO_VOWELS + 1;

   public static final int STRING_CHOOSE_VOWEL     = STRING_BUY_SOLVE + 1;
   public static final int STRING_CHOOSE_CONSONANT = STRING_CHOOSE_VOWEL + 1;
   public static final int STRING_CHOOSE_LETTERS   = STRING_CHOOSE_CONSONANT + 1;
   public static final int STRING_LANDED_ON        = STRING_CHOOSE_LETTERS + 1;
   public static final int STRING_LOST_TURN        = STRING_LANDED_ON + 1;
   public static final int STRING_WIN_FREE_SPIN    = STRING_LOST_TURN + 1;
   public static final int STRING_WIN_JACKPOT      = STRING_WIN_FREE_SPIN + 1;
   public static final int STRING_BANKRUPT         = STRING_WIN_JACKPOT + 1;
   public static final int STRING_JACKPOT_SOLVE    = STRING_BANKRUPT+1;
   public static final int STRING_JACKPOT_WON      = STRING_JACKPOT_SOLVE + 1;
   public static final int STRING_JACKPOT_LOST     = STRING_JACKPOT_WON + 1;
   public static final int STRING_FREE_SPIN_WON    = STRING_JACKPOT_LOST + 1;
   public static final int STRING_FREE_SPIN_LOST   = STRING_FREE_SPIN_WON + 1;
   public static final int STRING_USE_FREE_SPIN    = STRING_FREE_SPIN_LOST + 1;

   public static final int STRING_OUT_OF_TURNS     = STRING_USE_FREE_SPIN + 1;
   public static final int STRING_OUT_OF_TIME      = STRING_OUT_OF_TURNS + 1;
   public static final int STRING_THERE_ARE_NO     = STRING_OUT_OF_TIME + 1;
   public static final int STRING_THERE_IS_1       = STRING_THERE_ARE_NO + 1;
   public static final int STRING_THERE_ARE        = STRING_THERE_IS_1 + 1;
   public static final int STRING_SOLVED           = STRING_THERE_ARE + 1;
   public static final int STRING_INCORRECT        = STRING_SOLVED + 1;
   public static final int STRING_CONTINUE         = STRING_INCORRECT + 1;
   public static final int STRING_BONUS_CORRECT_1  = STRING_CONTINUE + 1;
   public static final int STRING_BONUS_CORRECT_2  = STRING_BONUS_CORRECT_1 + 1;
   public static final int STRING_BONUS_FAILURE_1  = STRING_BONUS_CORRECT_2 + 1;
   public static final int STRING_BONUS_FAILURE_2  = STRING_BONUS_FAILURE_1 + 1;

   public static final int STRING_BONUS                    = STRING_BONUS_FAILURE_2 + 1;
   public static final int STRING_SPIN_WHEEL               = STRING_BONUS + 1;
   public static final int STRING_REVEALING                = STRING_SPIN_WHEEL + 1;
   public static final int STRING_BONUS_CHOOSE_CONSONANTS  = STRING_REVEALING + 1;
   public static final int STRING_BONUS_CHOOSE_CONSONANT   = STRING_BONUS_CHOOSE_CONSONANTS + 1;
   public static final int STRING_BONUS_CHOOSE_VOWEL       = STRING_BONUS_CHOOSE_CONSONANT + 1;

   public static final int STRING_RANK_0                   = STRING_BONUS_CHOOSE_VOWEL + 1;
   public static final int STRING_RANK_1                   = STRING_RANK_0 + 1;
   public static final int STRING_RANK_2                   = STRING_RANK_1 + 1;
   public static final int STRING_RANK_3                   = STRING_RANK_2 + 1;
   public static final int STRING_RANK_4                   = STRING_RANK_3 + 1;
   public static final int STRING_RANK_5                   = STRING_RANK_4 + 1;
   public static final int STRING_RANK_6                   = STRING_RANK_5 + 1;
   public static final int STRING_RANK_7                   = STRING_RANK_6 + 1;
   public static final int STRING_RANK_8                   = STRING_RANK_7 + 1;
   public static final int STRING_RANK_9                   = STRING_RANK_8 + 1;
   public static final int STRING_RANK_10                  = STRING_RANK_9 + 1;

   public static final int STRING_BONUS_QUALIFY            = STRING_RANK_10 + 1;
   public static final int STRING_BONUS_NO_QUALIFY         = STRING_BONUS_QUALIFY + 1;

   public static final int STRING_HELP_1_TEXT              = STRING_BONUS_NO_QUALIFY + 1;
   public static final int STRING_HELP_2_TEXT              = STRING_HELP_1_TEXT + 1;
   public static final int STRING_HELP_3_TEXT              = STRING_HELP_2_TEXT + 1;
   public static final int STRING_HELP_4_TEXT              = STRING_HELP_3_TEXT + 1;

   public static final int STRING_PLAYED_ALL               = STRING_HELP_4_TEXT + 1;
   public static final int STRING_CONFIRM_TITLE            = STRING_PLAYED_ALL + 1;
   public static final int STRING_CONFIRM_TEXT             = STRING_CONFIRM_TITLE + 1;
   public static final int STRING_CONNECTING_TITLE         = STRING_CONFIRM_TEXT + 1;
   public static final int STRING_CONNECTING_TEXT          = STRING_CONNECTING_TITLE + 1;
   public static final int STRING_DOWNLOADING_TITLE        = STRING_CONNECTING_TEXT + 1;
   public static final int STRING_LIST_TITLE               = STRING_DOWNLOADING_TITLE + 0;
   public static final int STRING_VERIFYING_TITLE          = STRING_LIST_TITLE + 0;
   public static final int STRING_DOWNLOADING_TEXT         = STRING_VERIFYING_TITLE + 1;
   public static final int STRING_VERIFYING_TEXT           = STRING_DOWNLOADING_TEXT + 1;
   public static final int STRING_DOWNLOAD_COMPLETE        = STRING_VERIFYING_TEXT + 1;
   public static final int STRING_ERROR_TITLE              = STRING_DOWNLOAD_COMPLETE + 1;
   public static final int STRING_ERROR_TEXT               = STRING_ERROR_TITLE + 1;
   public static final int STRING_CANCEL_SUBSCRIPTION      = (Config.USE_SPRINT_MRC ? STRING_ERROR_TEXT + 1 : -1);
   public static final int STRING_SUBSCRIPTION_EXPIRED     = ((Config.USE_NOKIA_MRC || Config.USE_DEBUG_MRC) ? STRING_ERROR_TEXT + 1 : -1);
   public static final int STRING_SUBSCRIPTION_ERROR       = ((Config.USE_NOKIA_MRC || Config.USE_DEBUG_MRC)? STRING_SUBSCRIPTION_EXPIRED + 1 : -1);

   public static final int STRING_BUY_FULL                 = ((Config.USE_NOKIA_MRC || Config.USE_DEBUG_MRC) ? STRING_SUBSCRIPTION_ERROR + 1 : Config.USE_SPRINT_MRC ? (STRING_CANCEL_SUBSCRIPTION + 1) : (STRING_ERROR_TEXT + 1));
   public static final int STRING_MORE_GAMES               = STRING_BUY_FULL+1;
   public static final int NUM_STRINGS                     = STRING_MORE_GAMES+1;





   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                           Fonts and Styles
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final int FONT_6x6_SHADOW             = 0;
   public static final int FONT_7x8_SHADOW             = 1;
   public static final int FONT_7x8_BLACK              = 2;

   public static final byte[] FONT_WIDTHS              = new byte[] {
      6,7,7
   };

   public static final byte[] FONT_HEIGHTS             = new byte[] {
      6,9,8
   };

   public static final byte[] FONT_HORIZONTAL_SPACINGS = new byte[] {
      0,1,1
   };

   public static final byte[] FONT_VERTICAL_SPACINGS   = new byte[] {
      1,1,1
   };

   public static final int BOTTOM_FONT_HEIGHT          = 6; // was 7;

   public static final int TITLE_FONT                  = FONT_7x8_SHADOW;
   public static final int MENU_ITEM_FONT              = FONT_6x6_SHADOW;
   public static final int BOLD_MENU_ITEM_FONT         = FONT_7x8_SHADOW;
   public static final int TEXT_BOX_FONT               = FONT_6x6_SHADOW;
   public static final int CHECKBOX_FONT               = FONT_6x6_SHADOW;
   public static final int BUTTON_FONT                 = FONT_6x6_SHADOW;
   public static final int FOOTER_FONT                 = FONT_7x8_SHADOW;

   public static final int BOARD_FONT                  = FONT_7x8_BLACK;
   public static final int MESSAGE_BOX_FONT            = FONT_6x6_SHADOW;
   public static final int BOTTOM_FONT                 = FONT_6x6_SHADOW; // was FONT_5x7_WHITE
   public static final int SELECTION_CHAR_FONT_AVAIL   = FONT_7x8_SHADOW;
   public static final int SELECTION_CHAR_FONT_UNAVAIL = FONT_7x8_BLACK;
   public static final int BONUS_LETTERS_FONT          = FONT_6x6_SHADOW;
   public static final int PRIZE_FONT                  = FONT_7x8_BLACK;

   public static final int TITLE_STYLE                 = TextComponent.ALIGN_CENTER | TITLE_FONT;
   public static final int BUTTON_STYLE                = TextComponent.ALIGN_CENTER | BUTTON_FONT;
   public static final int FOOTER_STYLE                = TextComponent.ALIGN_CENTER | FOOTER_FONT         | TextComponent.MULTI_LINE;
   public static final int MENU_ITEM_STYLE             = TextComponent.ALIGN_CENTER | MENU_ITEM_FONT      | TextComponent.MULTI_LINE;
   public static final int TEXT_BOX_STYLE              = TextComponent.ALIGN_CENTER | TEXT_BOX_FONT       | TextComponent.MULTI_LINE;
   public static final int BOLD_MENU_ITEM_STYLE        = TextComponent.ALIGN_CENTER | BOLD_MENU_ITEM_FONT | TextComponent.MULTI_LINE;
   public static final int CHECKBOX_STYLE              = TextComponent.ALIGN_LEFT   | CHECKBOX_FONT       | TextComponent.MULTI_LINE | TextComponent.CHECKBOX;
   public static final int BOTTOM_STYLE                = TextComponent.ALIGN_LEFT   | TextComponent.FIXED_HEIGHT | BOTTOM_FONT;
   public static final int JACKPOT_STYLE               = TextComponent.ALIGN_RIGHT  | TextComponent.FIXED_HEIGHT | BOTTOM_FONT;
   public static final int MESSAGE_BOX_STYLE           = TextComponent.ALIGN_CENTER | TextComponent.FIXED_HEIGHT | MESSAGE_BOX_FONT;
   public static final int GAME_BUTTON_STYLE           = TextComponent.ALIGN_LEFT   | BUTTON_FONT;


   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                            Colors
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final int BUTTON_COLOR                = 0x2100AD;
   public static final int SCROLL_BAR_COLOR            = 0x212452;
   public static final int GRID_BG_COLOR               = 0x212452;
   public static final int CONTENT_AREA_COLOR          = 0x2192AD;
   public static final int WINDOW_COLOR                = 0x4A6DAD;
   public static final int BANNER_COLOR                = 0x6B0052;
   public static final int SCROLL_SLIDER_COLOR         = 0x944900;        

   public static final int PROGRESS_FULL_COLOR         = SCROLL_SLIDER_COLOR;
   public static final int BUTTON_AREA_COLOR           = CONTENT_AREA_COLOR;
   public static final int MENU_ITEM_COLOR             = CONTENT_AREA_COLOR;
   public static final int PROGRESS_EMPTY_COLOR        = BUTTON_COLOR;

   public static final int WHEEL_OUTER_COLOR           = 0x4A92ff;
   public static final int WHEEL_INNER_COLOR           = 0x4ADB52;
   public static final int WHEEL_INNER_DIVIDER_COLOR   = 0x000000;
   public static final int WHEEL_OUTER_DIVIDER_COLOR   = 0x000000;
   public static final int WHEEL_WEDGE_DIVIDER_COLOR   = 0x000000;
   public static final int WHEEL_O_INNER_COLOR         = 0x000000;
   public static final int WHEEL_O_OUTER_COLOR         = 0xFFFFFF;

   public static final int BACKGROUND_COLOR            = 0x000000;
   public static final int BOTTOM_TEXT_BG_COLOR        = 0x000000;
   public static final int TILE_SEPARATOR_COLOR        = 0x000000;
   public static final int BAD_COLOR                   = 0x0092AD; // any time a turn is lost
   public static final int BOARD_COLOR                 = 0x21B652;
   public static final int BOTTOM_BAR_COLOR            = 0x6B92AD;
   public static final int REVEALING_TILE_COLOR        = 0x9400AD;
   public static final int UNAVAILABLE_LETTER_COLOR    = 0x999999;
   public static final int BOTTOM_TEXT_HIGHLIGHT_COLOR = 0xB5B6AD;
   public static final int BOTTOM_BAR_HIGHLIGHT_2_COLOR= 0xB5DBFF;
   public static final int BOTTOM_BAR_HIGHLIGHT_1_COLOR= 0xC6BEB5;
   public static final int SELECTED_TILE_COLOR         = 0xDE24FF;
   public static final int AVAILABLE_LETTER_COLOR      = 0xDE4900;
   public static final int FAILURE_COLOR               = 0xFF2452; // lost round
   public static final int POWER_BAR_COLOR             = 0xFFB600; 
   public static final int TILE_COLOR                  = 0xFFFFFF;

   public static final int INFO_BAR_COLOR_1            = 0x217B3A;
   public static final int INFO_BAR_COLOR_2            = 0x52CE6B;
   public static final int INFO_BAR_COLOR_3            = 0x3F6B54;
   public static final int INFO_BAR_STRIPE_COLOR       = 0x31529C;
   public static final int INFO_BAR_BG_COLOR           = 0x000000;

   public static final int SUCCESS_COLOR               = BOARD_COLOR; // free spin / solved
   public static final int BLANK_TILE_COLOR            = BOTTOM_BAR_COLOR;

   public static final int OUTLINE_COLOR_1             = 0xADC8FF;
   public static final int OUTLINE_COLOR_2             = 0x82AFB2;
   public static final int OUTLINE_COLOR_3             = 0x0DE1FF;
   public static final int OUTLINE_COLOR_4             = 0x0BBAD4;
   public static final int BOARD_TILE_COLOR            = 0x31B57E;

   public static final int NUM_BOARD_LINES             = 4;

   public static final int[] BOARD_COLORS              = (GAME_VERSION == VERSION_LARGE)
                                                         ? null : new int[] {
      OUTLINE_COLOR_2, OUTLINE_COLOR_3, OUTLINE_COLOR_4
   };

   public static final short[] BOARD_LINES_1            = 
   (GAME_VERSION == VERSION_SMALL) ? new short[] {

   }
   : (GAME_VERSION == VERSION_MEDIUM) ? new short[] {

      13, 0, 151, 0,
      151, 1, 151, 15,
      151, 15, 165, 15,
      164, 16, 164, 53,
      148, 50, 160, 60,
      151, 50, 151, 68,
      16, 65, 148, 65,
      16, 50, 16, 65,
      3, 50, 15, 50,
      3, 15, 3, 50,
      0, 18, 16, 18,
      16, 2, 16, 18,














   }
   : null;

   public static final short[] BOARD_LINES_2            = 
   (GAME_VERSION == VERSION_SMALL) ? new short[] {

   }
   : (GAME_VERSION == VERSION_MEDIUM) ? new short[] {

      13, 1,
      150, 16,
      163, 53,
      150, 68,
      13, 53,
      0, 15,
      13, 1









   }
   : null;

   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                        WOFApp Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------



   public static final int POPUP_WIDTH                 = 114;
   public static final int POPUP_HEIGHT                = 47;





   public static final int MIN_BANNER_YES              = 110;
   public static final int MAX_BANNER_NO               = 160;
   public static final int BANNER_OVERLAP              = 1;

   public static final int MAX_MENU_ITEM_LINES         = 4;
   public static final int MAX_BOLD_MENU_ITEM_LINES    = 2;
   public static final int MAX_CHECKBOX_LINES          = 2;
   public static final int MAX_FOOTER_LINES            = 2;
   public static final int MAX_TEXT_BOX_LINES          = 378;

   public static final int CHECKBOX_WIDTH              = 12;
   public static final int PROGRESS_BAR_HEIGHT         = 14;
   public static final int RANK_GAP                    = 6;
   public static final int RESULTS_GAP                 = 6;
   public static final int YOUR_RANK_GAP               = 5;
   public static final int WINDOW_MENU_SPACING         = 0;
   public static final int WINDOW_OPTIONS_SPACING      = 2;
   public static final int DEFAULT_MAX_SPACING         = 0;

   public static final int RANK_STAR_TOP               = 0;
   public static final int RANK_STAR_BOTTOM            = 7;
   public static final int RANK_X_GAP                  = 1;

   public static final int TITLE_INSET_TOP             = 2;
   public static final int TITLE_INSET_BOTTOM          = 1;

   public static final int WINDOW_BORDER_BEVEL         = 1;
   public static final int WINDOW_LEFT_GAP             = 2;    
   public static final int WINDOW_RIGHT_GAP            = 2;    
   public static final int WINDOW_TOP_GAP              = 2;    
   public static final int WINDOW_BOTTOM_GAP           = 2;   
   public static final int WINDOW_LARGEST_GAP          = 2;

   public static final int BOTTOM_BORDER_BEVEL         = 1;
   public static final int BOTTOM_BORDER_PAD_TOP       = 1;
   public static final int BOTTOM_BORDER_PAD_BOTTOM    = 0;
   public static final int BOTTOM_BORDER_PAD_LEFT      = 0;
   public static final int BOTTOM_BORDER_PAD_RIGHT     = 1;

   public static final int BUTTON_TOP                  = -1;
   public static final int BUTTON_BOTTOM               = -1;
   public static final int BUTTON_LEFT                 = 0;
   public static final int BUTTON_RIGHT                = 0;

   public static final int GAME_BUTTON_TOP             = 0;
   public static final int GAME_BUTTON_BOTTOM          = 0;
   public static final int GAME_BUTTON_LEFT            = 1;
   public static final int GAME_BUTTON_RIGHT           = 0;

   public static final Border BUTTON_BORDER            = new Border(Border.RAISED | Border.BEVELED, 2, 0, Component.HIGHLIGHT, Component.SHADOW);
   public static final Border GAME_BUTTON_BORDER       = new Border(Border.RAISED | Border.BEVELED, 2, 0, Component.HIGHLIGHT, Component.SHADOW);
   public static final Border MENU_ITEM_BORDER         = Border.newInsets(3,3,2,2);
   public static final Border CHECKBOX_BORDER          = Border.newInsets(CHECKBOX_WIDTH+4,2,3,2);
   public static final Border PROGRESS_BORDER          = Border.LOWERED_BORDER_2;
   public static final Border PROGRESS_OUTER_BORDER    = MENU_ITEM_BORDER;

   public static final Border BOTTOM_BORDER            = new Border(Border.LOWERED|Border.BEVELED, BOTTOM_BORDER_BEVEL, 0, WOFConstants.BOTTOM_TEXT_HIGHLIGHT_COLOR, WOFConstants.BOTTOM_BAR_COLOR);
   public static final Border MESSAGE_BOX_BORDER       = Border.newInsets(1, 1, 1, 1);

   public static final Border WINDOW_BORDER = new Border(
                                                        Border.BEVELED | Border.RAISED, WINDOW_BORDER_BEVEL);

   public static final Border WINDOW_BORDER_NO_TITLE = new Border(
                                                                 Border.BEVELED | Border.RAISED, WINDOW_BORDER_BEVEL);

   public static final Border BUTTON_AREA_BORDER = Border.LOWERED_BORDER_1;
   public static final Border CONTENT_AREA_BORDER = Border.LOWERED_BORDER_1;
   public static final Border SCROLL_BAR_BORDER = new Border(Border.BEVELED | Border.LOWERED, 1);
   public static final Border SCROLL_SLIDER_BORDER = Border.RAISED_BORDER_1;

   static {
      WINDOW_BORDER.left = WINDOW_BORDER_BEVEL + WINDOW_LEFT_GAP;
      WINDOW_BORDER.right = WINDOW_BORDER_BEVEL + WINDOW_RIGHT_GAP;
      WINDOW_BORDER.top = WINDOW_BORDER_BEVEL + WINDOW_TOP_GAP;
      WINDOW_BORDER.bottom = WINDOW_BORDER_BEVEL + WINDOW_BOTTOM_GAP;
      WINDOW_BORDER.thickness = WINDOW_BORDER_BEVEL + WINDOW_LARGEST_GAP;

      WINDOW_BORDER_NO_TITLE.left = WINDOW_BORDER_BEVEL + WINDOW_LEFT_GAP;
      WINDOW_BORDER_NO_TITLE.right = WINDOW_BORDER_BEVEL + WINDOW_RIGHT_GAP;
      WINDOW_BORDER_NO_TITLE.top = WINDOW_BORDER_BEVEL + WINDOW_TOP_GAP;
      WINDOW_BORDER_NO_TITLE.bottom = WINDOW_BORDER_BEVEL + WINDOW_BOTTOM_GAP;
      WINDOW_BORDER_NO_TITLE.thickness = WINDOW_BORDER_BEVEL + WINDOW_LARGEST_GAP;

      BUTTON_BORDER.top += BUTTON_TOP;
      BUTTON_BORDER.bottom += BUTTON_BOTTOM;
      BUTTON_BORDER.left += BUTTON_LEFT;
      BUTTON_BORDER.right += BUTTON_RIGHT;

      GAME_BUTTON_BORDER.top += GAME_BUTTON_TOP;
      GAME_BUTTON_BORDER.bottom += GAME_BUTTON_BOTTOM;
      GAME_BUTTON_BORDER.left += GAME_BUTTON_LEFT;
      GAME_BUTTON_BORDER.right += GAME_BUTTON_RIGHT;

      BOTTOM_BORDER.top += BOTTOM_BORDER_PAD_TOP;
      BOTTOM_BORDER.bottom += BOTTOM_BORDER_PAD_BOTTOM;
      BOTTOM_BORDER.left += BOTTOM_BORDER_PAD_LEFT;
      BOTTOM_BORDER.right += BOTTOM_BORDER_PAD_RIGHT;

      SCROLL_BAR_BORDER.top = SCROLL_BAR_BORDER.bottom = SCROLL_BAR_BORDER.left = SCROLL_BAR_BORDER.right = 0;
   };

   public static final boolean USE_BANNER              = (IMAGE_BANNER >= 0);


   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                     WOFGameState Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final int MIN_TICK_TIME = 1;
   public static final int TICK_TIME = 100;
   public static final int SPIN_TICKS = 30;
   public static final int SPIN_LINGER_TICKS = 4;
   public static final int RESULTS_TICKS = 8;
   public static final int REVEAL_TICKS = 6;
   public static final int POWER_SPEED = 5;


   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                     WOFView Wheel Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final boolean DRAW_PARTIAL_WHEEL      = true;

   public static final int POWER_BAR_Y1                = 2; // offset from bottom of top
   public static final int POWER_BAR_Y2                = 5; // offset from bottom of bottom
   public static final int POWER_BAR_X1                = 4; // offset from center of left
   public static final int POWER_BAR_MIN_X2            = 4; // offset from center of right (min power)
   public static final int POWER_BAR_MAX_X2            = 113; // offset from center of right (max power)
   public static final int POWER_INDICATOR_Y           = 0;
   public static final int POWER_INDICATOR_X_OFFSET    = -1;

   public static final int WHEEL_PHASE_OFFSET          = -6; // add this to the reported phase
   public static final int WHEEL_PARTIAL_X             = 2;
   public static final int WHEEL_PARTIAL_Y             = 2;


   public static final int POINTER_1_X                 = -54;
   public static final int POINTER_1_Y                 = -61;
   public static final int POINTER_2_X                 = -54;
   public static final int POINTER_2_Y                 = -61;








   public static final int[] WHEEL_WELL_DATA           = new int[] {
      (79 << 24) | 0x212452, (78 << 24) | 0x3961A5, (77 << 24) | 0x4275BD, (70 << 24) | 0x3961A5, (69 << 24) | 0x212452
   };
   public static final int WHEEL_INNER_RADIUS          = 21;
   public static final int WHEEL_OUTER_RADIUS          = 68;
   public static final int WHEEL_FINAL_RADIUS          = 71;

   public static final int WEDGE_X                     = 1-WHEEL_OUTER_RADIUS;
   public static final int WEDGE_Y                     = 1-WHEEL_OUTER_RADIUS;
   public static final int WEDGE_W                     = 2*WOFConstants.WHEEL_OUTER_RADIUS-1;
   public static final int WEDGE_H                     = 2*WOFConstants.WHEEL_OUTER_RADIUS-1;

   //  public static final int[] WHEEL_WELL_DATA       = null;

   public static final int WHEEL_LARGE_O_DIAMETER      = 7;
   public static final int WHEEL_SMALL_O_DIAMETER      = 5;

   public static final byte[] WHEEL_VAL_X              = new byte[] {
      48,  41,  28,  12, -7, -27, -45, -56, -63, -63, -56, -45, -27,  -7,  12,  28,  41,  48
   };

   public static final byte[] WHEEL_VAL_Y              = new byte[] {
      -16, -34, -50, -59, -63, -59, -50, -34, -16,   4,  22,  36,  47,  50,  47,  36,  22,   4  
   };

   public static final byte[] WHEEL_ICON_X             = new byte[] {
      48,  41,  28,  12, -7, -27, -45, -56, -63, -63, -56, -45, -27,  -7,  12,  28,  41,  48
   };

   public static final byte[] WHEEL_ICON_Y             = new byte[] {
      -16, -34, -50, -59, -63, -59, -50, -34, -16,   4,  22,  36,  47,  50,  47,  36,  22,   4
   };

   public static final byte[] WHEEL_LARGE_O_X          = new byte[] {
      36,  32,  23,  10, -4, -18, -31, -40, -45, -45, -40, -31, -18,  -4,  10,  23,  32,  36
   };

   public static final byte[] WHEEL_LARGE_O_Y          = new byte[] {
      -11, -25, -35, -43, -45, -43, -35, -25, -11,   3,  16,  27,  35,  37,  35,  27,  16,   3
   };

   public static final byte[] WHEEL_SMALL_O_X          = new byte[] {
      26,  23,  16,   7, -3, -13, -23, -29, -33, -33, -29, -23, -13,  -3,   7,  16,  23,  26
   };

   public static final byte[] WHEEL_SMALL_O_Y          = new byte[] {
      -8, -18, -26, -31, -33, -31, -26, -18,  -8,   2,  12,  20,  25,  27,  25,  20,  12,   2
   };


   public static final byte[] DIVIDER_X                = new byte[] {
      63,  53,  34,  12, -11, -34, -52, -63, -67, -64, -53, -34, -12,  11, 34, 52, 64, 67
   };

   public static final byte[] DIVIDER_Y                = new byte[] {
      -23, -43, -59, -66, -66, -60, -44, -23,   0,  23,  43,  59, 66, 66, 60, 44, 23,  0
   };


























































   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                     WOFView Board Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final int TILE_WIDTH                  = 12;
   public static final int TILE_HEIGHT                 = 14;
   public static final int TILE_SPACING_X              = 13;
   public static final int TILE_SPACING_Y              = 15;
   public static final int FIRST_TILE_X                = 5;
   public static final int FIRST_TILE_Y                = 5;
   public static final int BOARD_LETTER_X              = 3;
   public static final int BOARD_LETTER_Y              = 3;










   public static final int BOARD_LEFT                  = 4;
   public static final int BOARD_RIGHT                 = 4;
   public static final int BOARD_TOP                   = 4;
   public static final int BOARD_BOTTOM                = 4;

   public static final int BOARD_WIDTH                 = TILE_SPACING_X * (WOFRound.LETTERS_PER_LINE + 1) - TILE_WIDTH + BOARD_LEFT + BOARD_RIGHT;

   public static final int BOARD_HEIGHT                = TILE_SPACING_Y * (WOFRound.NUM_LINES + 1) - TILE_HEIGHT + BOARD_TOP + BOARD_BOTTOM;

   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                     WOFView Bottom Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------

   public static final int BOTTOM_BAR_HIGHLIGHT_1_HEIGHT   = 0;
   public static final int BOTTOM_BAR_HIGHLIGHT_2_HEIGHT   = 1;
   public static final int BOTTOM_BAR_GAP_1                = 0;
   public static final int BOTTOM_BAR_GAP_2                = 0;
   public static final int BOTTOM_BAR_GAP_3                = 1;

   public static final int TURNS_X                     = 0;
   public static final int TURNS_Y                     = BOTTOM_BAR_GAP_1;
   public static final int TURNS_W                     = 39;
   public static final int TURNS_H                     = BOTTOM_FONT_HEIGHT + 2 * BOTTOM_BORDER_BEVEL + BOTTOM_BORDER_PAD_TOP + BOTTOM_BORDER_PAD_BOTTOM;
   public static final int MONEY_X                     = TURNS_X;
   public static final int MONEY_Y                     = TURNS_Y + TURNS_H + BOTTOM_BAR_GAP_2;
   public static final int MONEY_W                     = TURNS_W;
   public static final int MONEY_H                     = TURNS_H;
   public static final int JACKPOT_X                   = MONEY_X + MONEY_W;
   public static final int JACKPOT_Y                   = MONEY_Y;
   public static final int JACKPOT_W                   = 39;
   public static final int JACKPOT_H                   = MONEY_H;
   public static final int JACKPOT_ICON_X              = JACKPOT_X - 2;
   public static final int JACKPOT_ICON_Y              = JACKPOT_Y;

   public static final int BOTTOM_BAR_HEIGHT           = BOTTOM_BAR_HIGHLIGHT_1_HEIGHT + BOTTOM_BAR_HIGHLIGHT_2_HEIGHT + BOTTOM_BAR_GAP_1 + TURNS_H + BOTTOM_BAR_GAP_2 + MONEY_H + BOTTOM_BAR_GAP_3;


   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                     WOFView Info Bar Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final int INFOBAR_GAP                 = 1;

   public static final int SELECTION_X                 = -11;
   public static final int SELECTION_Y                 = 11;
   public static final int SELECTION_W                 = 22;
   public static final int SELECTION_H                 = 11;
   public static final int SELECTION_CHAR_X            = -4;
   public static final int SELECTION_CHAR_Y            = 13;

   public static final int MESSAGE_BOX_LEFT            = 3;
   public static final int MESSAGE_BOX_RIGHT           = 3;
   public static final int MESSAGE_BOX_TOP             = 2;
   public static final int MESSAGE_BOX_BOTTOM          = 3;
   public static final int MESSAGE_BOX_HEIGHT          = 7;
   public static final int MESSAGE_BOX_WIDTH           = 114;

   public static final int MESSAGE_BOX_TOTAL_HEIGHT    = MESSAGE_BOX_BOTTOM + MESSAGE_BOX_TOP + MESSAGE_BOX_HEIGHT;
   public static final int MESSAGE_BOX_TOTAL_WIDTH     = MESSAGE_BOX_LEFT + MESSAGE_BOX_RIGHT + MESSAGE_BOX_WIDTH;

   public static final boolean USE_SMALL_INFO_BAR      = true;
   public static final int INFO_BAR_OVERLAP            = 2;


   public static final byte[] INFO_BAR_DATA            = new byte[] {
      (byte)((INFO_BAR_COLOR_1 >> 16) & 0xFF), (byte)((INFO_BAR_COLOR_1 >> 8) & 0xFF), (byte)(INFO_BAR_COLOR_1 & 0xFF),
      1, 0, 1, 1,
      WOFConstants.MESSAGE_BOX_TOTAL_WIDTH-2, 0, 1, 1,
      0, 1, 1, WOFConstants.MESSAGE_BOX_HEIGHT + 2,
      WOFConstants.MESSAGE_BOX_TOTAL_WIDTH-1, 1, 1, WOFConstants.MESSAGE_BOX_HEIGHT + 2,
      1, WOFConstants.MESSAGE_BOX_HEIGHT + WOFConstants.MESSAGE_BOX_TOP + 1, 1, 1,
      WOFConstants.MESSAGE_BOX_TOTAL_WIDTH-2, WOFConstants.MESSAGE_BOX_HEIGHT + WOFConstants.MESSAGE_BOX_TOP + 1, 1, 1,
      2, WOFConstants.MESSAGE_BOX_TOTAL_HEIGHT - 1, WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - 4, 1,

      -1,
      (byte)((INFO_BAR_COLOR_2 >> 16) & 0xFF), (byte)((INFO_BAR_COLOR_2 >> 8) & 0xFF), (byte)(INFO_BAR_COLOR_2 & 0xFF),
      2, 0, WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - 4, 1,
      1, 1, 1, WOFConstants.MESSAGE_BOX_HEIGHT + 2,
      WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - 2, 1, 1, WOFConstants.MESSAGE_BOX_HEIGHT + 2,
      2, WOFConstants.MESSAGE_BOX_TOTAL_HEIGHT - 2, WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - 4, 1,

      -1,
      (byte)((INFO_BAR_COLOR_3 >> 16) & 0xFF), (byte)((INFO_BAR_COLOR_3 >> 8) & 0xFF), (byte)(INFO_BAR_COLOR_3 & 0xFF),
      2, 1, WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - 4, 1,
      2, 2, 1, WOFConstants.MESSAGE_BOX_HEIGHT + 2,
      WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - 3, 2, 1, WOFConstants.MESSAGE_BOX_HEIGHT + 2,
      2, WOFConstants.MESSAGE_BOX_TOTAL_HEIGHT - 3, WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - 4, 1,

      -1,
      (byte)((INFO_BAR_STRIPE_COLOR >> 16) & 0xFF), (byte)((INFO_BAR_STRIPE_COLOR >> 8) & 0xFF), (byte)(INFO_BAR_STRIPE_COLOR & 0xFF),
      WOFConstants.MESSAGE_BOX_LEFT, WOFConstants.MESSAGE_BOX_TOP+1, WOFConstants.MESSAGE_BOX_WIDTH, 1,
      WOFConstants.MESSAGE_BOX_LEFT, WOFConstants.MESSAGE_BOX_TOP+3, WOFConstants.MESSAGE_BOX_WIDTH, 1,
      WOFConstants.MESSAGE_BOX_LEFT, WOFConstants.MESSAGE_BOX_TOP+5, WOFConstants.MESSAGE_BOX_WIDTH, 1,

      -1,
      (byte)((INFO_BAR_BG_COLOR >> 16) & 0xFF), (byte)((INFO_BAR_BG_COLOR >> 8) & 0xFF), (byte)(INFO_BAR_BG_COLOR & 0xFF),
      WOFConstants.MESSAGE_BOX_LEFT, WOFConstants.MESSAGE_BOX_TOP+0, WOFConstants.MESSAGE_BOX_WIDTH, 1,
      WOFConstants.MESSAGE_BOX_LEFT, WOFConstants.MESSAGE_BOX_TOP+2, WOFConstants.MESSAGE_BOX_WIDTH, 1,
      WOFConstants.MESSAGE_BOX_LEFT, WOFConstants.MESSAGE_BOX_TOP+4, WOFConstants.MESSAGE_BOX_WIDTH, 1,
      WOFConstants.MESSAGE_BOX_LEFT, WOFConstants.MESSAGE_BOX_TOP+6, WOFConstants.MESSAGE_BOX_WIDTH, 1,
   };

   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------
   //
   //                        WOFView Constants
   //
   //-------------------------------------------------------------------------
   //-------------------------------------------------------------------------


   public static final int WHEEL_REDRAW_TICKS          = 72;
   public static final int TICKS_PER_MESSAGE           = 12;
   public static final int TICKS_PER_ENVELOPE_FRAME    = 2;
   public static final int BLINK_RATE                  = 1000;
   public static final int POWER_TIMEOUT_TICKS         = 200;

   public static final boolean BUTTONS_ON_BOTTOM       = false;
   public static final int SPIN_BUTTON_WIDTH           = 37;
   public static final int SOLVE_BUTTON_WIDTH          = 37;
   public static final int VOWEL_BUTTON_WIDTH          = 60;
   public static final int SPIN_BUTTON_HEIGHT          = 10;
   public static final int SOLVE_BUTTON_HEIGHT         = 10;
   public static final int VOWEL_BUTTON_HEIGHT         = 10;

   public static final int FREE_SPIN_X                 = SPIN_BUTTON_WIDTH + 1; // relative to origin of spin button
   public static final int FREE_SPIN_Y                 = 4; // relative to origin of spin button    

   public static final int BONUS_LETTERS_X             = 11;
   public static final int BONUS_LETTERS_Y             = -9;
   public static final int RSTLNE_X                    = 11;
   public static final int RSTLNE_Y                    = -18;

   // center of location for prize amount, relative to top left of envelope.
   public static final byte[] ENVELOPE_DATA            = new byte[] {
      0, -28, 28,
      1, -2, 23,
      1, -1, 13,
      2, -1, 5,
      2,  1, 5,
      1,  1, 13,
      1,  2, 23
   };


   public static final int PRIZE_X                     = 54;
   public static final int PRIZE_Y                     = 32;




}
