






    





    



/*
 * WOFData.java
 * Created on Oct 21, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;

import javax.microedition.io.*;
import javax.microedition.midlet.*;
import javax.microedition.rms.*;

/**
 * @author glewis
 */
public class WOFData implements Runnable {
   public static final boolean ECHO_NETWORK_DATA = false;
   public static final boolean USE_DEBUG_TRANSPORT = false;
   public static final String DEFAULT_DATA_FILE = "/default.txt";

   public static byte[] settings;

   public static final int MESSAGE_TYPE_GAME = 0;
   public static final int MESSAGE_TYPE_LIST = 1;

   public static final String RECORD_STORE_NAME = "wf";
   public static final int INDEX_SETTINGS = 1;
   public static final int INDEX_DATA = 2;

   public static final String[] PROPERTY_NAMES = new String[] {
      "dt", "ppid", "clr", "nm", "dsc", "val", "error", "gmid", "cat", "gmd",
      "ri", "rn", "rm"
   };

   public static final String[] PROPERTY_VALUES = new String[] {
      "pack", "message"
   };

   public static final int PROP_UNKNOWN = -1;
   public static final int PROP_DATA_TYPE = 0;
   public static final int PROP_PACK_ID = 1;
   public static final int PROP_COLOR = 2;
   public static final int PROP_NAME = 3;
   public static final int PROP_DESCRIPTION = 4;
   public static final int PROP_VALUE = 5;
   public static final int PROP_ERROR = 6;
   public static final int PROP_GAME_ID = 7;
   public static final int PROP_CATEGORY = 8;
   public static final int PROP_GAME_DATA = 9;

   public static final int PROP_REMEMBERED_PACK_ID = 10; 
   public static final int PROP_REMEMBERED_PACK_NEXT = 11; 
   public static final int PROP_REMEMBERED_MESSAGE = 12; 

   public static final int PROP_TYPE_PACK = 0;
   public static final int PROP_TYPE_MESSAGE = 1;

   public static final int MAX_REMEMBERED_PACKS = 1;



   public static final int MAX_REMEMBERED_MESSAGES = 10;
   public static final int MAX_MESSAGES = 4;

   public static final int MAX_LIST_SIZE = 10;
   public static final int MAX_LIST_NAME_LENGTH = 20;
   public static final int MAX_LIST_DESCRIPTION_LENGTH = 20;

   public static final int NULL_ID = -1;
/*    
    public static final int DATA_SIZE = WOFPack.DATA_SIZE
                                      + MAX_REMEMBERED_PACKS * 8
                                      + MAX_REMEMBERED_MESSAGES * 4;
*/                                    
   public static final int MAX_NETWORK_DATA = (WOFConstants.GAME_VERSION == WOFConstants.VERSION_LARGE) ? 15000 : 7000;
   public static final int MIN_VERIFIED_PERCENT    = 1;
   public static final int SKIP_VERIFY_PERCENT     = MIN_VERIFIED_PERCENT;
   public static final int VERIFY_COMPLETE_PERCENT = 25;
   public static final int OPEN_CONNECTION_PERCENT = 35;
   public static final int READ_DATA_PERCENT       = 50;

   public static final int STATE_IDLE = 0;
   public static final int STATE_REQUESTED = 1;
   public static final int STATE_QUERYING = 2;
   public static final int STATE_CANCELED = 3;
   public static final int STATE_DESTROYED = 4;

   public int state = STATE_IDLE;
   public boolean requestList;
   public int requestPPID;
   public int requestStart;
   public Throwable error;

   /** id of packs that we remember the last played game of. */
   public int[] packIDs = new int[MAX_REMEMBERED_PACKS];

   /** index of next game to be played. */
   public int[] nextGame = new int[MAX_REMEMBERED_PACKS];

   public WOFMessage[] messages = new WOFMessage[MAX_MESSAGES];
   public WOFMessage tempMessage = new WOFMessage();


//    /** data for the messages in memory. */
//    public byte[][] messages = new byte[MAX_MESSAGES+1][MAX_MESSAGE_SIZE];
//    
//    /** ids of the messages in memory. first empty slot filled. */
//    public int[] messageIDs = new int[MAX_MESSAGES+1];
//    
//    /** length of messages in memory. */
//    public int[] messageLengths = new int[MAX_MESSAGES+1];
//    
//    /** colors of messages in memory. */
//    public int[] messageColors = new int[MAX_MESSAGES+1];
//    
//    public byte[][] messageNames = new byte[MAX_MESSAGES+1][MAX_MESSAGE_NAME_SIZE];
//    public int[] messageNameLengths = new int[MAX_MESSAGES+1];

   /** ids of the messages we remember reading. new ones added at index 0. */
   public int[] readMessages = new int[MAX_REMEMBERED_MESSAGES];

   public WOFPack[] packs = new WOFPack[WOFPack.PACKS_PER_DOWNLOAD];

   public int packListSize;
   public int[] packListIDs = new int[MAX_LIST_SIZE];
   public int[] packListColors = new int[MAX_LIST_SIZE];
   public int[] packListNameLengths = new int[MAX_LIST_SIZE];
   public int[] packListDescriptionLengths = new int[MAX_LIST_SIZE];
   public byte[][] packListNames = new byte[MAX_LIST_SIZE][MAX_LIST_NAME_LENGTH];
   public byte[][] packListDescriptions = new byte[MAX_LIST_SIZE][MAX_LIST_DESCRIPTION_LENGTH];

   public boolean parsedList;
   public byte[] parseBuf = new byte[MAX_NETWORK_DATA];
   public ByteInStream parseIn = new ByteInStream(parseBuf);
   public DataInputStream parseDin = new DataInputStream(parseIn);
   public PropertyReader reader = new PropertyReader();


   public RecordStore rs;

//    public ByteInStream bin;
   public ByteOutStream bout;
//    public DataInputStream din;
   //public DataOutputStream dout;
   public PrintStream pout;
//    public byte[] storageBuffer;
   public ProgressMonitor progress;
   public String baseURL;

   public DataInputStream netIn;
   public Connection netConn;
   public Subscription subscription;

   /** A simple constructor. */
   public WOFData(String baseURL, int numSettings, MIDlet midlet) throws IOException
   {
      this.baseURL = baseURL;
      //if (Config.USE_NOKIA_MRC) {
      //    if (Config.USE_DEBUG_MRC) {
      //        subscription = new ZaxisSubscription();
      //    } else {
      subscription = new Subscription(midlet);
      //    }
      //}
      settings = new byte[numSettings];
      progress = new ProgressMonitor();
      reader.setNameStrings(PROPERTY_NAMES);
      for (int i=MAX_MESSAGES; --i>=0;) {
         messages[i] = new WOFMessage();
      }
      for (int i=WOFPack.PACKS_PER_DOWNLOAD; --i>=0;) {
         packs[i] = new WOFPack();
      }
      clear();
//        storageBuffer = new byte[DATA_SIZE];
//        bin = new ByteInStream(storageBuffer);
//        din = new DataInputStream(bin);
      bout = new ByteOutStream(parseBuf);
      //dout = new DataOutputStream(bout);
      pout = new PrintStream(bout);





















      try {
         rs = RecordStore.openRecordStore(RECORD_STORE_NAME, true);
         if (rs.getNextRecordID() <= INDEX_DATA) {

            InputStream in = getClass().getResourceAsStream(DEFAULT_DATA_FILE);
            netIn = new DataInputStream(in);
            readIn();
            parse(reader);

            store();
         }
         else {
            loadSettings();
            load();
         }
      }
      catch (Exception e) {
         ;
         if (rs != null) {
            try {
               rs.closeRecordStore();
            }
            catch (Exception ex) {
               ;
            }
         }
         if (e instanceof IOException) {
            throw (IOException)e;
         }
         else {
            throw new IOException(e.toString());
         }
      }

      (new Thread(this)).start();
   }

   public void clear() {
      clearMessages();
      packListSize = 0;
      for (int i=MAX_REMEMBERED_PACKS; --i>=0;) {
         packIDs[i] = NULL_ID;
      }
      for (int i=WOFPack.PACKS_PER_DOWNLOAD; --i>=0;) {
         packs[i].packID = NULL_ID;
      }
      for (int i=MAX_REMEMBERED_MESSAGES; --i>=0;) {
         readMessages[i] = NULL_ID;
      }
   }

   /** must be called when this WOFData is no longer needed. */
   public void destroy() {
      try {
         synchronized (this) {
            state = STATE_DESTROYED;
            notifyAll();
         }

         if (rs != null) {
            rs.closeRecordStore();
            rs = null;
         }

      }
      catch (Exception e) {
         ;
      }
   }

   /** loads just the settings. */
   public void loadSettings() throws IOException {









      try {
         rs.getRecord(INDEX_SETTINGS, settings, 0);
      }
      catch (RecordStoreException e) {
         ;
         throw new IOException(e.toString());
      }

   }

   /** stores just the settings. */
   public void storeSettings() throws IOException {
      if (settings == null) return;













      try {
         if (rs.getNextRecordID() == INDEX_SETTINGS) {
            rs.addRecord(settings, 0, settings.length);
         }
         else {
            rs.setRecord(INDEX_SETTINGS, settings, 0, settings.length);
         }
      }
      catch (RecordStoreException e) {
         ;
         throw new IOException(e.toString());
      }

   }

   /** loads the current pack and message data. */
   public void load() throws IOException {
      try {
         synchronized (this) {
            if ((state != STATE_IDLE) && (state != STATE_DESTROYED)) {
               wait();
            }
         }
         parseIn.setPosition(0);














         parseIn.setCount(rs.getRecord(INDEX_DATA, parseBuf, 0));

         reader.reset(parseDin);
         reader.next(true);    
         //readObject(din);
         readData(reader);
      }
      catch (Exception e) {
         ;
         throw new IOException(e.toString());
      }
   }

   /** stores the current pack and message data. */
   public void store() throws IOException {
      try {
         synchronized (this) {
            if ((state != STATE_IDLE) && (state != STATE_DESTROYED)) {
               wait();
            }
         }
         bout.setPosition(0);
         writeData(pout);
         //writeObject(dout);


















         if (rs.getNextRecordID() < INDEX_DATA) {
            storeSettings();
         }
         if (rs.getNextRecordID() == INDEX_DATA) {
            rs.addRecord(parseBuf, 0, parseBuf.length);
         }
         else {
            rs.setRecord(INDEX_DATA, parseBuf, 0, parseBuf.length);
         }

      }
      catch (Exception e) {
         ;
         throw new IOException(e.toString());
      }
   }

   /**
    * returns the next message to be read of the specified type,
    * marking it as read.
    * The id of the message will be set to NULL_ID during this operation.
    * If no more messages of the specified type exist, null will be returned.
    */    
   public WOFMessage getNextMessage(int type) {
      for (int i=MAX_MESSAGES; --i>=0;) {
         WOFMessage msg = messages[i];
         if ((msg.type == type) && (msg.id != NULL_ID)) {
            System.arraycopy(messages, i+1, messages, i, MAX_MESSAGES-i-1);
            messages[MAX_MESSAGES-1] = msg;
            int index = MAX_REMEMBERED_MESSAGES - 1;
            for (int j=MAX_REMEMBERED_MESSAGES; --j>=0;) {
               if ((readMessages[j] == msg.id) || (readMessages[j] == NULL_ID)) {
                  index = j;
               }
            }
            System.arraycopy(readMessages, 0, readMessages, 1, index);
            readMessages[0] = msg.id;
            msg.id = NULL_ID;
            return msg;
         }
      }
      return null;
   }

   /**
    * returns the next game to be played.
    * This will continue to return the same WOFGame until finishedGame()
    * is called or a new pack is loaded.
    */
   public WOFGame getNextGame() {
      for (int i=0; i<packs.length; i++) {
         int id = packs[i].packID;
         if (id != NULL_ID) {
            int next = 0;
            for (int j=MAX_REMEMBERED_PACKS; --j>=0;) {
               if (packIDs[j] == id) {
                  next = nextGame[j];
                  break;
               }
            }
            if (next < packs[i].firstGameID + packs[i].numGames) {
               if (next < packs[i].firstGameID) {
                  next = packs[i].firstGameID;
               }
               return packs[i].games[next - packs[i].firstGameID];
            }
         }
      }
      return null;
   }

   /**
    * indicates that the current game was finished and getNextGame() should
    * advance to the next game.
    */
   public void finishedGame() {
      WOFGame next = getNextGame();
      if (next != null) {
         setNextGame(next.pack.packID, next.gameID+1);
      }
   }

   /**
    * resets the next game indicators so that the current games
    * in memory will be replayed.
    */
   public void replayGames() 
   {
      boolean found = false;
      for (int i=0; i<packs.length; i++)
      {
         if (packs[i].packID != NULL_ID)
         {
            found = true;
            setNextGame(packs[i].packID, packs[i].firstGameID);
            break;
         }
      }


      if (!found)
      {
         try {
            load();

            for (int i=0; i<packs.length; i++)
               if (packs[i].packID != NULL_ID)
               {
                  found = true;
                  setNextGame(packs[i].packID, packs[i].firstGameID);
                  break;
               }
         }
         catch (Exception e) {
            ;
         }

         if (!found)
         {
            try {
               InputStream in = getClass().getResourceAsStream(DEFAULT_DATA_FILE);
               netIn = new DataInputStream(in);
               readIn();
               parse(reader);

               store();
            }
            catch (Exception e) {
               ;
            }

            for (int i=0; i<packs.length; i++)
               if (packs[i].packID != NULL_ID)
                  setNextGame(packs[i].packID, packs[i].firstGameID);
         }
      }
   }

   /** initiates a network request for the list of packs. */
   public void requestList() {
      synchronized (this) {
         progress.setError(null);
         progress.setProgress(0);
         requestList = true;
         state = STATE_REQUESTED;
         notifyAll();
      }
   }

   /**
    * starts a network request for the specified pack.
    */    
   public void requestPack(int ppid) {
      if (ppid == NULL_ID) {
         requestList();
      }
      else {
         int index = 0;
         for (int i=packIDs.length; --i>=0;) {
            if (packIDs[i] == ppid) {
               index = nextGame[i];
               break;
            }
         }
         requestGames(ppid, index);
      }
   }

   /**
    * starts a network request for more games from the current or
    * following pack.
    */        
   public void requestMoreGames() {
      for (int i=packs.length; --i>=0;) {
         if ((packs[i].packID != NULL_ID) && (packs[i].numGames > 0)) {
            requestGames(packs[i].packID, packs[i].firstGameID + packs[i].numGames);
            return;
         }
      }
      requestList();
   }

   /**
    * returns true if the request was successfully canceled,
    * or false if the request already went through.
    */
   public boolean cancelRequest() {
      synchronized (this) {
         if (state == STATE_IDLE) {
            return false;
         }
         state = STATE_CANCELED;
         notifyAll();
         return true;
      }
   }


   //-----------------------------------------------------------    
   //-----------------------------------------------------------
   // The rest of this file contains implementation details.    
   //-----------------------------------------------------------    
   //-----------------------------------------------------------    


   public void setNextGame(int ppid, int next) {
      int index = MAX_REMEMBERED_PACKS - 1;
      for (int i=MAX_REMEMBERED_PACKS; --i>=0;) {
         if ((packIDs[i] == ppid) || (packIDs[i] == NULL_ID)) {
            index = i;
         }
      }
      System.arraycopy(packIDs, 0, packIDs, 1, index);
      System.arraycopy(nextGame, 0, nextGame, 1, index);
      packIDs[0] = ppid;
      nextGame[0] = next;
   }

   public void clearMessages() {
      for (int i=MAX_MESSAGES; --i>=0;) {
         messages[i].id = NULL_ID;
      }
   }

   public void parseList(PropertyReader reader) throws IOException {
      parsedList = true;
      packListSize = 0;
      clearMessages();
      while (true) {
         if (reader.getNameIndex() != PROP_DATA_TYPE) {
            break;
         }
         switch (reader.getValueIndex(PROPERTY_VALUES)) {
            case PROP_TYPE_PACK:
               {
                  if (packListSize >= MAX_LIST_SIZE) {
                     break;
                  }
                  while (true) {
                     int len;
                     switch (reader.getNameIndex()) {
                        case PROP_COLOR:
                           packListColors[packListSize] = reader.getHexValue();
                           break;
                        case PROP_DESCRIPTION:
                           len = reader.propertyValueLength;
                           if (len > MAX_LIST_DESCRIPTION_LENGTH) {
                              len = MAX_LIST_DESCRIPTION_LENGTH;
                           }
                           packListDescriptionLengths[packListSize] = len;
                           System.arraycopy(reader.propertyValue, 0,
                                            packListDescriptions[packListSize], 0,
                                            len);
                           break;
                        case PROP_NAME:
                           len = reader.propertyValueLength;
                           if (len > MAX_LIST_NAME_LENGTH) {
                              len = MAX_LIST_NAME_LENGTH;
                           }
                           packListNameLengths[packListSize] = len;
                           System.arraycopy(reader.propertyValue, 0,
                                            packListNames[packListSize], 0, len);
                           break;
                        case PROP_PACK_ID:
                           packListIDs[packListSize] = reader.getIntValue();
                           break;
                     }                    
                     if (!reader.next(false)) {
                        packListSize++;
                        break;
                     }
                  }
               } break;
            case PROP_TYPE_MESSAGE:
               {
                  tempMessage.parse(reader);
                  int id = tempMessage.id;
                  int index = MAX_REMEMBERED_MESSAGES;
                  while (--index>=0) {
                     if (readMessages[index] == id) {
                        break;
                     }
                  }
                  if (index == -1) {
                     while (++index < MAX_MESSAGES) {
                        if ((messages[index].id == id) || (messages[index].id == NULL_ID)) {
                           WOFMessage temp = messages[index];
                           messages[index] = tempMessage;
                           tempMessage = temp;
                           temp.id = NULL_ID;
                           break;
                        }
                     }
                  }
               } break;
         }
         reader.next(true);
      }
      if (packListSize == 0) {
         throw new IOException();
      }
   }

   public void parsePacks(PropertyReader reader) throws IOException {
      parsedList = false;
      packs[0].parse(reader);
      if (packs[0].numGames == 0) {
         throw new IOException();
      }
      int i=0;
      while (++i < WOFPack.PACKS_PER_DOWNLOAD) {
         if (reader.getNameIndex() != PROP_PACK_ID) {
            break;
         }
         packs[i].parse(reader);
      }
      for (; i < WOFPack.PACKS_PER_DOWNLOAD; i++) {
         packs[i].clear();
      }
   }

   public void parse(PropertyReader reader) throws IOException {
      packListSize = 0;
      packs[0].numGames = 0;
      packs[0].packID = NULL_ID;
      while (true) {
         switch (reader.getNameIndex()) {
            case PROP_DATA_TYPE:
               parseList(reader);
               return;
            case PROP_PACK_ID:
               parsePacks(reader);
               return;
         }
         if (!reader.next(true)) {
            return;
         }
      }
   }
/*
    public void readObject(DataInputStream in) throws IOException {
        for (int i=0; i<MAX_REMEMBERED_PACKS; i++) {
            packIDs[i] = in.readInt();
            nextGame[i] = in.readInt();
        }
        for (int i=0; i<MAX_REMEMBERED_MESSAGES; i++) {
            readMessages[i] = in.readInt();
        }
        for (int i=0; i<WOFPack.PACKS_PER_DOWNLOAD; i++) {
            packs[i].readObject(in);
        }        
    }
    
    public void writeObject(DataOutputStream out) throws IOException {
        for (int i=0; i<MAX_REMEMBERED_PACKS; i++) {
            out.writeInt(packIDs[i]);
            out.writeInt(nextGame[i]);
        }
        for (int i=0; i<MAX_REMEMBERED_MESSAGES; i++) {
            out.writeInt(readMessages[i]);
        }
        for (int i=0; i<WOFPack.PACKS_PER_DOWNLOAD; i++) {
            packs[i].writeObject(out);
        }
    }*/

   public void readData(PropertyReader reader) throws IOException {
      for (int i=0; i<MAX_REMEMBERED_PACKS; i++) {
         packIDs[i] = reader.getIntValue();
         reader.next(false);
         nextGame[i] = reader.getIntValue();
         reader.next(true);
      }
      for (int i=0; i<MAX_REMEMBERED_MESSAGES; i++) {
         readMessages[i] = reader.getIntValue();
         reader.next(true);
      }
      parse(reader);
   }

   public void writeData(PrintStream out) throws IOException {
      for (int i=0; i<MAX_REMEMBERED_PACKS; i++) {
         PropertyReader.print(out, PROPERTY_NAMES[PROP_REMEMBERED_PACK_ID], packIDs[i]);
         PropertyReader.print(out, PROPERTY_NAMES[PROP_REMEMBERED_PACK_NEXT], nextGame[i]);
      }
      for (int i=0; i<MAX_REMEMBERED_MESSAGES; i++) {
         PropertyReader.print(out, PROPERTY_NAMES[PROP_REMEMBERED_MESSAGE], readMessages[i]);
      }
      out.println();
      for (int i=0; i<WOFPack.PACKS_PER_DOWNLOAD; i++) {
         packs[i].writeData(out);
      }
      out.flush();
   }

   public void print() {
      StringBuffer sBuf = new StringBuffer();
      sBuf.append("WOFIndex: parsedList=");
      sBuf.append(parsedList);
      //System.out.println(sBuf);
      sBuf.setLength(0);
      sBuf.append("next games: ");
      for (int i=0; i<MAX_REMEMBERED_PACKS; i++) {
         if (packIDs[i] != NULL_ID) {
            sBuf.append(packIDs[i]);
            sBuf.append(":");
            sBuf.append(nextGame[i]);
            sBuf.append(" ");
         }
      }
      //System.out.println(sBuf);
      sBuf.setLength(0);
      sBuf.append("read messages: ");
      for (int i=0; i<MAX_REMEMBERED_MESSAGES; i++) {
         if (readMessages[i] != NULL_ID) {
            sBuf.append(readMessages[i]);
            sBuf.append(" ");
         }
      }
      //System.out.println(sBuf);
      sBuf.setLength(0);
      for (int i=0; i<MAX_MESSAGES; i++) {
         if (messages[i].id != NULL_ID) {
            messages[i].print();
         }
      }        
      for (int i=0; i<packListSize; i++) {
         sBuf.append("list item ");
         sBuf.append(i);
         sBuf.append(": id=");
         sBuf.append(packListIDs[i]);
         sBuf.append(" name=");
         sBuf.append(new String(packListNames[i], 0, packListNameLengths[i]));
         sBuf.append(" desc=");
         sBuf.append(new String(packListDescriptions[i], 0, packListDescriptionLengths[i]));
         sBuf.append(" color=");
         sBuf.append(packListColors[i]);
         //System.out.println(sBuf);
         sBuf.setLength(0);
      }        
      for (int i=0; i<packs.length; i++) {
         if (packs[i].packID != NULL_ID) {
            packs[i].print();
         }
      }
   }

   public void requestGames(int ppid, int startIndex) {
      synchronized (this) {
         progress.setError(null);
         progress.setProgress(0);
         requestList = false;
         requestPPID = ppid;
         requestStart = startIndex;
         state = STATE_REQUESTED;
         notifyAll();
      }
   }

   public void openConnection(int ppid, int start) throws IOException {
      if (USE_DEBUG_TRANSPORT) {
         String filename;
         filename = DEFAULT_DATA_FILE;
         InputStream in = getClass().getResourceAsStream(filename);
         netIn = new DataInputStream(in);
      }
      else {
         String url;
         if (ppid < 0) {
            url = baseURL + "?ls=1";
         }
         else {
            url = baseURL + "?ppid=" + ppid + "&gmid=" + start
                  + "&gmnb=" + WOFPack.GAMES_PER_DOWNLOAD;
         }
//    System.out.println("URL: "+url);
         if (ECHO_NETWORK_DATA) {
            //System.out.println(url);                    
         }
         netConn = Connector.open(url,Connector.READ,true);
         HttpConnection httpConn = (HttpConnection)netConn;                                      
//    System.out.println("Connection opened");                    
         httpConn.setRequestMethod(HttpConnection.POST);
         netIn = httpConn.openDataInputStream();
//    System.out.println("DataInputStream opened");                    
      }
   }



   public void readIn() throws IOException {
      try {
         progress.setProgress(OPEN_CONNECTION_PERCENT);
         int totalRead = 0;
         while (true) {
            int numRead = netIn.read(parseBuf, totalRead,
                                     MAX_NETWORK_DATA - totalRead);
            if (numRead <= 0) {
               break;
            }
            if (ECHO_NETWORK_DATA) {
               System.out.write(parseBuf, totalRead, numRead);
            }
            totalRead += numRead;
            progress.setProgress(OPEN_CONNECTION_PERCENT + (totalRead * READ_DATA_PERCENT) / MAX_NETWORK_DATA);
         }
         progress.setProgress(OPEN_CONNECTION_PERCENT + READ_DATA_PERCENT);
         parseIn.setPosition(0);
         parseIn.setCount(totalRead);
         reader.reset(parseDin);
         reader.next(true);    
      }
      finally {
         if (netIn != null) {
            try {
               netIn.close();
            }
            catch (IOException ex) {
               ;
            }
            netIn = null;
         }
         if (netConn != null) {
            try {
               netConn.close();
            }
            catch (IOException ex) {
               ;
            }
            netConn = null;
         }
      }
   }

   /**
    * handles the asynchronous network communication.
    * Public as an implementation side effect.
    */
   public void run() {
      boolean listRequest;
      int ppid;
      int start;       

      while (true) {
         synchronized (this) {
            notifyAll();
            switch (state) {
               case STATE_DESTROYED:
                  return;
               case STATE_IDLE:
               case STATE_CANCELED:
                  state = STATE_IDLE;
                  try {
                     wait();
                  }
                  catch (Exception e) {
                     ;
                  }
                  continue;
            }
            state = STATE_QUERYING;
            listRequest = requestList;
            ppid = requestPPID;
            start = requestStart;
         }

         try {
            //if (!Config.USE_NOKIA_MRC /* && !subscription.isSubscriptionValid() */ ) {
            subscription.verify();
            //System.out.println(subscription.getServerResponse());
            if (!subscription.isSubscriptionValid()) {
               throw new IllegalStateException(subscription.getServerResponse());
            }
            progress.setProgress(VERIFY_COMPLETE_PERCENT);
            //  } else {
            //      progress.setProgress(SKIP_VERIFY_PERCENT);
            //  }

            openConnection(listRequest ? -1 : ppid, start);
            readIn();                          
         }
         catch (Throwable t) {
            ;
            synchronized (this) {
               switch (state) {
                  case STATE_CANCELED:
                     state = STATE_IDLE;
                     continue;
                  case STATE_REQUESTED:
                     continue;
                  case STATE_DESTROYED:
                     return;
                  case STATE_QUERYING:
                     error = t;
                     state = STATE_IDLE;
                     progress.setError(t);
                     continue;
               }
            }
         }

         synchronized (this) {
            switch (state) {
               case STATE_CANCELED:
                  state = STATE_IDLE;
                  continue;
               case STATE_REQUESTED:
                  continue;
               case STATE_DESTROYED:
                  return;
            }                
            try {
               parse(reader);
               if ((parsedList && (packListSize == 0)) || ((!parsedList)
                                                           && ((packs[0].packID == NULL_ID) || (packs[0].numGames == 0)))) {
                  throw new IOException("Server Error");
               }
               error = null;
               state = STATE_IDLE;
               progress.setProgress(100);
            }
            catch (Throwable t) {
               ;
               error = t;
               state = STATE_IDLE;
               try {
                  load();
               }
               catch (Exception e) {
                  ;
               }
               progress.setError(t);
            }
         }
      }
   }
}
