






    





    



/*
 * WOFGameState.java
 * Created on Oct 18, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */


/**
 * @author glewis
 */
public class WOFGameState {
   public static final int INITIAL_JACKPOT_AMOUNT = 5000;
   public static final byte NUM_WHEEL_POSITIONS = 18;
   public static final int VOWEL_COST = 250;
   public static final int MIN_WINNINGS = 500;




   public static final int BONUS_ROUND_DURATION = 2 * 60 * 1000;


   public static final int DURATION_INFINITE = 0;
   public static final int GAME_NOT_STARTED = 0;
   public static final byte MIN_POWER = 0;
   public static final byte MAX_POWER = 36;
   public static final int MIN_POWER_EFFECT = NUM_WHEEL_POSITIONS;
   public static final int MAX_POWER_EFFECT = 3 * NUM_WHEEL_POSITIONS;

   public static final byte FIRST_LETTER = 'A'; // first selectable letter
   public static final byte LAST_LETTER = 'Z'; // last selectable letter
   public static final byte LETTER_GAP = 0; // not a letter - greyed out
   public static final byte LETTER_BLANK = 1; // hidden or no value set
   public static final byte LETTER_REVEAL = 2; // about to be revealed
   public static final byte NUM_BONUS_CONSONANTS = 3;
   public static final byte NUM_BONUS_VOWELS = 1;
   public static final int NUM_TURNS = 5;
   public static final byte[] BONUS_LETTERS = new byte[]{'R', 'S', 'T', 'L', 'N', 'E'};
   public static final byte[] VOWELS = new byte[]{'A', 'E', 'I', 'O', 'U'};
   public static final byte FIRST_KEY_PAD = '2';
   public static final byte LAST_KEY_PAD = '9';
   public static final byte[] KEY_PAD_LETTERS = new byte[]{'A', 'D', 'G', 'J', 'M', 'P', 'T', 'W', 'Z' + 1};

   public static final int BUTTON_SPIN = 0;
   public static final int BUTTON_SOLVE = 1;
   public static final int BUTTON_BUY_VOWEL = 2;

   // bg color for gap = blue, reveal = purple, all else = white
   // selection toggles between magenta and that bg color


   // need some other values? (what's under the free spin, what colors, envelopes, etc.?)
   public static final int BANKRUPT_MASK = 0x01000000;
   public static final int LOSE_TURN_MASK = 0x02000000;
   public static final int FREE_SPIN_MASK = 0x04000000;
   public static final int JACKPOT_MASK = 0x08000000;
   public static final int MONEY_MASK = 0x00FFFFFF;

   public static final int STATE_INIT = 0;
   public static final int STATE_START = 1;
   public static final int STATE_MAIN = 2;
   public static final int STATE_POWER = 3;
   public static final int STATE_SPIN = 4;
   public static final int STATE_SELECT = 5; // subs: cons, vowel, bonus
   public static final int STATE_SOLVE = 6;
   public static final int STATE_JACKPOT_SOLVE = 7;
   public static final int STATE_FREE_SPIN = 8;
   public static final int STATE_RESULTS = 9;
   public static final int STATE_GAME_OVER = 10;

   public static final int STATE_FLAG_RESET = 0x00;
   public static final int STATE_FLAG_VOWEL = 0x01;
   public static final int STATE_FLAG_JACKPOT = 0x02;
   public static final int STATE_FLAG_SHOWING_PRIZE = 0x04;

   public static final int RESULTS_LOSE_TURN = 0;
   public static final int RESULTS_BANKRUPT = 1;
   public static final int RESULTS_BAD_CHOICE = 2;
   public static final int RESULTS_GOOD_CHOICE = 3;
   public static final int RESULTS_JACKPOT_LOST = 5;
   public static final int RESULTS_FREE_SPIN_WON = 6;
   public static final int RESULTS_FREE_SPIN_LOST = 7;
   public static final int RESULTS_WRONG_SOLVE = 8;
   public static final int RESULTS_REVEAL_RSTLNE = 9;
   public static final int RESULTS_REVEAL_BONUS_LETTERS = 10;

   public static final int[][] WHEEL_POSITIONS = new int[][]
   {
      {
         LOSE_TURN_MASK,
         400,
         600,
         BANKRUPT_MASK,
         900,
         300 | FREE_SPIN_MASK,
         500,
         300,
         400,
         800,
         500,
         300,
         600,
         200, // 2500 in online game
         600,
         300,
         700,
         800
      },
      {
         LOSE_TURN_MASK,
         400,
         600,
         BANKRUPT_MASK,
         900,
         300 | FREE_SPIN_MASK,
         500,
         300,
         400,
         800,
         500 | JACKPOT_MASK,
         BANKRUPT_MASK,
         600,
         300, // 3500 in online game
         600,
         300,
         700,
         800},
      {
         LOSE_TURN_MASK,
         400,
         600,
         BANKRUPT_MASK,
         900,
         300 | FREE_SPIN_MASK,
         500,
         300,
         400,
         800,
         500,
         300,
         600,
         300, // 3500 in online game
         BANKRUPT_MASK,
         300,
         700,
         800
      },
      {
         10000,
         10000,
         20000,
         10000,
         10000,
         30000,
         10000,
         10000,
         20000,
         10000,
         10000,
         40000,
         10000,
         10000,
         20000,
         10000,
         10000,
         30000
      }
   };

   public static final int[][] WHEEL_COLORS = new int[][]
   {
      {
         0xEDF5DE,
         0xE9F52F,
         0xB083BE,
         0x000000,
         0xFE5917,
         0x51B68C,
         0xFFB310,
         0xFF357C,
         0xE9F52F,
         0xFE5917,
         0x51B68C,
         0xFFB310,
         0xFC1924,
         0x1188CC,
         0xB282C0,
         0xFE5917,
         0x51B68C,
         0xFB1821
      },
      {
         0xEDF5DE,
         0xE9F52F,
         0xB083BE,
         0x000000,
         0xFE5917,
         0x51B68C,
         0xFFB310,
         0xFF357C,
         0xE9F52F,
         0xFE5917,
         0xC00000,
         0x000000,
         0xFC1924,
         0xDF467F,
         0xB282C0,
         0xFE5917,
         0x51B68C,
         0xFB1821
      },
      {
         0xEDF5DE,
         0xE9F52F,
         0xB083BE,
         0x000000,
         0xFE5917,
         0x51B68C,
         0xFFB310,
         0xFF357C,
         0xE9F52F,
         0xFE5917,
         0x51B68C,
         0xFFB310,
         0xFC1924,
         0xDF467F,
         0x000000,
         0xFE5917,
         0x51B68C,
         0xFB1821
      },
      {
         0xE2CA9E,
         0xE2CA9E,
         0xFD3003,
         0xE2CA9E,
         0xE2CA9E,
         0x1B9741,
         0xE2CA9E,
         0xE2CA9E,
         0xE91BBD,
         0xE2CA9E,
         0xE2CA9E,
         0x396AE1,
         0xE2CA9E,
         0xE2CA9E,
         0xFFBA0C,
         0xE2CA9E,
         0xE2CA9E,
         0xFF97BB
      }
   };

   public static boolean isVowel(int c) {
      for (int i = VOWELS.length; --i >= 0;) {
         if (VOWELS[i] == c) {
            return true;
         }
      }
      return false;
   }

   public WOFRound round;
   public WOFListener listener;

   // puzzle board state
   public boolean[] revealed; // which letters have been revealed
   public byte[] currentLetters; // what letter should be drawn in each box
   public boolean[] lettersUsed; // which letters have already been used    
   public byte[] selectedLetters; // normally just first used - but in bonus you get multiple
   public byte numSelected; // how many letters have been selected?
   // (the value of selectedLetters[numSelected] is the current state of the one being chosen
   public byte currentIndex; // which letter of the puzzle is selected

   // situation
   public boolean moreVowels; // more vowels left in puzzle
   public boolean moreConsonants; // more consonants in puzzle
   public boolean solved;
   public boolean hadMoreVowels;
   public boolean hadMoreConsonants;

   // wheel state
   public byte wheelPower; // only valid after power selected.
   public byte wheelPosition; // position of wheel (during spin this will indicate initial position, after spin it will be final position.)

   // ui state
   public byte state; // current state
   public byte results; // most recent results to be displayed.
   public byte numMatches;
   public boolean waiting; // in window mode waiting for a response
   public byte stateFlags; // persist over multiple states 
   public int gameStartTime; // time at which current game began
   public short ticks; // number of 'ticks' since start of state
   public int tickTime; // time of last 'tick'
   public int gameDuration; // initial time on the clock (<=0 is infinite)
   public int secondsLeft;
   public byte buttonIndex; // which button has the focus?

   // player state
   public byte turns; // number of turns remaining
   public boolean hasFreeSpin; // number of free spins
   public boolean freeSpinTaken; // the free spin should not be on the wheel
   public int money; // money accumulated this round
   public int totalMoney; // total won - does this belong here?
   public int jackpotAmount; // value of jackpot

   public WOFGameState(WOFListener listener) {
      this.listener = listener;
      revealed = new boolean[WOFRound.NUM_LETTERS];
      currentLetters = new byte[WOFRound.NUM_LETTERS];
      lettersUsed = new boolean[LAST_LETTER - FIRST_LETTER + 1];
      selectedLetters = new byte[NUM_BONUS_CONSONANTS + NUM_BONUS_VOWELS];
      waiting = true;
   }

   public void init(WOFRound round) {
      this.round = round;
      numSelected = 0;
      stateFlags = 0;
      setState(STATE_INIT);
      gameStartTime = GAME_NOT_STARTED;
      buttonIndex = 0;
      wheelPosition = (byte) (((int) (System.currentTimeMillis() & 0xFFFFF)) % NUM_WHEEL_POSITIONS);
      if (round.roundNumber == WOFGame.BONUS_ROUND) {
         money = WHEEL_POSITIONS[WOFGame.BONUS_ROUND][wheelPosition];
      }
      else {
         money = 0;
      }
      jackpotAmount = 0;
      turns = NUM_TURNS;
      gameDuration = DURATION_INFINITE;
      for (int i = WOFRound.NUM_LETTERS; --i >= 0;) {
         revealed[i] = false;
         currentLetters[i] = LETTER_GAP;
      }
      for (int i = 1 + LAST_LETTER - FIRST_LETTER; --i >= 0;) {
         lettersUsed[i] = false;
      }
      selectedLetters[0] = FIRST_LETTER;
      checkChars();
      switch (round.roundNumber) {
         case WOFGame.BONUS_ROUND:
            hasFreeSpin = false;
            turns = 1;
            gameDuration = BONUS_ROUND_DURATION;
            for (int i = BONUS_LETTERS.length; --i >= 0;) {
               lettersUsed[BONUS_LETTERS[i] - FIRST_LETTER] = true;
            }
            break;
         case WOFGame.ROUND_1:
            hasFreeSpin = false;
            freeSpinTaken = false;
            totalMoney = 0;
            break;
         case WOFGame.JACKPOT_ROUND:
            jackpotAmount = INITIAL_JACKPOT_AMOUNT;
            break;
      }
      secondsLeft = gameDuration;
   }

   /**
    * updates states of solved, moreVowels, and moreConsonants.
    *
    * @return true if puzzle solved
    */
   public boolean checkChars() {
      solved = true;
      moreVowels = false;
      moreConsonants = false;
      for (int i = WOFRound.NUM_LETTERS; --i >= 0;) {
         int c = round.letters[i];
         if ((c >= FIRST_LETTER) && (c <= LAST_LETTER) && !revealed[i]) {
            if (isVowel(c)) {
               moreVowels = true;
            }
            else {
               moreConsonants = true;
            }
         }
         if ((c >= FIRST_LETTER) && (c <= LAST_LETTER) && (currentLetters[i] != c)) {
            solved = false;
         }
      }
      if (solved) {
         moreVowels = false;
         moreConsonants = false;
      }
      else if (hadMoreVowels && !moreVowels) {
         listener.handleEvent(WOFListener.EVENT_CONSONANTS_ONLY);
      }
      else if (hadMoreConsonants && !moreConsonants) {
         listener.handleEvent(WOFListener.EVENT_VOWELS_ONLY);
      }
      hadMoreConsonants = moreConsonants;
      hadMoreVowels = moreVowels;
      if (round.roundNumber == WOFGame.BONUS_ROUND) {
         buttonIndex = 0;
      }
      else if (((buttonIndex == BUTTON_SPIN) && !moreConsonants)
               || ((buttonIndex == BUTTON_BUY_VOWEL) && ((money < VOWEL_COST) || !moreVowels))) {
         buttonIndex = BUTTON_SOLVE;
      }
      return solved;
   }

   /**
    * advance selection to the next modifiable character.
    */
   public void nextLocation(boolean forward) {
      int advance = forward ? 1 : -1;
      while (true) {
         currentIndex = (byte) ((currentIndex + WOFRound.NUM_LETTERS + advance) % WOFRound.NUM_LETTERS);
         if ((!revealed[currentIndex])
             && (round.letters[currentIndex] >= FIRST_LETTER)
             && (round.letters[currentIndex] <= LAST_LETTER)) {
            break;
         }
      }
   }

   /**
    * changes the actual letter selected - both for solving and selecting.
    *
    * @return true if key was handled (not necessarilly changed, though.)
    */
   public boolean nextChar(int keyCode, int gameAction) {
      boolean forward = true;
      int minVal = FIRST_LETTER;
      int maxVal = LAST_LETTER;
      if ((keyCode >= FIRST_KEY_PAD) && (keyCode <= LAST_KEY_PAD)) {
         minVal = KEY_PAD_LETTERS[keyCode - FIRST_KEY_PAD];
         maxVal = KEY_PAD_LETTERS[keyCode - FIRST_KEY_PAD + 1] - 1;
      }
      else if ((keyCode >= 'a') && (keyCode <= 'z')) {
         minVal = maxVal = keyCode + FIRST_LETTER - 'a';
      }
      else if ((keyCode >= 'A') && (keyCode <= 'Z')) {
         minVal = maxVal = keyCode + FIRST_LETTER - 'A';
      }
      else if (gameAction == Constants.KEY_DOWN) {
         forward = false;
      }
      else if (gameAction != Constants.KEY_UP) {
         return false;
      }
      int advance = forward ? 1 : -1;
      int range = maxVal - minVal + 1;
      if (state == STATE_SOLVE) {
         int oldC = currentLetters[currentIndex];
         int c = oldC;
         if ((c < minVal) || (c > maxVal)) {
            c = forward ? maxVal : minVal;
         }
         while (true) {
            c += advance;
            if (c > maxVal) {
               c = minVal;
            }
            else if (c < minVal) {
               c = maxVal;
            }
            if (!lettersUsed[c - FIRST_LETTER]) {
               currentLetters[currentIndex] = (byte) c;
               break;
            }
            if ((c == oldC) || (forward && (c == maxVal)
                                && ((oldC < minVal) || (oldC > maxVal)))) {
               break;
            }
         }
      }
      else {
         boolean vowel = ((round.roundNumber == WOFGame.NUM_ROUNDS - 1)
                          && (numSelected >= NUM_BONUS_CONSONANTS))
                         || ((stateFlags & STATE_FLAG_VOWEL) != 0);
         int oldC = selectedLetters[numSelected];
         int c = oldC;
         if ((c < minVal) || (c > maxVal)) {
            c = forward ? maxVal : minVal;
         }
         while (true) {
            c += advance;
            if (c > maxVal) {
               c = minVal;
            }
            else if (c < minVal) {
               c = maxVal;
            }
//                if ((!lettersUsed[c-FIRST_LETTER]) && (vowel == isVowel(c))) {
            if (vowel == isVowel(c)) {
               selectedLetters[numSelected] = (byte) c;
               break;
            }
            if ((c == oldC) || (forward && (c == maxVal)
                                && ((oldC < minVal) || (oldC > maxVal)))) {
               break;
            }
         }
      }
      return true;
   }

   public void resume(boolean selection) {
      switch (state) {
         case STATE_FREE_SPIN:
            if (selection) {
               hasFreeSpin = false;
               turns = 1;
               setState(STATE_MAIN);
            }
            else {
               turns = 0;
               setState(STATE_GAME_OVER);
            }
            break;
         case STATE_JACKPOT_SOLVE:
            if (selection) {
               stateFlags |= STATE_FLAG_JACKPOT;
               setState(STATE_SOLVE);
            }
            else {
               setResults(RESULTS_JACKPOT_LOST);
            }
            break;
         case STATE_INIT:
            setState(STATE_START);
            break;
      }
      ticks = 0;
      waiting = false;
   }


   int oldState;
/*    public static final int STATE_INIT = 0;
    public static final int STATE_START = 1;
    public static final int STATE_MAIN = 2;
    public static final int STATE_POWER = 3;
    public static final int STATE_SPIN = 4;
    public static final int STATE_SELECT = 5; // subs: cons, vowel, bonus
    public static final int STATE_SOLVE = 6;
    public static final int STATE_JACKPOT_SOLVE = 7;
    public static final int STATE_FREE_SPIN = 8;
    public static final int STATE_RESULTS = 9;
    public static final int STATE_GAME_OVER = 10;
*/
   public void setState(int newState) {
      oldState = state;
      if (oldState != newState && (newState == STATE_MAIN || newState == STATE_START)) oldState = -1;
      state = (byte) newState;
      tickTime = (int) System.currentTimeMillis();
      ticks = 0;
      switch (newState) {
         case STATE_SPIN:
            listener.handleEvent(WOFListener.EVENT_SPIN);
            break;
         case STATE_START:
            gameStartTime = tickTime;
            if (gameStartTime == GAME_NOT_STARTED) {
               gameStartTime = GAME_NOT_STARTED - 1;
            }
            listener.handleEvent(WOFListener.EVENT_START);
            break;
         case STATE_SOLVE:
            currentIndex = -1;
            nextLocation(true);
            break;
         case STATE_FREE_SPIN:
            listener.gameStateChanged(WOFListener.GAME_STATE_USE_FREE_SPIN);
            waiting = true;
            break;
         case STATE_JACKPOT_SOLVE:
            listener.gameStateChanged(WOFListener.GAME_STATE_JACKPOT_SOLVE);
            waiting = true;
            break;
         case STATE_SELECT:
            boolean vowel = ((stateFlags & STATE_FLAG_VOWEL) != 0) || (numSelected >= NUM_BONUS_CONSONANTS);
            if (isVowel(selectedLetters[numSelected]) ^ vowel) {
               selectedLetters[numSelected] = FIRST_LETTER;
               while (isVowel(selectedLetters[numSelected]) != vowel) {
                  selectedLetters[numSelected]++;
               }
            }
            break;
         case STATE_MAIN:
            stateFlags = 0;
            numSelected = 0;
            break;
         case STATE_GAME_OVER:
            if (solved) {
               listener.handleEvent(WOFListener.EVENT_SOLVED);
            }
            else if (turns == 0) {
               listener.handleEvent(WOFListener.EVENT_OUT_OF_TURNS);
            }
            else {
               listener.handleEvent(WOFListener.EVENT_OUT_OF_TIME);
            }
            for (int i = WOFRound.NUM_LETTERS; --i >= 0;) {
               int c = round.letters[i];
               if ((c >= FIRST_LETTER) && (c <= LAST_LETTER)) {
                  revealed[i] = true;
                  currentLetters[i] = (byte) c;
               }
            }
            break;
      }
   }

   public void checkMatches() {
      numMatches = 0;
      boolean bonusRound = (round.roundNumber == WOFGame.BONUS_ROUND);
      boolean rstlne;
      byte[] chars;
      int numSel;
      if (numSelected == 0) {
         rstlne = true;
         chars = BONUS_LETTERS;
         numSel = chars.length;
      }
      else {
         rstlne = false;
         numSel = numSelected;
         chars = selectedLetters;
//            numSelected = 0;
      }
      while (--numSel >= 0) {
         byte c = chars[numSel];
         for (int i = WOFRound.NUM_LETTERS; --i >= 0;) {
            if (round.letters[i] == c) {
               numMatches++;
//                    if (bonusRound) {
//                        revealed[i] = true;
//                        currentLetters[i] = c;
//                    } else {
               currentLetters[i] = LETTER_REVEAL;
//                    }
            }
         }
      }
      int val = WHEEL_POSITIONS[round.roundNumber][wheelPosition];
      if (rstlne) {
         setResults(RESULTS_REVEAL_RSTLNE);
      }
      else if (bonusRound) {
         setResults(RESULTS_REVEAL_BONUS_LETTERS);
//        if (rstlne) {
//            setState(STATE_SELECT);
//        } else if (bonusRound) {
//            if (solved) {
//                setState(STATE_GAME_OVER);
//            } else {
//                setState(STATE_SOLVE);
//            }
      }
      else if (numMatches == 0) {
         turns--;
         if (((val & FREE_SPIN_MASK) != 0) && !freeSpinTaken) {
            setResults(RESULTS_FREE_SPIN_LOST);
         }
         else if (((val & JACKPOT_MASK) != 0) && ((stateFlags & STATE_FLAG_VOWEL) == 0)) {
            setResults(RESULTS_JACKPOT_LOST);
         }
         else {
            setResults(RESULTS_BAD_CHOICE);
         }
      }
      else {
         if (((val & FREE_SPIN_MASK) != 0) && !freeSpinTaken) {
            freeSpinTaken = true;
            hasFreeSpin = true;
            setResults(RESULTS_FREE_SPIN_WON);
         }
         else {
            if (((val & JACKPOT_MASK) == 0) && ((stateFlags & STATE_FLAG_VOWEL) == 0)) {
               money += numMatches * (val & MONEY_MASK);
            }
            setResults(RESULTS_GOOD_CHOICE);
         }
      }
   }

   public void keyPressed(int keyCode, int gameAction) {
      if (Config.ENABLE_CHEATS && (keyCode == '0')) {
         setState(STATE_SOLVE);
         for (int i = WOFRound.NUM_LETTERS; --i >= 0;) {
            currentLetters[i] = round.letters[i];
         }
         checkChars();
         setState(STATE_GAME_OVER);
      }
      else if (gameAction == Constants.KEY_BACK) {
         waiting = true;
         listener.gameStateChanged(WOFListener.GAME_STATE_PAUSED);
      }
      else if (gameAction == Constants.KEY_FIRE) {
         switch (state) {
            case STATE_MAIN:
               switch (buttonIndex) {
                  case BUTTON_SOLVE:
                     setState(STATE_SOLVE);
                     break;
                  case BUTTON_SPIN:
                     setState(STATE_POWER);
                     break;
                  case BUTTON_BUY_VOWEL:
                     stateFlags |= STATE_FLAG_VOWEL;
                     money -= VOWEL_COST;
                     setState(STATE_SELECT);
                     break;
               }
               break;
            case STATE_SELECT:
               if ((selectedLetters[numSelected] >= FIRST_LETTER)
                   && (selectedLetters[numSelected] <= LAST_LETTER)
                   && !lettersUsed[selectedLetters[numSelected] - FIRST_LETTER]) {
                  lettersUsed[selectedLetters[numSelected++] - FIRST_LETTER] = true;
                  if ((round.roundNumber == WOFGame.BONUS_ROUND) && (numSelected < NUM_BONUS_CONSONANTS + NUM_BONUS_VOWELS)) {
                     if (numSelected >= NUM_BONUS_CONSONANTS) {
                        selectedLetters[numSelected] = VOWELS[0];
                     }
                     else {
                        selectedLetters[numSelected] = selectedLetters[numSelected - 1];
                     }
                  }
                  else {
                     int val = WHEEL_POSITIONS[round.roundNumber][wheelPosition];
                     if ((jackpotAmount > 0) && ((stateFlags & STATE_FLAG_VOWEL) == 0)
                         && ((val & (JACKPOT_MASK | BANKRUPT_MASK | LOSE_TURN_MASK)) == 0)
                         && (freeSpinTaken || ((val & FREE_SPIN_MASK) == 0))) {
                        jackpotAmount += val & MONEY_MASK;
                     }
                     checkMatches();
                  }
               }
               break;
            case STATE_SOLVE:
               checkChars();
               if (solved) {
                  if ((stateFlags & STATE_FLAG_JACKPOT) != 0) {
                     money += jackpotAmount;
                     jackpotAmount = 0;
                  }
                  setState(STATE_GAME_OVER);
               }
               else if (round.roundNumber != WOFGame.BONUS_ROUND) {
                  turns--;
                  if ((stateFlags & STATE_FLAG_JACKPOT) != 0) {
                     setResults(RESULTS_JACKPOT_LOST);
                  }
                  else {
                     setResults(RESULTS_WRONG_SOLVE);
                  }
               }
               for (int i = WOFRound.NUM_LETTERS; --i >= 0;) {
                  int c = round.letters[i];
                  if ((c >= FIRST_LETTER) && (c <= LAST_LETTER) && !revealed[i]) {
                     if (solved) {
                        revealed[i] = true;
                     }
                     else {
                        currentLetters[i] = LETTER_BLANK;
                     }
                  }
               }
               break;
            case STATE_POWER:
               wheelPosition = (byte) ((wheelPosition + getTrueWheelPower())
                                       % NUM_WHEEL_POSITIONS);
               setState(STATE_SPIN);
               break;
            case STATE_GAME_OVER:
               if ((round.roundNumber == WOFGame.BONUS_ROUND) && ((stateFlags & STATE_FLAG_SHOWING_PRIZE) == 0)) {
                  stateFlags |= STATE_FLAG_SHOWING_PRIZE;
                  ticks = 0;
               }
               else {
                  listener.gameStateChanged(WOFListener.GAME_STATE_GAME_OVER);
               }
               break;
         }
      }
      else if (state == STATE_SELECT) {
         nextChar(keyCode, gameAction);
      }
      else if (state == STATE_SOLVE) {
         if (gameAction == Constants.KEY_LEFT) {
            nextLocation(false);
         }
         else if (gameAction == Constants.KEY_RIGHT) {
            nextLocation(true);
         }
         else {
            nextChar(keyCode, gameAction);
         }
      }
      else if (state == STATE_MAIN) {
         if (gameAction == Constants.KEY_UP) {
            buttonIndex--;
            if (buttonIndex < 0) {
               buttonIndex = 0;
            }
            if ((buttonIndex == 0) && !moreConsonants) {
               buttonIndex = 1;
            }
         }
         else if (gameAction == Constants.KEY_DOWN) {
            buttonIndex++;
            if (buttonIndex > 2) {
               buttonIndex = 2;
            }
            if ((buttonIndex == 2) && ((money < VOWEL_COST) || !moreVowels)) {
               buttonIndex = 1;
            }
         }
      }
   }

   public int getTrueWheelPower() {
      return MIN_POWER_EFFECT + ((MAX_POWER_EFFECT - MIN_POWER_EFFECT)
                                 * getWheelPower()) / MAX_POWER;
   }

   public int getWheelPower() {
      if (state == STATE_POWER) {
         int power = (ticks * WOFConstants.POWER_SPEED) % (2 * MAX_POWER);
         if (power > MAX_POWER) {
            power = 2 * MAX_POWER - power;
         }
         wheelPower = (byte) power;
      }
      return wheelPower;
   }

   public byte getWheelPosition() {
      if (state == STATE_SPIN) {
         int ticksLeft = WOFConstants.SPIN_TICKS - ticks;
         if (ticksLeft > 0) {
            return(byte) (((NUM_WHEEL_POSITIONS << 3) + wheelPosition
                           - (getTrueWheelPower()
                              * ticksLeft * (7 * ticksLeft + WOFConstants.SPIN_TICKS))
                           / (8 * WOFConstants.SPIN_TICKS * WOFConstants.SPIN_TICKS))
                          % NUM_WHEEL_POSITIONS);
         }
         else Resources.stopSound();
      }
      return wheelPosition;
   }

   public void setResults(int results) {
      this.results = (byte) results;
      setState(STATE_RESULTS);
      switch (results) {
         case RESULTS_BANKRUPT:
            listener.handleEvent(WOFListener.EVENT_BANKRUPT);
            break;
         case RESULTS_LOSE_TURN:
            listener.handleEvent(WOFListener.EVENT_LOSE_TURN);
            break;
         case RESULTS_BAD_CHOICE:
            listener.handleEvent(WOFListener.EVENT_NO_MATCHES);
            break;
         case RESULTS_WRONG_SOLVE:
            listener.handleEvent(WOFListener.EVENT_WRONG_ANSWER);
            break;
      }
   }

   /**
    * returns true if time's up
    */
   public boolean updateSecondsLeft() {
      int now = (int) System.currentTimeMillis();
      if ((gameDuration != DURATION_INFINITE) && (gameStartTime != GAME_NOT_STARTED)) {
         if (!solved) {
            secondsLeft = (gameStartTime + gameDuration - now) / 1000;
            if (secondsLeft < 0) {
               secondsLeft = 0;
               return true;
            }
         }
      }
      return false;
   }

   public void update() {
      int now = (int) System.currentTimeMillis();
      if (tickTime + WOFConstants.TICK_TIME - now < 0) {
         tickTime += WOFConstants.TICK_TIME;
         if (tickTime + WOFConstants.TICK_TIME - WOFConstants.MIN_TICK_TIME - now < 0) {
            tickTime = now + WOFConstants.MIN_TICK_TIME - WOFConstants.TICK_TIME;
         }
         ticks++;
      }
      if (updateSecondsLeft() && (state != STATE_GAME_OVER)) {
         setState(STATE_GAME_OVER);
      }
      switch (state) {
         case STATE_START:
            int columns = ticks;
            if (columns > WOFRound.LETTERS_PER_LINE) {
               columns = WOFRound.LETTERS_PER_LINE;
            }
            for (int x = columns; --x >= 0;) {
               for (int y = WOFRound.NUM_LINES; --y >= 0;) {
                  int i = x + y * WOFRound.LETTERS_PER_LINE;
                  byte c = round.letters[i];
                  if ((c >= FIRST_LETTER) && (c <= LAST_LETTER)) {
                     currentLetters[i] = LETTER_BLANK;
                  }
                  else if (c != WOFRound.LETTER_STATE_BLANK) {
                     revealed[i] = true;
                     currentLetters[i] = round.letters[i];
                  }
               }
            }
            if (columns == WOFRound.LETTERS_PER_LINE) {
               setState(STATE_MAIN);
            }
            break;
         case STATE_POWER:
            if (ticks >= WOFConstants.POWER_TIMEOUT_TICKS) {
               setState(STATE_MAIN);
            }
            break;
         case STATE_SPIN:
            int val = WHEEL_POSITIONS[round.roundNumber][wheelPosition];
            if (ticks > WOFConstants.SPIN_TICKS + WOFConstants.SPIN_LINGER_TICKS) {
               //System.out.println("val="+val);
               if ((val & BANKRUPT_MASK) != 0) {
                  money = 0;
                  turns--;
                  setResults(RESULTS_BANKRUPT);
               }
               else if ((val & LOSE_TURN_MASK) != 0) {
                  turns--;
                  setResults(RESULTS_LOSE_TURN);
               }
               else if (round.roundNumber == WOFGame.BONUS_ROUND) {
                  money = WHEEL_POSITIONS[WOFGame.BONUS_ROUND][wheelPosition];
                  checkMatches();
               }
               else {
                  setState(STATE_SELECT);
               }
            }
            break;
         case STATE_RESULTS:
            boolean jackpot = false;
            if (((results == RESULTS_FREE_SPIN_WON)
                 || (results == RESULTS_GOOD_CHOICE)
                 || (results == RESULTS_REVEAL_RSTLNE)
                 || (results == RESULTS_REVEAL_BONUS_LETTERS))
                && (ticks >= WOFConstants.REVEAL_TICKS)) {
               // look for more letters to reveal
               for (int i = 0; i < WOFRound.NUM_LETTERS; i++) {
                  if (currentLetters[i] == LETTER_REVEAL) {
                     currentLetters[i] = round.letters[i];
                     revealed[i] = true;
                     ticks = 0;
                     listener.handleEvent(WOFListener.EVENT_REVEAL_LETTER);
                     return;
                  }
               }
               checkChars();
               jackpot = ((WHEEL_POSITIONS[round.roundNumber][wheelPosition] & JACKPOT_MASK) != 0) && ((stateFlags & STATE_FLAG_VOWEL) == 0);
            }
            else if (ticks < WOFConstants.RESULTS_TICKS) {
               break;
            }
            if ((turns == 0) && hasFreeSpin && (round.roundNumber != WOFGame.BONUS_ROUND)) {
               setState(STATE_FREE_SPIN);
            }
            else if (solved || (turns == 0) || ((gameDuration != DURATION_INFINITE) && (gameStartTime != GAME_NOT_STARTED) && (secondsLeft <= 0))) {
               if (jackpot && solved) {
                  money += jackpotAmount;
                  jackpotAmount = 0;
               }
               setState(STATE_GAME_OVER);
            }
            else if (results == RESULTS_REVEAL_RSTLNE) {
               setState(STATE_SELECT);
            }
            else if (results == RESULTS_REVEAL_BONUS_LETTERS) {
               setState(STATE_SOLVE);
            }
            else if (jackpot) {
               setState(STATE_JACKPOT_SOLVE);
            }
            else {
               setState(STATE_MAIN);
            }
            break;
      }
   }

   public void print() {
      if (round != null) {
         round.print();
      }
      else {
         //System.out.println("round = null");
      }
      /*System.out.println("WOFGameState: " + state);
      System.out.println("moreVowels: " + moreVowels);
      System.out.println("moreConsonants: " + moreConsonants);
      System.out.println("solved: " + solved);
      System.out.println("wheelPower: " + wheelPower);
      System.out.println("wheelPosition: " + wheelPosition);
      System.out.println("waiting: " + waiting);
      System.out.println("stateFlags: " + stateFlags);
      System.out.println("gameDuration: " + gameDuration);
      System.out.println("secondsLeft: " + secondsLeft);
      System.out.println("buttonIndex: " + buttonIndex);
      System.out.println("turns: " + turns);
      System.out.println("hasFreeSpin: " + hasFreeSpin);
      System.out.println("freeSpinTaken: " + freeSpinTaken);
      System.out.println("money: " + money);
      System.out.println("totalMoney: " + totalMoney);
      System.out.println("jackpotAmount: " + jackpotAmount);
      System.out.println("ticks: " + ticks);
      System.out.println("tickTime: " + tickTime);
      System.out.println("gameStartTime: " + gameStartTime);
      System.out.println("currentIndex: " + currentIndex);
      System.out.println("numSelected: " + numSelected);*/
      StringBuffer sBuf = new StringBuffer();

      sBuf.append("revealed: ");
      for (int i = 0; i < revealed.length; i++) {
         sBuf.append(revealed[i] ? 1 : 0);
         sBuf.append(' ');
      }
      //System.out.println(sBuf);
      sBuf.setLength(0);

      sBuf.append("currentLetters: ");
      for (int i = 0; i < currentLetters.length; i++) {
         sBuf.append(currentLetters[i]);
         sBuf.append(' ');
      }
      //System.out.println(sBuf);
      sBuf.setLength(0);

      sBuf.append("lettersUsed: ");
      for (int i = 0; i < lettersUsed.length; i++) {
         sBuf.append(lettersUsed[i] ? 1 : 0);
         sBuf.append(' ');
      }
      //System.out.println(sBuf);
      sBuf.setLength(0);

      sBuf.append("selectedLetters: ");
      for (int i = 0; i < selectedLetters.length; i++) {
         sBuf.append(selectedLetters[i]);
         sBuf.append(' ');
      }
      //System.out.println(sBuf);
      sBuf.setLength(0);
   }
}
