






    





    



/*
 * WOFPack.java
 * Created on Oct 21, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;
/**
 * @author glewis
 */
public class WOFPack {
   public static final int PACKS_PER_DOWNLOAD = (WOFConstants.GAME_VERSION == WOFConstants.VERSION_LARGE) ? 2 : 1;
   public static final int GAMES_PER_DOWNLOAD = (WOFConstants.GAME_VERSION == WOFConstants.VERSION_LARGE) ? 20 : 10;
   public static final int MAX_DESCRIPTION_LENGTH = 200;

   public static final int DATA_SIZE_OVERHEAD = MAX_DESCRIPTION_LENGTH + 10;
   public static final int DATA_SIZE = DATA_SIZE_OVERHEAD * PACKS_PER_DOWNLOAD
                                       + WOFGame.DATA_SIZE  * GAMES_PER_DOWNLOAD;

   public int packID;    
   public WOFGame[] games;
   public int firstGameID;
   public byte numGames;
   public boolean moreGames;
   public byte descriptionLength;
   public byte[] description;

   public WOFPack() {
      games = new WOFGame[GAMES_PER_DOWNLOAD];
      for (int i=GAMES_PER_DOWNLOAD; --i>=0;) {
         games[i] = new WOFGame();
         games[i].pack = this;
      }
      description = new byte[MAX_DESCRIPTION_LENGTH];  
      clear();      
   }

   public void clear() {
      packID = -1;
      firstGameID = -1;
      numGames = 0;
      moreGames = false;
      descriptionLength = 0;
   }

   public void parse(PropertyReader reader) throws IOException {
      clear();
      int gameID = 0;       
      moreGames = true; 
      while (reader.getNameIndex() == WOFData.PROP_PACK_ID) {
         int id = reader.getIntValue();            
         if (packID < 0) {
            packID = id;
            reader.next(false);
            gameID = firstGameID = reader.getIntValue();
         }
         else if (packID != id) {
            moreGames = false;
            break;
         }
         else {
            reader.next(false);
         }
         if (reader.next(false)) {
            // if there's anything else on this line,
            // we'll assume it's the dsc.
            descriptionLength = (byte)reader.propertyValueLength;
            System.arraycopy(reader.propertyValue, 0,
                             description, 0, descriptionLength);
         }
         reader.next(true); 
         games[numGames].gameID = gameID++;
         games[numGames].parse(reader);
         numGames++;
      }
   }
   /*
   public void readObject(DataInputStream in) throws IOException {
       packID = in.readInt();
       firstGameID = in.readInt();
       numGames = in.readByte();
       moreGames = in.readBoolean();
       in.readFully(description);
       descriptionLength = 0;
       while ((description[descriptionLength] != 0)
               && (descriptionLength < MAX_DESCRIPTION_LENGTH)) {
           descriptionLength++;
       }
       for (int i=0; i<numGames; i++) {
           games[i].readObject(in);
           games[i].gameID = firstGameID+i;
       }
   }
   
   public void writeObject(DataOutputStream out) throws IOException {
       out.writeInt(packID);
       out.writeInt(firstGameID);
       out.writeByte(numGames);
       out.writeBoolean(moreGames);
       out.write(description);
       for (int i=0; i<numGames; i++) {
           games[i].writeObject(out);
       }        
   }
   */
   public void writeData(PrintStream out) throws IOException {
      for (int i=0; i<numGames; i++) {
         PropertyReader.print(out, WOFData.PROPERTY_NAMES[WOFData.PROP_PACK_ID], packID);
         PropertyReader.print(out, WOFData.PROPERTY_NAMES[WOFData.PROP_GAME_ID], firstGameID + i);
         if ((i == 0) && (descriptionLength > 0)) {
            PropertyReader.print(out, WOFData.PROPERTY_NAMES[WOFData.PROP_DESCRIPTION], description, descriptionLength);
         }
         out.println();
         games[i].writeData(out);
      }
      out.println();
   }

   public void print() {
      StringBuffer sBuf = new StringBuffer();
      sBuf.append("pack: id=");
      sBuf.append(packID);
      sBuf.append(" first=");
      sBuf.append(firstGameID);
      sBuf.append(" more=");
      sBuf.append(moreGames);
      sBuf.append(" desc=");
      sBuf.append(new String(description, 0, descriptionLength));
      //System.out.println(sBuf);
      sBuf.setLength(0);
      for (int i=0; i<numGames; i++) {
         games[i].print();
      }
   }
}
