






    





    



/*
 * WOFRound.java
 * Created on Oct 18, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;

/**
 * @author glewis
 */
public class WOFRound {
   public static final int LETTERS_PER_LINE = 12;
   public static final int NUM_LINES = 4;
   public static final byte NUM_LETTERS = LETTERS_PER_LINE * NUM_LINES;
   public static final byte LETTER_STATE_BLANK  = '%';
   public static final int MAX_CATEGORY_LEN = 23;

   public static final int DATA_SIZE = NUM_LETTERS + MAX_CATEGORY_LEN;

   public WOFGame game;
   public byte roundNumber;

   public byte categoryLen;
   public byte[] letters = new byte[NUM_LETTERS];
   public byte[] category = new byte[MAX_CATEGORY_LEN];

   public WOFRound(WOFGame game, byte roundNumber) {
      this.game = game;
      this.roundNumber = roundNumber;
   }

   public void parse(PropertyReader reader) throws IOException {
      System.arraycopy(reader.propertyValue, 0, category, 0, reader.propertyValueLength);
      categoryLen = (byte)reader.propertyValueLength;
      reader.next(false);
      for (int i=NUM_LINES; --i>=0;) {
         System.arraycopy(reader.propertyValue, i * (LETTERS_PER_LINE+1),
                          letters, i * LETTERS_PER_LINE, LETTERS_PER_LINE);
      }
      reader.next(true);
   }
/*
    public void readObject(DataInputStream in) throws IOException {
        in.readFully(letters, 0, NUM_LETTERS);
        in.readFully(category);
        categoryLen = 0;
        while ((categoryLen<MAX_CATEGORY_LEN) && (category[categoryLen]!=0)) {
            categoryLen++;
        }
    }
    
    public void writeObject(DataOutputStream out) throws IOException {
        out.write(letters);
        if (categoryLen < MAX_CATEGORY_LEN) {
            category[categoryLen] = 0;
        }
        out.write(category);
    }
    */
   public void writeData(PrintStream out) throws IOException {
      PropertyReader.print(out, WOFData.PROPERTY_NAMES[WOFData.PROP_CATEGORY], category, categoryLen);
      out.print(WOFData.PROPERTY_NAMES[WOFData.PROP_GAME_DATA]);
      out.write('=');
      out.write('\"');
      for (int i=0; i<NUM_LINES; i++) {
         if (i != 0) {
            out.write(' ');
         }
         out.write(letters, i * LETTERS_PER_LINE, LETTERS_PER_LINE);
      }
      out.write('\"');
      out.println();
   }

   public void print() {
      /*System.out.println("round "+roundNumber
                         +": category="
                         + new String(category, 0, categoryLen)
                         + " letters="
                         + new String(letters, 0, NUM_LETTERS));*/
   }
}
