






    





    



/*
 * WOFView.java
 * Created on Nov 8, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;
/**
 * @author glewis
 */
public class WOFView {
   public static final int VALUE_DIVIDER = 100;

   public TextComponent spinButton;
   public TextComponent solveButton;
   public TextComponent vowelButton;
   public TextComponent messageBox;
   public TextComponent turnsBox;
   public TextComponent moneyBox;
   public TextComponent jackpotBox;

   public WOFGameState gameState;
   public AppCanvas canvas;
   public byte[] tempBuf = new byte[10];
   public short halfWidth;
   public short infoBarY;
   public byte boardY;

   public byte turnsCharIndex;
   public byte numMatchingCharIndex;
   public byte noMatchingCharIndex;
   public byte oneMatchingCharIndex;
   public byte manyMatchingCharIndex;
   public byte rstlneCharIndex;
   public byte bonusConsonantsIndex;
   public byte landedOnIndex;

   public WOFView(WOFGameState gameState, AppCanvas canvas) {
      this.gameState = gameState;
      this.canvas = canvas;
      halfWidth = (short)(canvas.width >> 1);
      int bottomBarY = canvas.height - WOFConstants.BOTTOM_BAR_HEIGHT;
      int buttonBottom = WOFConstants.BUTTONS_ON_BOTTOM ? canvas.height : bottomBarY;
      spinButton  = new TextComponent(Resources.strings[WOFConstants.STRING_SPIN], 0, Resources.strings[WOFConstants.STRING_SPIN].length, WOFConstants.GAME_BUTTON_STYLE | TextComponent.FIXED_HEIGHT, WOFConstants.GAME_BUTTON_BORDER,
                                      WOFConstants.BUTTON_COLOR, 0, buttonBottom - WOFConstants.VOWEL_BUTTON_HEIGHT - WOFConstants.SOLVE_BUTTON_HEIGHT - WOFConstants.SPIN_BUTTON_HEIGHT, WOFConstants.SPIN_BUTTON_WIDTH, WOFConstants.SPIN_BUTTON_HEIGHT, true);
      solveButton = new TextComponent(Resources.strings[WOFConstants.STRING_SOLVE], 0, Resources.strings[WOFConstants.STRING_SOLVE].length, WOFConstants.GAME_BUTTON_STYLE | TextComponent.FIXED_HEIGHT, WOFConstants.GAME_BUTTON_BORDER,
                                      WOFConstants.BUTTON_COLOR, 0, buttonBottom - WOFConstants.VOWEL_BUTTON_HEIGHT - WOFConstants.SOLVE_BUTTON_HEIGHT, WOFConstants.SOLVE_BUTTON_WIDTH, WOFConstants.SOLVE_BUTTON_HEIGHT, true);
      vowelButton = new TextComponent(Resources.strings[WOFConstants.STRING_BUY], 0, Resources.strings[WOFConstants.STRING_BUY].length, WOFConstants.GAME_BUTTON_STYLE | TextComponent.FIXED_HEIGHT, WOFConstants.GAME_BUTTON_BORDER,
                                      WOFConstants.BUTTON_COLOR, 0, buttonBottom - WOFConstants.VOWEL_BUTTON_HEIGHT, WOFConstants.VOWEL_BUTTON_WIDTH, WOFConstants.VOWEL_BUTTON_HEIGHT, true);

      bottomBarY += WOFConstants.BOTTOM_BAR_HIGHLIGHT_1_HEIGHT + WOFConstants.BOTTOM_BAR_HIGHLIGHT_2_HEIGHT;
      turnsBox = new TextComponent(Resources.strings[WOFConstants.STRING_TURNS], 0, Resources.strings[WOFConstants.STRING_TURNS].length, WOFConstants.BOTTOM_STYLE, WOFConstants.BOTTOM_BORDER,
                                   WOFConstants.BOTTOM_TEXT_BG_COLOR, WOFConstants.TURNS_X, bottomBarY + WOFConstants.TURNS_Y, WOFConstants.TURNS_W, WOFConstants.TURNS_H, false);
      moneyBox = new TextComponent(tempBuf, 0, 0, WOFConstants.BOTTOM_STYLE, WOFConstants.BOTTOM_BORDER,
                                   WOFConstants.BOTTOM_TEXT_BG_COLOR, WOFConstants.MONEY_X, bottomBarY + WOFConstants.MONEY_Y, WOFConstants.MONEY_W, WOFConstants.MONEY_H, false);
      jackpotBox = new TextComponent(tempBuf, 0, 0, WOFConstants.JACKPOT_STYLE, WOFConstants.BOTTOM_BORDER,
                                     WOFConstants.BOTTOM_TEXT_BG_COLOR, WOFConstants.JACKPOT_X, bottomBarY + WOFConstants.JACKPOT_Y, WOFConstants.JACKPOT_W, WOFConstants.JACKPOT_H, false);

      int gridHeight = (WOFConstants.IMAGE_GRID >= 0) ? Resources.images[WOFConstants.IMAGE_GRID].getHeight() : WOFConstants.BOARD_HEIGHT;
      int infoBarHeight = Resources.images[WOFConstants.IMAGE_INFOBAR].getHeight() + (WOFConstants.USE_SMALL_INFO_BAR ? WOFConstants.MESSAGE_BOX_TOTAL_HEIGHT + WOFConstants.INFO_BAR_OVERLAP : 0);
      infoBarY = (short)(spinButton.y - infoBarHeight - WOFConstants.INFOBAR_GAP);
      if (infoBarY < gridHeight) {
         infoBarY = (short)gridHeight;
      }
      boardY = (byte)((infoBarY - gridHeight) >> 1);

      int w = WOFConstants.USE_SMALL_INFO_BAR ? WOFConstants.MESSAGE_BOX_TOTAL_WIDTH : Resources.images[WOFConstants.IMAGE_INFOBAR].getWidth();
      messageBox = new TextComponent(tempBuf, 0, 0, WOFConstants.MESSAGE_BOX_STYLE,
                                     WOFConstants.MESSAGE_BOX_BORDER, Component.TRANSPARENT,
                                     halfWidth - (w >> 1) + WOFConstants.MESSAGE_BOX_LEFT, 
                                     infoBarY + WOFConstants.MESSAGE_BOX_TOP,
                                     w - WOFConstants.MESSAGE_BOX_LEFT - WOFConstants.MESSAGE_BOX_RIGHT,
                                     WOFConstants.MESSAGE_BOX_HEIGHT,
                                     false);

      turnsCharIndex = WOFApp.indexOf(WOFConstants.STRING_TURNS, WOFApp.NUMBER_WILDCARD);
      numMatchingCharIndex = WOFApp.indexOf(WOFConstants.STRING_THERE_ARE, WOFApp.NUMBER_WILDCARD);
      noMatchingCharIndex = WOFApp.indexOf(WOFConstants.STRING_THERE_ARE_NO, WOFApp.LETTER_WILDCARD);
      oneMatchingCharIndex = WOFApp.indexOf(WOFConstants.STRING_THERE_IS_1, WOFApp.LETTER_WILDCARD);
      manyMatchingCharIndex = WOFApp.indexOf(WOFConstants.STRING_THERE_ARE, WOFApp.LETTER_WILDCARD);
      rstlneCharIndex = WOFApp.indexOf(WOFConstants.STRING_REVEALING, WOFApp.LETTER_WILDCARD);
      bonusConsonantsIndex = WOFApp.indexOf(WOFConstants.STRING_BONUS_CHOOSE_CONSONANTS, WOFApp.NUMBER_WILDCARD);
      landedOnIndex = WOFApp.indexOf(WOFConstants.STRING_LANDED_ON, WOFApp.NUMBER_WILDCARD);
   }

   public void drawWedge(Graphics g, int position, int index) {
      index = (index + WOFGameState.NUM_WHEEL_POSITIONS) % WOFGameState.NUM_WHEEL_POSITIONS;
      int color = WOFGameState.WHEEL_COLORS[gameState.round.roundNumber][index];
      int val = WOFGameState.WHEEL_POSITIONS[gameState.round.roundNumber][index];
      g.setColor(color);
      g.fillArc(WOFConstants.WEDGE_X, WOFConstants.WEDGE_Y,
                WOFConstants.WEDGE_W, WOFConstants.WEDGE_H,
                position * (360 / WOFGameState.NUM_WHEEL_POSITIONS), (360 / WOFGameState.NUM_WHEEL_POSITIONS));
      int imageNum = -1;
      switch (val & ~WOFGameState.MONEY_MASK) {
         case WOFGameState.BANKRUPT_MASK:
            imageNum = WOFConstants.IMAGE_BANKRUPT;
            break;
         case WOFGameState.LOSE_TURN_MASK:
            imageNum = WOFConstants.IMAGE_LOSE_TURN;
            break;
         case WOFGameState.FREE_SPIN_MASK:
            if (!gameState.freeSpinTaken) {
               imageNum = WOFConstants.IMAGE_FREE_SPIN;
            }
            break;
         case WOFGameState.JACKPOT_MASK:
            imageNum = WOFConstants.IMAGE_JACKPOT;
            break;
      }
      if (imageNum >= 0) {
         g.drawImage(Resources.images[imageNum], 1+WOFConstants.WHEEL_ICON_X[position], 1+WOFConstants.WHEEL_ICON_Y[position],
                     Graphics.TOP | Graphics.LEFT);
      }
      else if (gameState.round.roundNumber != WOFGame.BONUS_ROUND) {
         int frameNum = (2*WOFGameState.NUM_WHEEL_POSITIONS + 4 - position) % WOFGameState.NUM_WHEEL_POSITIONS;
         int num = (val & WOFGameState.MONEY_MASK) / VALUE_DIVIDER;
         if (num == 9) {
            num = 6;
            frameNum = (frameNum + (WOFGameState.NUM_WHEEL_POSITIONS / 2)) % WOFGameState.NUM_WHEEL_POSITIONS;
         }
         Image image = Resources.images[WOFConstants.IMAGE_WHEEL_1 + num - 1];
         int frameW = image.getWidth() / (WOFGameState.NUM_WHEEL_POSITIONS / (WOFConstants.USE_HALF_IMAGES ? 2 : 1));
         int oldClipX = g.getClipX();
         int oldClipY = g.getClipY();
         int oldClipW = g.getClipWidth();
         int oldClipH = g.getClipHeight();
         g.clipRect(1+WOFConstants.WHEEL_VAL_X[position], WOFConstants.WHEEL_VAL_Y[position], frameW, 99);
         if (WOFConstants.USE_HALF_IMAGES) {
            boolean flip = (frameNum >= WOFGameState.NUM_WHEEL_POSITIONS / 2);
            if (flip) {
               frameNum -= WOFGameState.NUM_WHEEL_POSITIONS / 2;
            }
            //if (Config.USE_DIRECT_GRAPHICS) {
            //    DirectUtils.getDirectGraphics(g).drawImage(image, 1+WOFConstants.WHEEL_VAL_X[position]-(flip ? (WOFGameState.NUM_WHEEL_POSITIONS / 2 - 1 - frameNum) : frameNum) * frameW, WOFConstants.WHEEL_VAL_Y[position], Graphics.TOP | Graphics.LEFT, flip ? DirectGraphics.ROTATE_180 : 0);
            //} else {
            g.drawImage(image, 1 + WOFConstants.WHEEL_VAL_X[position] - frameNum * frameW, WOFConstants.WHEEL_VAL_Y[position], Graphics.TOP | Graphics.LEFT);
            //}
         }
         else {
            g.drawImage(image, 1 + WOFConstants.WHEEL_VAL_X[position] - frameNum * frameW, WOFConstants.WHEEL_VAL_Y[position], Graphics.TOP | Graphics.LEFT);
         }
         g.setClip(oldClipX, oldClipY, oldClipW, oldClipH);
         if (WOFConstants.USE_ZERO_IMAGES) {
            g.drawImage(Resources.images[WOFConstants.IMAGE_LARGE_ZERO], WOFConstants.WHEEL_LARGE_O_X[position], WOFConstants.WHEEL_LARGE_O_Y[position], Graphics.TOP|Graphics.LEFT);
            g.drawImage(Resources.images[WOFConstants.IMAGE_SMALL_ZERO], WOFConstants.WHEEL_SMALL_O_X[position], WOFConstants.WHEEL_SMALL_O_Y[position], Graphics.TOP|Graphics.LEFT);
         }
         else {
            g.setColor(WOFConstants.WHEEL_O_OUTER_COLOR);
            g.drawArc(1+WOFConstants.WHEEL_LARGE_O_X[position], 1+WOFConstants.WHEEL_LARGE_O_Y[position],
                      WOFConstants.WHEEL_LARGE_O_DIAMETER-1, WOFConstants.WHEEL_LARGE_O_DIAMETER-1, 0, 360);
            g.drawArc(1+WOFConstants.WHEEL_SMALL_O_X[position], 1+WOFConstants.WHEEL_SMALL_O_Y[position],
                      WOFConstants.WHEEL_SMALL_O_DIAMETER-1, WOFConstants.WHEEL_SMALL_O_DIAMETER-1, 0, 360);
            g.setColor(WOFConstants.WHEEL_O_INNER_COLOR);
            g.drawArc(1+WOFConstants.WHEEL_LARGE_O_X[position]+1, 1+WOFConstants.WHEEL_LARGE_O_Y[position]+1,
                      WOFConstants.WHEEL_LARGE_O_DIAMETER-3, WOFConstants.WHEEL_LARGE_O_DIAMETER-3, 0, 360);
            g.drawArc(1+WOFConstants.WHEEL_SMALL_O_X[position]+1, 1+WOFConstants.WHEEL_SMALL_O_Y[position]+1,
                      WOFConstants.WHEEL_SMALL_O_DIAMETER-3, WOFConstants.WHEEL_SMALL_O_DIAMETER-3, 0, 360);
         }
      }
   }

   public void drawWheel(Graphics g, boolean full, boolean toggle) {
      int tx;
      int ty;
      int position = gameState.getWheelPosition() + WOFConstants.WHEEL_PHASE_OFFSET;
      int startArc;
      int arcAngle;
      int startWedge;
      int stopWedge;
      if (full) {
         int pbih = Resources.images[WOFConstants.IMAGE_POWER_BAR].getHeight();
         int baseY = (canvas.height - pbih + WOFConstants.WHEEL_FINAL_RADIUS) / 3;
         if (baseY < WOFConstants.WHEEL_FINAL_RADIUS) {
            baseY = WOFConstants.WHEEL_FINAL_RADIUS;
         }
         Component.clipIn(g, 0, 0, canvas.width, canvas.height-pbih, halfWidth, baseY);
         startArc = 0;
         arcAngle = 360;
         startWedge = 0;
         stopWedge = WOFGameState.NUM_WHEEL_POSITIONS;
         g.setColor(WOFConstants.WHEEL_OUTER_COLOR);
         g.fillArc(-WOFConstants.WHEEL_FINAL_RADIUS, -WOFConstants.WHEEL_FINAL_RADIUS, 
                   2*WOFConstants.WHEEL_FINAL_RADIUS+1,2*WOFConstants.WHEEL_FINAL_RADIUS+1, startArc, arcAngle);
      }
      else {
         if (WOFConstants.IMAGE_WELL >= 0) {
            g.drawImage(Resources.images[WOFConstants.IMAGE_WELL], canvas.width, canvas.height, Graphics.BOTTOM | Graphics.RIGHT);
         }
         Component.clipIn(g, 0, 0, canvas.width, canvas.height, canvas.width+WOFConstants.WHEEL_PARTIAL_X-1, canvas.height+WOFConstants.WHEEL_PARTIAL_Y-1);
         startArc = 90;
         arcAngle = 90;
         startWedge = (WOFGameState.NUM_WHEEL_POSITIONS - 1) / 4;
         stopWedge = (WOFGameState.NUM_WHEEL_POSITIONS + 1) / 2;
      }
      for (int i=startWedge; i<stopWedge; i++) {
         drawWedge(g, i, (position+i+WOFGameState.NUM_WHEEL_POSITIONS)%WOFGameState.NUM_WHEEL_POSITIONS);
      }
      g.setColor(WOFConstants.WHEEL_WEDGE_DIVIDER_COLOR);
      for (int i=0; i<WOFGameState.NUM_WHEEL_POSITIONS; i++) {
         g.drawLine(0, 0, WOFConstants.DIVIDER_X[i], WOFConstants.DIVIDER_Y[i]);
      }
      g.setColor(WOFConstants.WHEEL_INNER_COLOR);
      g.fillArc(-WOFConstants.WHEEL_INNER_RADIUS, -WOFConstants.WHEEL_INNER_RADIUS, 
                2*WOFConstants.WHEEL_INNER_RADIUS,2*WOFConstants.WHEEL_INNER_RADIUS, startArc, arcAngle);
      g.setColor(WOFConstants.WHEEL_INNER_DIVIDER_COLOR);
      g.drawArc(-WOFConstants.WHEEL_INNER_RADIUS, -WOFConstants.WHEEL_INNER_RADIUS, 
                2*WOFConstants.WHEEL_INNER_RADIUS,2*WOFConstants.WHEEL_INNER_RADIUS, startArc, arcAngle);
      g.setColor(WOFConstants.WHEEL_OUTER_DIVIDER_COLOR);
      g.drawArc(-WOFConstants.WHEEL_OUTER_RADIUS, -WOFConstants.WHEEL_OUTER_RADIUS, 
                2*WOFConstants.WHEEL_OUTER_RADIUS,2*WOFConstants.WHEEL_OUTER_RADIUS, startArc, arcAngle);
      if (gameState.round.roundNumber == WOFGame.BONUS_ROUND) {
         g.drawImage(Resources.images[WOFConstants.IMAGE_ENVELOPES],
                     -(Resources.images[WOFConstants.IMAGE_ENVELOPES].getWidth()>>1),
                     -(Resources.images[WOFConstants.IMAGE_ENVELOPES].getHeight()>>1),
                     Graphics.TOP|Graphics.LEFT);
      }
      if (toggle) {
         g.drawImage(Resources.images[WOFConstants.IMAGE_WHEEL_POINTER_2],
                     WOFConstants.POINTER_2_X, WOFConstants.POINTER_2_Y, Graphics.TOP|Graphics.LEFT);
      }
      else {
         g.drawImage(Resources.images[WOFConstants.IMAGE_WHEEL_POINTER_1],
                     WOFConstants.POINTER_1_X, WOFConstants.POINTER_1_Y, Graphics.TOP|Graphics.LEFT);
      }
//g.drawImage(Resources.images[WOFConstants.IMAGE_WELL], -1, -1, Graphics.BOTTOM | Graphics.RIGHT);
      Component.clipOut(g);
   }

   public void drawBoard(Graphics g) {
      int boardX = halfWidth - ((WOFConstants.IMAGE_GRID >= 0) ? (Resources.images[WOFConstants.IMAGE_GRID].getWidth() >> 1) : (WOFConstants.BOARD_WIDTH / 2));
      Component.clipIn(g, boardX, boardY, WOFConstants.BOARD_WIDTH, WOFConstants.BOARD_HEIGHT, boardX, boardY);
      if (WOFConstants.IMAGE_GRID >= 0) {
         g.drawImage(Resources.images[WOFConstants.IMAGE_GRID],
                     0, 0, Graphics.TOP|Graphics.LEFT);
      }
      else
      {
         //g.translate(0,-3);
         //g.setClip(0,0,canvas.width,55);
         g.setColor(WOFConstants.OUTLINE_COLOR_1);
         boolean horizontal;
         for (int i = 0; i < WOFConstants.BOARD_LINES_1.length; i += 4) {
            horizontal = (WOFConstants.BOARD_LINES_1[i] != WOFConstants.BOARD_LINES_1[i+2]);
            g.fillRect(WOFConstants.BOARD_LINES_1[i], WOFConstants.BOARD_LINES_1[i+1], horizontal ? (1 + WOFConstants.BOARD_LINES_1[i+2] - WOFConstants.BOARD_LINES_1[i]) : 1, horizontal ? 1 : (1 + WOFConstants.BOARD_LINES_1[i+3] - WOFConstants.BOARD_LINES_1[i+1])); 
         }
         for (int line=0; line<WOFConstants.NUM_BOARD_LINES - 1; line++) {
            g.setColor(WOFConstants.BOARD_COLORS[line]);
            int x = WOFConstants.BOARD_LINES_2[0] + line;
            int y = WOFConstants.BOARD_LINES_2[1] + line;
            int x2 = x;
            int y2 = y;
            horizontal = true;
            for (int i=2; i<WOFConstants.BOARD_LINES_2.length; i++) {
               if (horizontal) {
                  x2 = WOFConstants.BOARD_LINES_2[i] + ((WOFConstants.BOARD_LINES_2[i] > WOFConstants.BOARD_WIDTH / 2)
                                                        ? -line : line);
               }
               else {
                  y2 = WOFConstants.BOARD_LINES_2[i] + ((WOFConstants.BOARD_LINES_2[i] > WOFConstants.BOARD_HEIGHT / 2)
                                                        ? -line : line);
               }
               int w;
               int h;
               int x1;
               int y1;
               if (x2 > x) {
                  x1 = x;
                  w = 1 + x2 - x;
               }
               else {
                  x1 = x2;
                  w = 1 + x - x2;
               }
               if (y2 > y) {
                  y1 = y;
                  h = 1 + y2 - y;
               }
               else {
                  y1 = y2;
                  h = 1 + y - y2;
               }
               g.fillRect(x1, y1, w, h);
               horizontal = !horizontal;
               x = x2;
               y = y2;
            }
         }
         //g.translate(0,3);
         //g.setClip(0,0,canvas.width,canvas.height);
      }
      int index = 0;
      int y = WOFConstants.FIRST_TILE_Y;
      for (int lineNum=0; lineNum<WOFRound.NUM_LINES; lineNum++) {
         int x = WOFConstants.FIRST_TILE_X;
         for (int letterNum=0; letterNum < WOFRound.LETTERS_PER_LINE; letterNum++) {
            int color;
            byte c = gameState.currentLetters[index];
            if (c == WOFGameState.LETTER_REVEAL) {
               color = WOFConstants.REVEALING_TILE_COLOR;
            }
            else if (c == WOFGameState.LETTER_GAP) {
               color = ((WOFConstants.IMAGE_GRID < 0) && (index != 0) && (index != WOFRound.LETTERS_PER_LINE - 1) && (index != WOFRound.NUM_LETTERS - WOFRound.LETTERS_PER_LINE) && (index != WOFRound.NUM_LETTERS - 1)) ? WOFConstants.BOARD_TILE_COLOR : Component.TRANSPARENT;
            }
            else if ((gameState.currentIndex == index) && (gameState.state == WOFGameState.STATE_SOLVE) && (System.currentTimeMillis() % WOFConstants.BLINK_RATE >= WOFConstants.BLINK_RATE/2)) {
               color = WOFConstants.SELECTED_TILE_COLOR;
            }
            else { 
               color = WOFConstants.TILE_COLOR;
            }
            g.setColor(color);
            if (color != Component.TRANSPARENT) {
               g.fillRect(x, y, WOFConstants.TILE_WIDTH, WOFConstants.TILE_HEIGHT);
               if (c > ' ') {
                  TextComponent.drawChar(g, WOFConstants.BOARD_FONT, x+WOFConstants.BOARD_LETTER_X, y+WOFConstants.BOARD_LETTER_Y, c);
               }
            }
            index++;
            x += WOFConstants.TILE_SPACING_X;
         }
         y += WOFConstants.TILE_SPACING_Y;
      }
      Component.clipOut(g);
   }

   public void setMessage() {
      int index2 = (gameState.ticks / WOFConstants.TICKS_PER_MESSAGE) % 2;
      int index3 = (gameState.ticks / WOFConstants.TICKS_PER_MESSAGE) % 3;
      int message = -1; // -1 = category
      messageBox.bgColor = Component.TRANSPARENT;
      messageBox.setText(null);
      boolean bonus = (gameState.round.roundNumber == WOFGame.BONUS_ROUND);
      int val = WOFGameState.WHEEL_POSITIONS[gameState.round.roundNumber][gameState.wheelPosition];
      switch (gameState.state) {
         case WOFGameState.STATE_MAIN:
            if (bonus) {
               if (index2 == 0) {
                  message = WOFConstants.STRING_SPIN_WHEEL;
               }
            }
            else if (!gameState.moreVowels) {
               if (index3 == 0) {
                  message = WOFConstants.STRING_NO_VOWELS;
               }
               else if (index3 == 1) {
                  message = WOFConstants.STRING_SPIN_SOLVE;
               }
            }
            else if (!gameState.moreConsonants) {
               if (gameState.money < WOFGameState.VOWEL_COST) {
                  if (index2 == 0) {
                     message = WOFConstants.STRING_SOLVE;
                  }
               }
               else {
                  if (index3 == 0) {
                     message = WOFConstants.STRING_ONLY_VOWELS;
                  }
                  else if (index3 == 1) {
                     message = WOFConstants.STRING_BUY_SOLVE;
                  }
               }
            }
            else if (gameState.money < WOFGameState.VOWEL_COST) {
               if (index2 == 0) {
                  message = WOFConstants.STRING_SPIN_SOLVE;
               }
            }
            else {
               if (index2 == 0) {
                  message = WOFConstants.STRING_SPIN_SOLVE_VOWEL;
               }
            }
            break;
         case WOFGameState.STATE_SELECT:
            if (bonus) {
               if (index2 == 0) {
                  if (gameState.numSelected >= WOFGameState.NUM_BONUS_CONSONANTS) {
                     message = WOFConstants.STRING_BONUS_CHOOSE_VOWEL;
                  }
                  else if (gameState.numSelected == WOFGameState.NUM_BONUS_CONSONANTS-1) {
                     message = WOFConstants.STRING_BONUS_CHOOSE_CONSONANT;
                  }
                  else {
                     message = WOFConstants.STRING_BONUS_CHOOSE_CONSONANTS;
                     Resources.strings[WOFConstants.STRING_BONUS_CHOOSE_CONSONANTS][bonusConsonantsIndex] = (byte)('0' + WOFGameState.NUM_BONUS_CONSONANTS - gameState.numSelected); 
                  }
               }
            }
            else if ((gameState.stateFlags & WOFGameState.STATE_FLAG_VOWEL) != 0) {
               if (index2 == 0) {
                  message = WOFConstants.STRING_CHOOSE_VOWEL;
               }
            }
            else {
               if (index3 == 0) {
                  if (((val & WOFGameState.FREE_SPIN_MASK) != 0) && !gameState.freeSpinTaken) {
                     message = WOFConstants.STRING_WIN_FREE_SPIN;
                  }
                  else if ((val & WOFGameState.JACKPOT_MASK) != 0) {
                     message = WOFConstants.STRING_WIN_JACKPOT;
                  }
                  else {
                     message = WOFConstants.STRING_LANDED_ON;
                     Resources.strings[WOFConstants.STRING_LANDED_ON][landedOnIndex] = (byte)('0' + (val & WOFGameState.MONEY_MASK) / VALUE_DIVIDER);
                  }
               }
               else if (index3 == 1) {
                  message = WOFConstants.STRING_CHOOSE_CONSONANT;
               }
            }
            break;
         case WOFGameState.STATE_SOLVE:
            if (index2 == 0) {
               message = WOFConstants.STRING_CHOOSE_LETTERS;
            }
            break;
         case WOFGameState.STATE_JACKPOT_SOLVE:
            break;
         case WOFGameState.STATE_GAME_OVER:
            message = WOFConstants.STRING_CONTINUE;
            if (gameState.solved) {
               messageBox.bgColor = WOFConstants.SUCCESS_COLOR;
               if (bonus) {
                  if (index3 == 0) {
                     message = WOFConstants.STRING_BONUS_CORRECT_1;
                  }
                  else if (index3 == 1) {
                     message = WOFConstants.STRING_BONUS_CORRECT_2;
                  }
               }
               else if ((gameState.round.roundNumber == WOFGame.JACKPOT_ROUND) && (gameState.jackpotAmount == 0)) {
                  if (index3 == 0) {
                     message = WOFConstants.STRING_JACKPOT_WON;
                  }
                  else if (index3 == 1) {
                     message = WOFConstants.STRING_SOLVED;
                  }
               }
               else {
                  if (index2 == 0) {
                     message = WOFConstants.STRING_SOLVED;
                  }
               }
            }
            else {
               messageBox.bgColor = WOFConstants.FAILURE_COLOR;
               if (bonus) {
                  if (index3 == 0) {
                     message = WOFConstants.STRING_BONUS_FAILURE_1;
                  }
                  else if (index3 == 1) {
                     message = WOFConstants.STRING_BONUS_FAILURE_2;
                  }
               }
               else if (index2 == 0) {
                  message = WOFConstants.STRING_OUT_OF_TURNS;
               }
            }
            break;
         case WOFGameState.STATE_RESULTS:
            byte letter = gameState.selectedLetters[0];
            switch (gameState.results) {
               case WOFGameState.RESULTS_BAD_CHOICE:
                  message = WOFConstants.STRING_THERE_ARE_NO;
                  Resources.strings[WOFConstants.STRING_THERE_ARE_NO][noMatchingCharIndex] = letter;
                  messageBox.bgColor = WOFConstants.BAD_COLOR;
                  break;
               case WOFGameState.RESULTS_BANKRUPT:
                  message = WOFConstants.STRING_BANKRUPT;
                  messageBox.bgColor = WOFConstants.BAD_COLOR;
                  break;
               case WOFGameState.RESULTS_FREE_SPIN_LOST:
                  message = WOFConstants.STRING_FREE_SPIN_LOST;
                  messageBox.bgColor = WOFConstants.BAD_COLOR;
                  break;
               case WOFGameState.RESULTS_FREE_SPIN_WON:
                  message = WOFConstants.STRING_FREE_SPIN_WON;
                  messageBox.bgColor = WOFConstants.SUCCESS_COLOR;
                  break;
               case WOFGameState.RESULTS_GOOD_CHOICE:
                  byte count = 0;
                  for (int i=WOFRound.NUM_LETTERS; --i>=0;) {
                     if (gameState.round.letters[i] == letter) {
                        count++;
                     }
                  }
                  if (count == 1) {
                     message = WOFConstants.STRING_THERE_IS_1;
                     Resources.strings[WOFConstants.STRING_THERE_IS_1][oneMatchingCharIndex] = letter;
                  }
                  else {
                     message = WOFConstants.STRING_THERE_ARE;
                     Resources.strings[WOFConstants.STRING_THERE_ARE][numMatchingCharIndex] = (byte)('0' + count);
                     Resources.strings[WOFConstants.STRING_THERE_ARE][manyMatchingCharIndex] = letter;
                  }
                  break;
               case WOFGameState.RESULTS_JACKPOT_LOST:
                  message = WOFConstants.STRING_JACKPOT_LOST;
                  messageBox.bgColor = WOFConstants.BAD_COLOR;
                  break;
               case WOFGameState.RESULTS_LOSE_TURN:
                  message = WOFConstants.STRING_LOST_TURN;
                  messageBox.bgColor = WOFConstants.BAD_COLOR;
                  break;
               case WOFGameState.RESULTS_REVEAL_BONUS_LETTERS:
                  message = WOFConstants.STRING_REVEALING;
                  byte[] msg = Resources.strings[WOFConstants.STRING_REVEALING];
                  for (int i=gameState.numSelected; --i>=0;) {
                     msg[rstlneCharIndex+i] = gameState.selectedLetters[i];    
                  }
                  for (int i=WOFGameState.BONUS_LETTERS.length; --i>=gameState.numSelected;) {
                     msg[rstlneCharIndex+i] = ' ';    
                  }
                  break;
               case WOFGameState.RESULTS_REVEAL_RSTLNE:
                  message = WOFConstants.STRING_REVEALING;
                  for (int i=WOFGameState.BONUS_LETTERS.length; --i>=0;) {
                     Resources.strings[WOFConstants.STRING_REVEALING][rstlneCharIndex+i] = WOFGameState.BONUS_LETTERS[i];
                  }
                  break;
               case WOFGameState.RESULTS_WRONG_SOLVE:
                  message = WOFConstants.STRING_INCORRECT;
                  messageBox.bgColor = WOFConstants.BAD_COLOR;
                  break;
            }
            break;
         default:
            return;
      }
      if (message >= 0) {
         messageBox.setText(Resources.strings[message]);
      }
      else {
         messageBox.setText(gameState.round.category, 0, gameState.round.categoryLen);
      }
   }

   byte wheelTimer;

   public void paint(Graphics g) {

      gameState.updateSecondsLeft();
      int ticks = gameState.ticks;
      int state = gameState.state;
      boolean envelope = (state == WOFGameState.STATE_GAME_OVER) && ((gameState.stateFlags & WOFGameState.STATE_FLAG_SHOWING_PRIZE) != 0);
      int oldState = gameState.oldState;
      byte newPosition = gameState.getWheelPosition();
//        System.out.println("state = " + state);

      if ((state == WOFGameState.STATE_POWER) || (state == WOFGameState.STATE_SPIN) || WOFApp.repaint) {

         if (ticks == 0 || WOFApp.repaint) {
            g.setColor(WOFConstants.BACKGROUND_COLOR);
            g.fillRect(0, 0, canvas.width, canvas.height);
         }
         int x2 = WOFConstants.POWER_BAR_MIN_X2
                  + ((gameState.getWheelPower() - WOFGameState.MIN_POWER)
                     * (WOFConstants.POWER_BAR_MAX_X2-WOFConstants.POWER_BAR_MIN_X2))
                  / (WOFGameState.MAX_POWER - WOFGameState.MIN_POWER);
         int baseX = halfWidth - (Resources.images[WOFConstants.IMAGE_POWER_BAR].getWidth() >> 1);
         int pbih = Resources.images[WOFConstants.IMAGE_POWER_BAR].getHeight();
         int baseY = ((canvas.height - pbih + WOFConstants.WHEEL_FINAL_RADIUS) << 1) / 3;
         if (baseY > canvas.height - pbih) {
            baseY = canvas.height - pbih;
         }
         g.drawImage(Resources.images[WOFConstants.IMAGE_POWER_BAR],
                     baseX, baseY, Graphics.TOP | Graphics.LEFT);
         g.setColor(WOFConstants.POWER_BAR_COLOR);
         g.fillRect(baseX + WOFConstants.POWER_BAR_X1, baseY + WOFConstants.POWER_BAR_Y1,
                    x2 + 1 - WOFConstants.POWER_BAR_X1, WOFConstants.POWER_BAR_Y2 + 1 - WOFConstants.POWER_BAR_Y1);
         g.drawImage(Resources.images[WOFConstants.IMAGE_POWER_POINTER],
                     baseX + x2 + WOFConstants.POWER_INDICATOR_X_OFFSET, baseY + WOFConstants.POWER_INDICATOR_Y,
                     Graphics.TOP | Graphics.LEFT);
         if ((state == WOFGameState.STATE_SPIN) || (ticks % WOFConstants.WHEEL_REDRAW_TICKS == 0) || WOFApp.repaint) {
            drawWheel(g, true, (state == WOFGameState.STATE_SPIN) && ((ticks & 1) == 0) && (gameState.wheelPosition != gameState.getWheelPosition()));
         }

         if (state == WOFGameState.STATE_SPIN && WOFApp.soundSpin>=0)
         {
            if (WOFApp.soundSpin++ > 1)
            {
               WOFApp.soundSpin = -1;
               WOFApp.playSound(WOFConstants.SOUND_SPIN, false);
            }
         }


         if (state == WOFGameState.STATE_SPIN && gameState.wheelPosition == gameState.getWheelPosition())
         {
            wheelTimer++;
            //System.out.println(wheelTimer);
            if (wheelTimer == 5) Resources.stopSound();
         }
         else wheelTimer = 0;
//            System.out.println("WOFView.paint");
         WOFApp.repaint = false;

         return;
      }

//        if (ticks == 0) {
      //System.out.println("state:"+state+" oldState:"+oldState);
      if (state == WOFGameState.STATE_SOLVE || state == WOFGameState.STATE_START || state == WOFGameState.STATE_RESULTS || oldState != state || envelope)
      {
         if (oldState != state || envelope)
         {
            //System.out.println("repaint back");
            g.setColor(WOFConstants.GRID_BG_COLOR);
            g.fillRect(0, 0, canvas.width, infoBarY);
            g.setColor(WOFConstants.BACKGROUND_COLOR);
            g.fillRect(0, infoBarY, canvas.width, canvas.height - infoBarY);
         }
//        }
         // board
         //System.out.println("repaint board");
         drawBoard(g);
      }

      // wheel well when no image provided
      //if (WOFConstants.DRAW_PARTIAL_WHEEL && (WOFConstants.IMAGE_WELL < 0)) {
      //    for (int i=0; i<WOFConstants.WHEEL_WELL_DATA.length; i++) {
      //        g.setColor(WOFConstants.WHEEL_WELL_DATA[i] & 0x00FFFFFF);
      //        g.fillArc(canvas.width+WOFConstants.WHEEL_PARTIAL_X-1-(WOFConstants.WHEEL_WELL_DATA[i] >> 24), canvas.height+WOFConstants.WHEEL_PARTIAL_Y-1-(WOFConstants.WHEEL_WELL_DATA[i] >> 24), (WOFConstants.WHEEL_WELL_DATA[i] >> 23), (WOFConstants.WHEEL_WELL_DATA[i] >> 23), 90, 180);
      //    }
      //}

      // bottom bar
      if (oldState != state || envelope)
      {
         //System.out.println("repaint down");
         int baseY = canvas.height - WOFConstants.BOTTOM_BAR_HEIGHT;
         if (WOFConstants.BOTTOM_BAR_HIGHLIGHT_1_HEIGHT > 0) {
            g.setColor(WOFConstants.BOTTOM_BAR_HIGHLIGHT_1_COLOR);
            g.fillRect(0, baseY, canvas.width, WOFConstants.BOTTOM_BAR_HIGHLIGHT_1_HEIGHT);
            baseY += WOFConstants.BOTTOM_BAR_HIGHLIGHT_1_HEIGHT;
         }
         if (WOFConstants.BOTTOM_BAR_HIGHLIGHT_2_HEIGHT > 0) {
            g.setColor(WOFConstants.BOTTOM_BAR_HIGHLIGHT_2_COLOR);
            g.fillRect(0, baseY, canvas.width, WOFConstants.BOTTOM_BAR_HIGHLIGHT_2_HEIGHT);            
            baseY += WOFConstants.BOTTOM_BAR_HIGHLIGHT_2_HEIGHT;
         }
         g.setColor(WOFConstants.BOTTOM_BAR_COLOR);
         g.fillRect(0, baseY, canvas.width, WOFConstants.BOTTOM_BAR_HEIGHT - WOFConstants.BOTTOM_BAR_HIGHLIGHT_1_HEIGHT - WOFConstants.BOTTOM_BAR_HIGHLIGHT_2_HEIGHT);

         if (gameState.round.roundNumber == WOFGame.BONUS_ROUND) {
            if (gameState.gameDuration != WOFGameState.DURATION_INFINITE) {
               int timeLeft = gameState.secondsLeft;
               tempBuf[0] = (byte)('0' + (timeLeft / 60));
               timeLeft %= 60;
               tempBuf[1] = ':';
               tempBuf[2] = (byte)('0' + (timeLeft / 10));
               timeLeft %= 10;
               tempBuf[3] = (byte)('0' + (timeLeft));
               turnsBox.text = tempBuf;
               turnsBox.textLen = 4;
               turnsBox.zoomAndPaint(g);
            }
         }
         else {
            if (gameState.turns != 1) {
               turnsBox.text = Resources.strings[WOFConstants.STRING_TURNS];
               turnsBox.textLen = (short)turnsBox.text.length;
               turnsBox.text[turnsCharIndex] = (byte)(gameState.turns + '0');
            }
            else {
               turnsBox.text = Resources.strings[WOFConstants.STRING_1_TURN];
               turnsBox.textLen = (short)turnsBox.text.length;
            }
            turnsBox.zoomAndPaint(g);
            WOFApp.setDollars(moneyBox, tempBuf, gameState.money);
            moneyBox.zoomAndPaint(g);
            if (gameState.jackpotAmount > 0) {
               WOFApp.setDollars(jackpotBox, tempBuf, gameState.jackpotAmount);
               jackpotBox.zoomAndPaint(g);
               g.drawImage(Resources.images[WOFConstants.IMAGE_JACKPOT_ICON],
                           WOFConstants.JACKPOT_ICON_X, baseY + WOFConstants.JACKPOT_ICON_Y, Graphics.TOP | Graphics.LEFT);
            }
            if (gameState.hasFreeSpin) {
               g.drawImage(Resources.images[WOFConstants.IMAGE_FREE_SPIN_ICON],
                           spinButton.x + WOFConstants.FREE_SPIN_X, spinButton.y + WOFConstants.FREE_SPIN_Y,
                           Graphics.TOP | Graphics.LEFT);
            }
         }

         //wheel
         if (WOFConstants.DRAW_PARTIAL_WHEEL) {
            drawWheel(g, false, false);
         }
      }
      else if (gameState.round.roundNumber == WOFGame.BONUS_ROUND)
         if (gameState.gameDuration != WOFGameState.DURATION_INFINITE) {
            int timeLeft = gameState.secondsLeft;
            tempBuf[0] = (byte)('0' + (timeLeft / 60));
            timeLeft %= 60;
            tempBuf[1] = ':';
            tempBuf[2] = (byte)('0' + (timeLeft / 10));
            timeLeft %= 10;
            tempBuf[3] = (byte)('0' + (timeLeft));
            turnsBox.text = tempBuf;
            turnsBox.textLen = 4;
            turnsBox.zoomAndPaint(g);
         }


         // top bar
      byte c = -1;
      if (state == WOFGameState.STATE_SELECT) {
         c = gameState.selectedLetters[gameState.numSelected];
         if ((c >= WOFGameState.FIRST_LETTER) && (c <= WOFGameState.LAST_LETTER)) {
            g.setColor(gameState.lettersUsed[c-WOFGameState.FIRST_LETTER]
                       ? WOFConstants.UNAVAILABLE_LETTER_COLOR
                       : WOFConstants.AVAILABLE_LETTER_COLOR);
            g.fillRect(halfWidth + WOFConstants.SELECTION_X,
                       infoBarY + WOFConstants.SELECTION_Y,
                       WOFConstants.SELECTION_W, WOFConstants.SELECTION_H);
         }
         else {
            c = -1;
         }
      }
      if (WOFConstants.USE_SMALL_INFO_BAR) {
         int mx = halfWidth - (WOFConstants.MESSAGE_BOX_WIDTH / 2) - WOFConstants.MESSAGE_BOX_LEFT;
         g.translate(mx, infoBarY);
         int len = WOFConstants.INFO_BAR_DATA.length;
         for (int i = 0; i < len; i++) {
            g.setColor(
                      ((WOFConstants.INFO_BAR_DATA[i] & 0xFF) << 16)
                      | ((WOFConstants.INFO_BAR_DATA[i+1] & 0xFF) << 8)
                      |  (WOFConstants.INFO_BAR_DATA[i+2] & 0xFF));
            for (i+=3; ((i < len) && (WOFConstants.INFO_BAR_DATA[i] >= 0)); i+=4) {
               g.fillRect(WOFConstants.INFO_BAR_DATA[i], WOFConstants.INFO_BAR_DATA[i+1], WOFConstants.INFO_BAR_DATA[i+2], WOFConstants.INFO_BAR_DATA[i+3]);
            }
         }
         g.drawImage(Resources.images[WOFConstants.IMAGE_INFOBAR],
                     (WOFConstants.MESSAGE_BOX_TOTAL_WIDTH - Resources.images[WOFConstants.IMAGE_INFOBAR].getWidth()) >> 1,
                     WOFConstants.MESSAGE_BOX_TOTAL_HEIGHT - WOFConstants.INFO_BAR_OVERLAP, Graphics.TOP | Graphics.LEFT);
         g.translate(-mx, -infoBarY);
      }
      else {
         g.drawImage(Resources.images[WOFConstants.IMAGE_INFOBAR],
                     halfWidth - (Resources.images[WOFConstants.IMAGE_INFOBAR].getWidth() >> 1),
                     infoBarY, Graphics.TOP | Graphics.LEFT);
      }
      if (c >= 0) {
         TextComponent.drawChar(g, gameState.lettersUsed[c-WOFGameState.FIRST_LETTER]
                                ? WOFConstants.SELECTION_CHAR_FONT_UNAVAIL : WOFConstants.SELECTION_CHAR_FONT_AVAIL, 
                                halfWidth + WOFConstants.SELECTION_CHAR_X, infoBarY + WOFConstants.SELECTION_CHAR_Y, c);
      }

      setMessage();
      messageBox.zoomAndPaint(g);

      // button / rstlne area
      boolean blinkOn = (System.currentTimeMillis() % WOFConstants.BLINK_RATE >= WOFConstants.BLINK_RATE/2) && (state == WOFGameState.STATE_MAIN);
      if (state != WOFGameState.STATE_GAME_OVER) {
         if (gameState.round.roundNumber == WOFGame.BONUS_ROUND) {
            if (state == WOFGameState.STATE_MAIN) {
               spinButton.hasFocus = blinkOn;
               spinButton.zoomAndPaint(g);
            }
            else if ((state == WOFGameState.STATE_SELECT) || (state == WOFGameState.STATE_SOLVE) || ((state == WOFGameState.STATE_RESULTS) && (gameState.results == WOFGameState.RESULTS_REVEAL_BONUS_LETTERS))) {
               int x = WOFConstants.BONUS_LETTERS_X;
               int y = canvas.height - WOFConstants.BOTTOM_BAR_HEIGHT + WOFConstants.BONUS_LETTERS_Y;
               for (int i=0; i<gameState.numSelected; i++) {
                  TextComponent.drawChar(g, WOFConstants.BONUS_LETTERS_FONT, x, y, gameState.selectedLetters[i]);
                  x += WOFConstants.FONT_WIDTHS[WOFConstants.BONUS_LETTERS_FONT] + WOFConstants.FONT_HORIZONTAL_SPACINGS[WOFConstants.BONUS_LETTERS_FONT];
               }
               x = WOFConstants.RSTLNE_X;
               y = canvas.height - WOFConstants.BOTTOM_BAR_HEIGHT + WOFConstants.RSTLNE_Y;
               for (int i=0; i<WOFGameState.BONUS_LETTERS.length; i++) {
                  TextComponent.drawChar(g, WOFConstants.BONUS_LETTERS_FONT, x, y, WOFGameState.BONUS_LETTERS[i]);
                  x += WOFConstants.FONT_WIDTHS[WOFConstants.BONUS_LETTERS_FONT] + WOFConstants.FONT_HORIZONTAL_SPACINGS[WOFConstants.BONUS_LETTERS_FONT];
               }
            }
         }
         else {   
            spinButton.hasFocus = (gameState.buttonIndex == WOFGameState.BUTTON_SPIN);
            if (gameState.moreConsonants) {
               spinButton.zoomAndPaint(g);
            }
            solveButton.hasFocus =/* blinkOn &&*/ (gameState.buttonIndex == WOFGameState.BUTTON_SOLVE);
            solveButton.zoomAndPaint(g);
            vowelButton.hasFocus =/* blinkOn &&*/ (gameState.buttonIndex == WOFGameState.BUTTON_BUY_VOWEL);
            if (gameState.moreVowels && (gameState.money >= WOFGameState.VOWEL_COST)) {
               vowelButton.zoomAndPaint(g);
            }
         }
      }

      // envelope
      if ((state == WOFGameState.STATE_GAME_OVER) && ((gameState.stateFlags & WOFGameState.STATE_FLAG_SHOWING_PRIZE) != 0)) {
         int frame = ticks / WOFConstants.TICKS_PER_ENVELOPE_FRAME;
         int dx;
         int dy;
         if (WOFConstants.NUM_ENVELOPE_IMAGES > 0) {
            if (frame >= WOFConstants.NUM_ENVELOPE_FRAMES) {
               frame = WOFConstants.NUM_ENVELOPE_FRAMES-1;
            }
            Image envImage = Resources.images[WOFConstants.IMAGE_ENVELOPE_0 + ((WOFConstants.NUM_ENVELOPE_IMAGES != WOFConstants.NUM_ENVELOPE_FRAMES) ? 0 : frame)];
            int frameW = envImage.getWidth() / ((WOFConstants.NUM_ENVELOPE_IMAGES != WOFConstants.NUM_ENVELOPE_FRAMES) ? WOFConstants.NUM_ENVELOPE_FRAMES : 1);
            dx = halfWidth - (frameW >> 1);
            dy = (canvas.height - envImage.getHeight()) >> 1;
            Component.clipIn(g, dx, dy, frameW, 255, dx, dy);
            g.drawImage(envImage, (WOFConstants.NUM_ENVELOPE_IMAGES != WOFConstants.NUM_ENVELOPE_FRAMES) ? frameW * -frame : 0, 0, Graphics.TOP | Graphics.LEFT);
            if (frame == WOFConstants.NUM_ENVELOPE_FRAMES-1) {
               int len = WOFApp.setDollars(null, tempBuf, gameState.money);
               int tw = TextComponent.getWidth(WOFConstants.PRIZE_FONT, tempBuf, 0, len);
               TextComponent.drawText(g, WOFConstants.PRIZE_FONT, WOFConstants.PRIZE_X - (tw >> 1), WOFConstants.PRIZE_Y - (WOFConstants.FONT_HEIGHTS[WOFConstants.PRIZE_FONT] >> 1), tempBuf, 0, len);
            }
         }
         else {
            if (frame >= WOFConstants.ENVELOPE_DATA.length / 3) {
               frame = WOFConstants.ENVELOPE_DATA.length / 3 - 1;
            }


            dx = halfWidth - ENVELOPE_AREA_WIDTH / 2 + 15;
            dy = ((canvas.height/2 - ENVELOPE_AREA_HEIGHT)>> 1) + 16;






            Component.clipIn(g, dx, dy, ENVELOPE_AREA_WIDTH, ENVELOPE_AREA_HEIGHT, dx, dy);
            int stepX = WOFConstants.ENVELOPE_DATA[frame * 3];
            int stepY = WOFConstants.ENVELOPE_DATA[frame * 3 + 1];
            int height = WOFConstants.ENVELOPE_DATA[frame * 3 + 2];

            int stepHeight = (stepY > 0) ? stepY : -stepY;

            g.setColor(ENVELOPE_BORDER_COLOR);
            g.fillRect(0, 0, ENVELOPE_WIDTH,   ENVELOPE_HEIGHT);
            g.setColor(ENVELOPE_IN_1_COLOR);
            g.fillRect(1, 1, ENVELOPE_WIDTH-2, ENVELOPE_HEIGHT-2);

            int len = WOFApp.setDollars(null, tempBuf, gameState.money);
            int tw = TextComponent.getWidth(WOFConstants.PRIZE_FONT, tempBuf, 0, len);
            TextComponent.drawText(g, WOFConstants.PRIZE_FONT, WOFConstants.PRIZE_X - (tw >> 1), WOFConstants.PRIZE_Y - (WOFConstants.FONT_HEIGHTS[WOFConstants.PRIZE_FONT] >> 1), tempBuf, 0, len);

            g.setColor((stepY > 0) ? ENVELOPE_IN_2_COLOR : ENVELOPE_OUT_COLOR);
            int x = 1;
            int y = ENVELOPE_HEIGHT-1;
            stepHeight = (stepY > 0) ? stepY : -stepY;
            if (stepY < 0) {
               y += stepY;
               x += stepX;
            }
            while (height > 0) {
               g.fillRect(x, y, ENVELOPE_WIDTH - 2, stepHeight);
               x += stepX;
               y += stepY;
               height -= stepHeight;
            }
            if (stepY < 0) {
               y -= stepY;
               x -= stepX;
            }
            g.setColor(ENVELOPE_BORDER_COLOR);
            g.drawLine(0, ENVELOPE_HEIGHT, x, y);
            g.drawLine(ENVELOPE_WIDTH-1, ENVELOPE_HEIGHT, x+ENVELOPE_WIDTH-1, y);
            g.fillRect(x, y, ENVELOPE_WIDTH, 1);
            if (stepY < 0) {
               g.fillRect(0, ENVELOPE_HEIGHT, ENVELOPE_WIDTH, 1);
            }
         }
         Component.clipOut(g);
      }
      if (oldState != state) gameState.oldState = state;
   }


   public static final int ENVELOPE_WIDTH  = 118;
   public static final int ENVELOPE_HEIGHT  = 58;
   public static final int ENVELOPE_AREA_WIDTH = 140;
   public static final int ENVELOPE_AREA_HEIGHT = 106;






   public static final int ENVELOPE_BORDER_COLOR = 0x5B9CCC;
   public static final int ENVELOPE_IN_1_COLOR = 0xCCC671;
   public static final int ENVELOPE_IN_2_COLOR = 0xDED48D;
   public static final int ENVELOPE_OUT_COLOR = 0xB8B35F;
}
