






    





    



/*
 * Window.java
 * Created on Nov 1, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.util.*;

import javax.microedition.lcdui.*;


/**
 * @author glewis
 */
public class Window extends Component {
   public static final int SCROLL_BAR_WIDTH = 6;
   public static final int SCROLL_AMOUNT = 8;
   public static final int MIN_SCROLL_SLIDER_HEIGHT = 10;

   public static final int TITLE_GAP = 2;
   public static final int FOOTER_GAP = 3;
   public static final int BUTTON_AREA_GAP = 3;

   public Component title;
   public Component footer;
   public Component contentArea;
   public Component scrollBarComponent;
   public Component scrollSliderComponent;

   public Component buttonArea;
   public Vector components = new Vector(2,4);
   public Vector buttons = new Vector(1,1);
   public short contentHeight;
   public short footerAreaHeight;
   public short contentAreaHeight;
   public byte maxSpacing;
   public byte numInteractive;
   public boolean valid; // Components layed out, contentHeight valid.    

   public short scrollPosition; // in pixels
   public byte focus; // index among interactive of Component / button with focus

   public Window(Component title, Border border, Border contentBorder, Border scrollAreaBorder, Border sliderBorder, Border buttonAreaBorder, int windowColor, int contentAreaColor,
                 int buttonAreaColor, int scrollBarColor, int scrollSliderColor) {
      super(border, windowColor, 0, 0, 0, 0);
      this.title = title;

      contentArea = new Component(contentBorder, contentAreaColor, 0, 0, 0, 0);        
      scrollBarComponent = new Component(scrollAreaBorder, scrollBarColor, 0, 0, SCROLL_BAR_WIDTH, 0);
      scrollSliderComponent = new Component(sliderBorder, scrollSliderColor, 0, 0, SCROLL_BAR_WIDTH, 0);
      buttonArea = new Component(buttonAreaBorder, buttonAreaColor, 0, 0, 0, 0);
   }

   public void clear() {
      title = null;
      footer = null;
      footerAreaHeight = 0;
      buttons.setSize(0);
      components.setSize(0);
      focus = -1;
      valid = false;
   }

   public void setTitle(Component title) {
      this.title = title;
      valid = false;
   }

   public void setBorder(Border border) {
      if (this.border != border) {
         this.border = border;
         valid = false;
      }
   }

   public void setFooter(Component footer, int footerAreaHeight) {
      this.footer = footer;
      this.footerAreaHeight = (short)footerAreaHeight;
      valid = false;
   }

   public void add(Component c) {
      if (!components.contains(c)) {
         components.addElement(c);
         valid = false;
      }
   }

   public void remove(Component c) {
      if (components.removeElement(c) || buttons.removeElement(c)) {
         valid = false;
      }
   }

   public void addButton(Component c) {
      if (!buttons.contains(c)) {
         buttons.addElement(c);
         valid = false;
      }
   }

   public void setWidth(int width) {
      if (w != width) {
         w = (short)width;
         valid = false;
      }
   }

   public void setHeight(int height) {
      if (h != height) {
         h = (short)height;
         valid = false;
      }
   }

   public Component getFocus() {
      if (focus < 0) {
         return null;
      }
      else if (focus >= numInteractive) {
         return(Component)buttons.elementAt(focus - numInteractive);
      }
      else {
         int ni = focus;
         int index = 0;
         while (true) {
            Component c = (Component)components.elementAt(index++);
            if (c.interactive) {
               if (--ni < 0) {
                  return c;
               }
            }
         }
      }
   }

   public void validateFooter() {
      if ((footer != null) && (footerAreaHeight > 0)) {
         footer.setWidth(w - border.right - border.left);
         footer.x = border.left;
         int bottom = h - border.bottom;
         if (footer.h < footerAreaHeight) {
            footer.y = (short)(bottom - (footerAreaHeight + footer.h) / 2);
         }
         else {
            footer.y = (short)(bottom - footerAreaHeight);
         }
      }
   }

   public void validate() {
      if (!valid) {
         short top = border.top;
         short bottom = (short)(h - border.bottom);
         short left = border.left;
         short right = (short)(w - border.right);
         if (title != null) {
            title.x = left;
            title.y = top;
            title.setWidth(right - left);
            top += title.h + TITLE_GAP;
         }
         if (footerAreaHeight > 0) {
            validateFooter();
            bottom -= footerAreaHeight + FOOTER_GAP;
         }
         int numButtons = buttons.size();
         if (numButtons > 0) {
            buttonArea.x = left;
            buttonArea.w = (short)(right - left);
            int bx = buttonArea.border.left;
            int x1 = bx;
            int bw = buttonArea.w - buttonArea.border.left - buttonArea.border.right;
            int bh = 0;
            for (int i=0; i<numButtons; i++) {                    
               int x2 = bx + (bw * (i+1)) / numButtons;
               Component b = (Component)buttons.elementAt(i);
               b.hasFocus = false;
               b.setWidth(x2-x1);
               b.x = (short)x1;
               b.y = buttonArea.border.top;
               if (bh < b.h) {
                  bh = b.h;
               }
               x1 = x2;
            }
            buttonArea.h = (short)(bh + buttonArea.border.top + buttonArea.border.bottom);
            buttonArea.y = (short)(bottom - buttonArea.h);
            bottom = (short)(buttonArea.y - BUTTON_AREA_GAP);
         }
         contentArea.x = left;
         contentArea.y = top;
         contentArea.w = (short)(right-left);
         contentArea.h = (short)(bottom-top);
         contentAreaHeight = (short)(contentArea.h
                                     - contentArea.border.top
                                     - contentArea.border.bottom);
         int numComponents = components.size();
         int caw = (short)(contentArea.w
                           - contentArea.border.left
                           - contentArea.border.right);
         for (int iter=2; --iter>=0;) {
            contentHeight = 0;
            numInteractive = 0;
            for (int i=0; i<numComponents; i++) {
               Component c = (Component)components.elementAt(i);
               c.setWidth(caw);
               c.x = contentArea.border.left;
               c.y = (short)(contentHeight + contentArea.border.top);
               c.hasFocus = false;
               contentHeight += c.h;
               if (c.interactive) {
                  numInteractive++;
               }
            }
            if (contentHeight <= contentAreaHeight) {
               break;
            }
            else {
               caw -= SCROLL_BAR_WIDTH;                    
            }
         }
         if ((numComponents > 0) && (contentHeight < contentAreaHeight) && (maxSpacing > 0)) {
            int adder = ((contentAreaHeight - contentHeight) / (numComponents + 1));
            if (adder > maxSpacing) {
               adder = maxSpacing;
            }
            int accumulated = adder;
            for (int i=0; i<numComponents; i++) {
               ((Component)components.elementAt(i)).y += accumulated;
               accumulated += adder;
            }
            contentHeight += accumulated;
         }
         if (numInteractive + buttons.size() == 0) {
            focus = -1;
         }
         else if (focus < 0) {
            focus = 0;
         }
         else if (focus >= numInteractive + buttons.size()) {
            focus = (byte)(numInteractive + buttons.size() - 1);
         }
         if (scrollPosition > contentHeight - contentAreaHeight) {
            scrollPosition = (short)(contentHeight - contentAreaHeight);
         }
         if (scrollPosition < 0) {
            scrollPosition = 0;
         }
         setFocus(focus);
         valid = true;
      }
   }

   public void setFocus(int newFocus) {
      Component c = getFocus();
      int oldFocus = focus;
      if (c != null) {
         c.hasFocus = false;
      }
      int numButtons = buttons.size();
      int numTotal = numInteractive + numButtons;
      if (numTotal == 0) {
         focus = -1;
         return;
      }
      else if (newFocus >= numTotal) {
         oldFocus = -1;
         focus = 0;
      }
      else if (newFocus < 0) {
         if (numButtons > 0) {
            focus = (byte)(numInteractive);
         }
         else {
            oldFocus = (byte)numTotal;
            focus = (byte)(numTotal - 1);
         }
      }
      else {
         focus = (byte)newFocus;
      }
      c = getFocus();
      c.hasFocus = true;
      if (focus >= numInteractive) {
         return;
      }
      short csy = (short)(c.y - contentArea.border.top);
      if (c.h > contentAreaHeight) {
         if (focus < oldFocus) {
            scrollPosition = (short)(csy + c.h - contentAreaHeight);
         }
         else if ((focus > oldFocus) || (scrollPosition < csy)) {
            scrollPosition = csy;
         }
         else if (scrollPosition > csy + c.h - contentAreaHeight) {
            scrollPosition = (short)(csy + c.h - contentAreaHeight);
         }
      }
      else if (scrollPosition > csy) {
         scrollPosition = csy;
      }
      else if (scrollPosition < csy + c.h - contentAreaHeight) {
         scrollPosition = (short)(csy + c.h - contentAreaHeight);
      }
   }

   public boolean keyPressed(int gameAction) {
      validate();
      int numButtons = buttons.size();
      int numTotal = numButtons + numInteractive;
      switch (gameAction) {
         case Constants.KEY_DOWN:
            if (numInteractive > 0) {                    
               if (focus < numInteractive) {
                  Component c = getFocus();
                  short csy = (short)(c.y - contentArea.border.top);
                  if (scrollPosition < csy + c.h - contentAreaHeight) {
                     scrollPosition += SCROLL_AMOUNT;
                     if (scrollPosition > csy + c.h - contentAreaHeight) {
                        scrollPosition = (short)(csy + c.h - contentAreaHeight);
                     }
                  }
                  else {
                     setFocus(focus+1);
                  }
               }
               else {
                  setFocus(numTotal);
               }
            }
            else if (contentHeight > contentAreaHeight) {
               scrollPosition += SCROLL_AMOUNT;
               if (scrollPosition > contentHeight - contentAreaHeight) {
                  scrollPosition = (short)(contentHeight - contentAreaHeight);
               }
            }
            break;
         case Constants.KEY_UP:
            if (numInteractive > 0) {                    
               if (focus < numInteractive) {
                  Component c = getFocus();
                  short csy = (short)(c.y - contentArea.border.top);
                  if (scrollPosition > csy) {
                     scrollPosition -= SCROLL_AMOUNT;
                     if (scrollPosition < csy) {
                        scrollPosition = csy;
                     }
                  }
                  else {
                     setFocus(focus-1);
                  }
               }
               else {
                  setFocus(numInteractive-1);
               }
            }
            else {
               scrollPosition -= SCROLL_AMOUNT;
               if (scrollPosition < 0) {
                  scrollPosition = 0;
               }
            }
            break;
         case Constants.KEY_LEFT:
            if (focus == numInteractive) {
               setFocus(numTotal-1);
            }
            else if (focus > numInteractive) {
               setFocus(focus-1);
            }
            break;
         case Constants.KEY_RIGHT:
            if (focus == numTotal-1) {
               setFocus(numInteractive);
            }
            else if (focus >= numInteractive){
               setFocus(focus+1);
            }
            break;
         default:
            return false;
      }
      return true;
   }

   public void paint(Graphics g) {
      validate();
      clipIn(g);
      super.paint(g);

      if (title != null) {
         title.zoomAndPaint(g);
      }
      if (footer != null) {
         footer.zoomAndPaint(g);
      }
      int numButtons = buttons.size();
      if (numButtons > 0) {
         buttonArea.clipIn(g);
         buttonArea.paint(g);
         for (int i=numButtons; --i>=0;) {
            Component c = (Component)buttons.elementAt(i);
            c.zoomAndPaint(g);
         }
         clipOut(g);
      }

      contentArea.clipIn(g);
      contentArea.paint(g);
      g.clipRect(contentArea.border.left, contentArea.border.top,
                 contentArea.w - contentArea.border.left - contentArea.border.right,
                 contentAreaHeight);
      int ty = -scrollPosition;
      if (contentHeight < contentAreaHeight) {
         ty = (contentAreaHeight - contentHeight) / 2;
      }
      g.translate(0, ty);
      for (int i=components.size(); --i>=0;) {
         Component c = (Component)components.elementAt(i);
         short csy = (short)(c.y - contentArea.border.top + ty);
         if (csy < contentAreaHeight) {
            c.zoomAndPaint(g);
            if (csy + c.h < 0) {
               break;
            }
         }
      }
      g.translate(0, -ty);
      if (contentHeight > contentAreaHeight) {
         scrollBarComponent.x = (short)(contentArea.w
                                        - contentArea.border.right
                                        - SCROLL_BAR_WIDTH);
         scrollBarComponent.y = contentArea.border.top;
         scrollBarComponent.h = contentAreaHeight;
         scrollBarComponent.clipIn(g);
         scrollBarComponent.paint(g);
         int sbh = scrollBarComponent.h - scrollBarComponent.border.top - scrollBarComponent.border.bottom; 
         scrollSliderComponent.h = (short)((contentAreaHeight * sbh) / contentHeight);
         if (scrollSliderComponent.h < MIN_SCROLL_SLIDER_HEIGHT) {
            scrollSliderComponent.h = MIN_SCROLL_SLIDER_HEIGHT;
         }
         int gap = sbh - scrollSliderComponent.h;            
         scrollSliderComponent.y = (short)(scrollBarComponent.border.top
                                           + (gap * scrollPosition)
                                           / (contentHeight - contentAreaHeight));
         scrollSliderComponent.zoomAndPaint(g);
         clipOut(g);
      }
      clipOut(g);

      clipOut(g);
   }
}
